/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.combination;

import com.happy3w.java.ext.Pair;
import java.util.ArrayList;
import java.util.List;

public class DimCombineDetail<K, V> {
    private List<Pair<K, V>> normalResult;
    private List<DimCombineDetail<K, V>> overedCombines;
    private int score;
    private int mask;

    public DimCombineDetail(List<Pair<K, V>> normalResult) {
        this.normalResult = normalResult;
    }

    public boolean isOver(DimCombineDetail<K, V> otherResult) {
        if (otherResult == null) {
            return true;
        }
        if (otherResult.mask == this.mask) {
            return false;
        }
        return (this.mask & otherResult.mask) == otherResult.mask;
    }

    public void addOveredCombine(DimCombineDetail<K, V> overedCombine) {
        if (this.overedCombines == null) {
            this.overedCombines = new ArrayList<DimCombineDetail<K, V>>();
        }
        this.overedCombines.add(overedCombine);
    }

    public static <K, V> DimCombineDetailBuilder<K, V> builder() {
        return new DimCombineDetailBuilder();
    }

    public List<Pair<K, V>> getNormalResult() {
        return this.normalResult;
    }

    public List<DimCombineDetail<K, V>> getOveredCombines() {
        return this.overedCombines;
    }

    public int getScore() {
        return this.score;
    }

    public int getMask() {
        return this.mask;
    }

    public void setNormalResult(List<Pair<K, V>> normalResult) {
        this.normalResult = normalResult;
    }

    public void setOveredCombines(List<DimCombineDetail<K, V>> overedCombines) {
        this.overedCombines = overedCombines;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public DimCombineDetail(List<Pair<K, V>> normalResult, List<DimCombineDetail<K, V>> overedCombines, int score, int mask) {
        this.normalResult = normalResult;
        this.overedCombines = overedCombines;
        this.score = score;
        this.mask = mask;
    }

    public static class DimCombineDetailBuilder<K, V> {
        private List<Pair<K, V>> normalResult;
        private List<DimCombineDetail<K, V>> overedCombines;
        private int score;
        private int mask;

        DimCombineDetailBuilder() {
        }

        public DimCombineDetailBuilder<K, V> normalResult(List<Pair<K, V>> normalResult) {
            this.normalResult = normalResult;
            return this;
        }

        public DimCombineDetailBuilder<K, V> overedCombines(List<DimCombineDetail<K, V>> overedCombines) {
            this.overedCombines = overedCombines;
            return this;
        }

        public DimCombineDetailBuilder<K, V> score(int score) {
            this.score = score;
            return this;
        }

        public DimCombineDetailBuilder<K, V> mask(int mask) {
            this.mask = mask;
            return this;
        }

        public DimCombineDetail<K, V> build() {
            return new DimCombineDetail<K, V>(this.normalResult, this.overedCombines, this.score, this.mask);
        }

        public String toString() {
            return "DimCombineDetail.DimCombineDetailBuilder(normalResult=" + this.normalResult + ", overedCombines=" + this.overedCombines + ", score=" + this.score + ", mask=" + this.mask + ")";
        }
    }
}

