/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.combination;

import com.happy3w.math.util.IndexMapper;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class GroupCombinationMaker<T> {
    private IndexMapper<T> mapper;

    public GroupCombinationMaker(T[] baseValues, BiPredicate<T, T> equalChecker) {
        this.mapper = new IndexMapper<T>(baseValues, equalChecker);
    }

    public Stream<T[][]> makeByItemCounts(int[] itemCountsInGroup) {
        int[] startValues = this.mapper.createStartValues();
        return StreamSupport.stream(new GroupCombineSpliterator(startValues, itemCountsInGroup), false).map(this::convertValues);
    }

    private T[][] convertValues(int[][] combineResult) {
        Object[][] result = (Object[][])Array.newInstance(this.mapper.getMetaValues().getClass(), combineResult.length);
        for (int i = 0; i < combineResult.length; ++i) {
            result[i] = this.mapper.convertValues(combineResult[i]);
        }
        return result;
    }

    private static class GroupItem {
        private int startIndex;
        private int endIndex;
        private int count;
        private long weight;

        public GroupItem(int startIndex, int count) {
            this.startIndex = startIndex;
            this.count = count;
            this.endIndex = startIndex + count;
        }

        public void updateWeight(int[] values) {
            long weight = 0L;
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                weight |= 1L << values[i];
            }
            this.weight = weight;
        }
    }

    private static class GroupCombineSpliterator
    extends Spliterators.AbstractSpliterator<int[][]> {
        private int[] groupMap;
        private int[] startValue;
        private GroupItem[] groupItems;
        private int[] currentValue;

        protected GroupCombineSpliterator(int[] startValue, int[] itemCountsInGroup) {
            super(0L, 0);
            this.startValue = startValue;
            this.groupMap = new int[startValue.length];
            this.groupItems = new GroupItem[itemCountsInGroup.length];
            int startIndex = 0;
            for (int i = 0; i < this.groupItems.length; ++i) {
                int count = itemCountsInGroup[i];
                Arrays.fill(this.groupMap, startIndex, startIndex + count, i);
                this.groupItems[i] = new GroupItem(startIndex, count);
                startIndex += count;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super int[][]> action) {
            if (this.currentValue == null) {
                this.currentValue = this.startValue;
            } else {
                int[] nextValue = this.next(this.currentValue);
                if (nextValue == null) {
                    return false;
                }
                this.currentValue = nextValue;
            }
            int[][] result = this.convertResult(this.currentValue, this.groupItems);
            action.accept((int[][])result);
            return true;
        }

        private int[][] convertResult(int[] values, GroupItem[] groupItems) {
            int[][] result = new int[groupItems.length][];
            for (int i = 0; i < groupItems.length; ++i) {
                GroupItem item = groupItems[i];
                result[i] = Arrays.copyOfRange(values, item.startIndex, item.startIndex + item.count);
            }
            return result;
        }

        private int[] next(int[] values) {
            do {
                if ((values = this.tryFindNext(values)) != null) continue;
                return null;
            } while (this.duplicateResult(this.groupItems));
            return values;
        }

        private int[] tryFindNext(int[] values) {
            for (int index = values.length - 2; index >= 0; --index) {
                int indexMinBigValue = this.findMinBigValue(values, index);
                if (indexMinBigValue < 0) continue;
                this.switchValue(values, index, indexMinBigValue);
                this.sortPart(values, index, indexMinBigValue);
                this.updateGroupWeight(values, this.groupMap[index]);
                return values;
            }
            return null;
        }

        private boolean duplicateResult(GroupItem[] groupItems) {
            for (int curIndex = groupItems.length - 1; curIndex > 0; --curIndex) {
                GroupItem curItem = groupItems[curIndex];
                for (int checkIndex = curIndex - 1; checkIndex >= 0; --checkIndex) {
                    GroupItem checkItem = groupItems[checkIndex];
                    if (curItem.count != checkItem.count || curItem.weight >= checkItem.weight) continue;
                    return true;
                }
            }
            return false;
        }

        private void updateGroupWeight(int[] values, int startGroup) {
            for (int i = startGroup; i < this.groupItems.length; ++i) {
                this.groupItems[i].updateWeight(values);
            }
        }

        private void sortPart(int[] values, int startIndex, int exceptIndex) {
            int curGroupIndex = this.groupMap[startIndex];
            GroupItem curGroupItem = this.groupItems[curGroupIndex];
            for (int index = startIndex; index < curGroupItem.endIndex - 1; ++index) {
                int indexMinBigValue = this.findMinBigValue(values, index);
                if (indexMinBigValue < 0 || indexMinBigValue == index + 1) continue;
                this.switchValue(values, index + 1, indexMinBigValue);
            }
            Arrays.sort(values, curGroupItem.endIndex, values.length);
        }

        private void switchValue(int[] values, int indexA, int indexB) {
            int a = values[indexA];
            values[indexA] = values[indexB];
            values[indexB] = a;
        }

        private int findMinBigValue(int[] values, int startIndex) {
            int curValue = values[startIndex];
            int curGroup = this.groupMap[startIndex];
            int minBigValueIndex = -1;
            int minBigValue = Integer.MAX_VALUE;
            for (int index = startIndex + 1; index < values.length; ++index) {
                int value;
                int group = this.groupMap[index];
                if (group == curGroup || (value = values[index]) <= curValue || value >= minBigValue) continue;
                minBigValueIndex = index;
                minBigValue = value;
            }
            return minBigValueIndex;
        }
    }
}

