/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.combination;

import java.util.Arrays;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class GroupMaker {
    public static Stream<int[]> make(int dataSize, int groupSize) {
        return StreamSupport.stream(new GroupSpliterator(dataSize, groupSize), false);
    }

    public static class GroupSpliterator
    extends Spliterators.AbstractSpliterator<int[]> {
        private int dataSize;
        private int groupSize;
        private int[] currentValue;

        protected GroupSpliterator(int dataSize, int groupSize) {
            super(0L, 0);
            this.dataSize = dataSize;
            this.groupSize = groupSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super int[]> action) {
            if (this.currentValue == null) {
                this.currentValue = this.initValue();
            } else {
                int[] nextValue = this.next(this.currentValue);
                if (nextValue == null) {
                    return false;
                }
                this.currentValue = nextValue;
            }
            action.accept((int[])Arrays.copyOf(this.currentValue, this.currentValue.length));
            return true;
        }

        private int[] next(int[] values) {
            int locInc = this.findIncreaseAbleLocation(values);
            if (locInc < 0) {
                return null;
            }
            int standardValue = values[locInc] + 1;
            int remainValue = 0;
            for (int index = values.length - 2; index >= locInc; --index) {
                remainValue += values[index] - standardValue;
                values[index] = standardValue;
            }
            int n = values.length - 1;
            values[n] = values[n] + remainValue;
            return values;
        }

        private int findIncreaseAbleLocation(int[] values) {
            int lastValue = values[values.length - 1];
            for (int digIndex = values.length - 2; digIndex >= 0; --digIndex) {
                int digValue = values[digIndex];
                if (digValue + 2 > lastValue) continue;
                return digIndex;
            }
            return -1;
        }

        private int[] initValue() {
            int[] newValue = new int[this.groupSize];
            Arrays.fill(newValue, 1);
            newValue[this.groupSize - 1] = this.dataSize - this.groupSize + 1;
            return newValue;
        }
    }
}

