/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.combination;

import com.happy3w.java.ext.NeedFindIterator;
import com.happy3w.java.ext.NullableOptional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class NormalCombineMaker<T> {
    private final List<T> values;

    public NormalCombineMaker(List<T> values) {
        this.values = values;
    }

    public Iterator<List<T>> combineIterator(int count) {
        return new CombineIterator<T>(this.values, count);
    }

    public Stream<List<T>> combineStream(int count) {
        Iterator<List<T>> it = this.combineIterator(count);
        return StreamSupport.stream(Spliterators.spliterator(it, Long.MAX_VALUE, 0), false);
    }

    private static class CombineIterator<T>
    extends NeedFindIterator<List<T>> {
        private final List<T> values;
        private int[] indexes;

        protected CombineIterator(List<T> values, int count) {
            this.values = values;
            this.indexes = this.initIndexes(count);
            this.nextItem = this.createCombineResult();
            this.status = NeedFindIterator.IteratorStatus.found;
        }

        private int[] initIndexes(int count) {
            int[] indexes = new int[count];
            for (int i = 0; i < count; ++i) {
                indexes[i] = i;
            }
            return indexes;
        }

        private boolean increaseIndexes() {
            int nextPos;
            int curIndex;
            int maxPos = this.values.size() - this.indexes.length;
            for (curIndex = this.indexes.length - 1; curIndex >= 0 && (nextPos = this.indexes[curIndex] + 1) > maxPos + curIndex; --curIndex) {
            }
            if (curIndex < 0) {
                return false;
            }
            int curPos = this.indexes[curIndex];
            while (curIndex < this.indexes.length) {
                this.indexes[curIndex] = ++curPos;
                ++curIndex;
            }
            return true;
        }

        protected NullableOptional<List<T>> findNext() {
            boolean hasNext = this.increaseIndexes();
            if (hasNext) {
                return NullableOptional.of(this.createCombineResult());
            }
            return NullableOptional.empty();
        }

        private List<T> createCombineResult() {
            ArrayList<T> combineResult = new ArrayList<T>();
            for (int index : this.indexes) {
                combineResult.add(this.values.get(index));
            }
            return combineResult;
        }
    }
}

