/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.graph;

import com.happy3w.math.graph.GraphEdge;
import com.happy3w.math.graph.GraphNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;

public class CircleInfo<NK> {
    private List<NK> pathFromParent;
    private Set<NK> circle;
    private Stack<NK> outNodeStack = new Stack();

    public static <NK> CircleInfo<NK> createNewCircle(List<NK> idPath, NK curId, Function<NK, GraphNode<NK, ?, ?, ?>> nodeMapper) {
        int index = idPath.indexOf(curId);
        if (index < 0) {
            return null;
        }
        CircleInfo<NK> info = new CircleInfo<NK>();
        info.pathFromParent = new ArrayList<NK>(idPath.subList(0, index));
        info.circle = new HashSet<NK>(idPath.subList(index, idPath.size()));
        super.rebuildOutNodes(nodeMapper);
        return info;
    }

    public static <NK> boolean mergeIntoBigCircle(List<NK> idPath, NK curId, List<CircleInfo<NK>> candidateCircles, Function<NK, GraphNode<NK, ?, ?, ?>> nodeMapper) {
        for (int i = candidateCircles.size() - 1; i >= 0; --i) {
            CircleInfo<NK> curCircle = candidateCircles.get(i);
            if (!super.mergePath(curId, idPath)) continue;
            while (candidateCircles.size() > i + 1) {
                int lastIndex = candidateCircles.size() - 1;
                CircleInfo<NK> lastCircle = candidateCircles.get(lastIndex);
                super.mergeCircle(lastCircle);
                candidateCircles.remove(lastIndex);
            }
            super.rebuildOutNodes(nodeMapper);
            return true;
        }
        return false;
    }

    private boolean mergePath(NK curId, List<NK> idPath) {
        if (this.circle.contains(curId)) {
            this.circle.addAll(idPath);
            return true;
        }
        int pos = this.pathFromParent.indexOf(curId);
        if (pos >= 0) {
            this.circle.addAll(idPath);
            this.circle.addAll(this.pathFromParent.subList(pos, this.pathFromParent.size()));
            this.pathFromParent = new ArrayList<NK>(this.pathFromParent.subList(0, pos));
            return true;
        }
        return false;
    }

    private void mergeCircle(CircleInfo<NK> otherCircle) {
        this.circle.addAll(otherCircle.circle);
        this.circle.addAll(otherCircle.pathFromParent);
    }

    private void rebuildOutNodes(Function<NK, GraphNode<NK, ?, ?, ?>> nodeMapper) {
        this.outNodeStack.clear();
        this.circle.stream().map(nodeMapper).flatMap(m -> m.outcomeStream().map(GraphEdge::getTo)).distinct().filter(nodeCode -> nodeMapper.apply(nodeCode) != null && !this.circle.contains(nodeCode)).forEach(this.outNodeStack::push);
    }

    public NK nextNewStartNode() {
        return this.outNodeStack.isEmpty() ? null : (NK)this.outNodeStack.pop();
    }

    public List<NK> getPathFromParent() {
        return this.pathFromParent;
    }

    public Set<NK> getCircle() {
        return this.circle;
    }
}

