/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.graph;

import com.happy3w.java.ext.stream.ParallelSpliterator;
import com.happy3w.math.graph.GraphEdge;
import com.happy3w.math.graph.GraphNode;
import com.happy3w.math.graph.LeafBatchIterator;
import com.happy3w.math.graph.ScIterator;
import com.happy3w.math.graph.ScNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DirectGraph<NK, NV, EK, EV> {
    private Map<NK, GraphNode<NK, NV, EK, EV>> nodes;

    public DirectGraph() {
        this.nodes = new HashMap<NK, GraphNode<NK, NV, EK, EV>>();
    }

    public DirectGraph(int initialCapacity) {
        this.nodes = new HashMap<NK, GraphNode<NK, NV, EK, EV>>(initialCapacity);
    }

    public GraphNode<NK, NV, EK, EV> takeNode(NK id, NV value) {
        return this.takeNode(id, () -> value);
    }

    public GraphNode<NK, NV, EK, EV> takeNode(NK id, Supplier<NV> valueSupplier) {
        return this.nodes.computeIfAbsent(id, key -> new GraphNode(id).withValue(valueSupplier.get()));
    }

    public GraphNode<NK, NV, EK, EV> takeNode(NK id) {
        return this.nodes.computeIfAbsent(id, key -> new GraphNode(id));
    }

    public Stream<GraphNode<NK, NV, EK, EV>> nodeStream() {
        return this.nodes.values().stream();
    }

    public Stream<NV> nodeValueStream() {
        return this.nodes.values().stream().map(GraphNode::getValue);
    }

    public NV nodeValue(NK nodeId) {
        GraphNode<NK, NV, EK, EV> node = this.nodes.get(nodeId);
        return node == null ? null : (NV)node.getValue();
    }

    public Stream<GraphEdge<EK, EV, NK>> outcomes(NK id) {
        GraphNode<NK, NV, EK, EV> node = this.nodes.get(id);
        if (node == null) {
            return Stream.empty();
        }
        return node.outcomeStream();
    }

    public void acceptEdge(GraphEdge<EK, EV, NK> edge) {
        this.takeNode(edge.getFrom()).withOutcome(edge);
        this.takeNode(edge.getTo()).withIncome(edge);
    }

    public void acceptNodes(List<GraphNode<NK, NV, EK, EV>> newNodes) {
        for (GraphNode<NK, NV, EK, EV> node : newNodes) {
            this.nodes.put(node.getId(), node);
        }
    }

    public void acceptNode(GraphNode<NK, NV, EK, EV> newNode) {
        this.nodes.put(newNode.getId(), newNode);
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public GraphNode<NK, NV, EK, EV> node(NK nodeId) {
        return this.nodes.get(nodeId);
    }

    public void initIncomeWithOutcome() {
        this.nodeStream().flatMap(GraphNode::outcomeStream).forEach(outcome -> this.node(outcome.getTo()).withIncome(outcome));
    }

    public void initOutcomeWithIncome() {
        this.nodeStream().flatMap(GraphNode::incomeStream).forEach(income -> this.node(income.getFrom()).withOutcome(income));
    }

    public DirectGraph<NK, NV, EK, EV> filterNodes(Predicate<GraphNode<NK, NV, EK, EV>> nodeChecker) {
        for (GraphNode<NK, NV, EK, EV> node : new ArrayList<GraphNode<NK, NV, EK, EV>>(this.nodes.values())) {
            if (nodeChecker.test(node)) continue;
            this.cleanRelation(node);
            this.nodes.remove(node.getId());
        }
        return this;
    }

    private void cleanRelation(GraphNode<NK, NV, EK, EV> node) {
        node.incomeStream().forEach(income -> this.node(income.getFrom()).removeOutcome(income));
        node.outcomeStream().forEach(outcome -> this.node(outcome.getTo()).removeIncome(outcome));
    }

    public DirectGraph<NK, NV, EK, EV> cutSubGraph(Collection<NK> startIds, Function<GraphNode<NK, NV, EK, EV>, Stream<NK>> spreadLogic) {
        Set idsInPath = this.collectIdInPath(startIds, spreadLogic);
        return this.filterNodes(item -> idsInPath.contains(item.getId()));
    }

    public Set<NK> collectIdInPath(Collection<NK> startIds, Function<GraphNode<NK, NV, EK, EV>, Stream<NK>> spreadLogic) {
        HashSet idsInPath = new HashSet();
        Stack<NK> accNodeIdStack = new Stack<NK>();
        accNodeIdStack.addAll(startIds);
        while (!accNodeIdStack.isEmpty()) {
            Object nodeId = accNodeIdStack.pop();
            idsInPath.add(nodeId);
            spreadLogic.apply(this.node(nodeId)).filter(fromId -> !idsInPath.contains(fromId)).forEach(accNodeIdStack::push);
        }
        return idsInPath;
    }

    public Iterator<ScNode<NK, NV, EK, EV>> scIterator() {
        return new ScIterator<NK, NV, EK, EV>(this.nodes);
    }

    public Stream<ScNode<NK, NV, EK, EV>> scNodeStream() {
        return StreamSupport.stream(new ParallelSpliterator(this.scIterator(), 16), false);
    }

    public Iterator<List<GraphNode<NK, NV, EK, EV>>> leafBatchIterator() {
        return new LeafBatchIterator<NK, NV, EK, EV>(this.nodes, node -> node.outcomeStream().map(GraphEdge::getTo));
    }

    public Iterator<List<GraphNode<NK, NV, EK, EV>>> leafBatchReverseIterator() {
        return new LeafBatchIterator<NK, NV, EK, EV>(this.nodes, node -> node.incomeStream().map(GraphEdge::getFrom));
    }

    public Stream<List<GraphNode<NK, NV, EK, EV>>> leafBatchStream() {
        return StreamSupport.stream(new ParallelSpliterator(this.leafBatchIterator(), 16), false);
    }

    public Stream<List<GraphNode<NK, NV, EK, EV>>> leafBatchReverseStream() {
        return StreamSupport.stream(new ParallelSpliterator(this.leafBatchReverseIterator(), 16), false);
    }

    public DirectGraph<Long, ScNode<NK, NV, EK, EV>, Long, Long> createScGraph() {
        return this.createScGraph(this.nodes);
    }

    public DirectGraph<Long, ScNode<NK, NV, EK, EV>, Long, Long> createScGraph(Predicate<GraphNode<NK, NV, EK, EV>> nodeSelector) {
        Map subNodes = this.nodes.values().stream().filter(nodeSelector).collect(Collectors.toMap(GraphNode::getId, Function.identity()));
        return this.createScGraph(subNodes);
    }

    public DirectGraph<Long, ScNode<NK, NV, EK, EV>, Long, Long> createScGraph(Map<NK, GraphNode<NK, NV, EK, EV>> subNodes) {
        DirectGraph<Long, ScNode<NK, NV, EK, EV>, Long, Long> scGraph = new DirectGraph<Long, ScNode<NK, NV, EK, EV>, Long, Long>(this.nodeCount());
        Map<NK, Long> nodeToScMap = this.fillScNodeIntoScGraph(scGraph, subNodes);
        this.fillScEdgeIntoScGraph(scGraph, nodeToScMap, subNodes);
        return scGraph;
    }

    private void fillScEdgeIntoScGraph(DirectGraph<Long, ScNode<NK, NV, EK, EV>, Long, Long> scGraph, Map<NK, Long> nodeToScMap, Map<NK, GraphNode<NK, NV, EK, EV>> subNodes) {
        AtomicLong idHolder = new AtomicLong(0L);
        subNodes.values().stream().flatMap(GraphNode::outcomeStream).map(edge -> new GraphEdge(idHolder.incrementAndGet(), nodeToScMap.get(edge.getFrom()), nodeToScMap.get(edge.getTo()), 0L)).filter(edge -> edge.getFrom() != null && edge.getTo() != null && !((Long)edge.getFrom()).equals(edge.getTo())).forEach(edge -> {
            GraphNode from = scGraph.node((Long)edge.getFrom());
            if (!from.outcomeStream().anyMatch(e -> ((Long)e.getTo()).equals(edge.getTo()))) {
                from.withOutcome(edge);
            }
        });
        scGraph.initIncomeWithOutcome();
    }

    private Map<NK, Long> fillScNodeIntoScGraph(DirectGraph<Long, ScNode<NK, NV, EK, EV>, Long, Long> scGraph, Map<NK, GraphNode<NK, NV, EK, EV>> subNodes) {
        HashMap nodeToScMap = new HashMap(subNodes.size());
        AtomicLong idHolder = new AtomicLong(0L);
        ScIterator<NK, NV, EK, EV> scIt = new ScIterator<NK, NV, EK, EV>(subNodes);
        while (scIt.hasNext()) {
            ScNode scNode = (ScNode)scIt.next();
            GraphNode newGraphNode = new GraphNode(idHolder.incrementAndGet()).withValue(scNode);
            scGraph.acceptNode(newGraphNode);
            for (GraphNode node : scNode.nodeList()) {
                nodeToScMap.put(node.getId(), newGraphNode.getId());
            }
        }
        return nodeToScMap;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void distributeByIncome(BiFunction<NV, NV, Boolean> distributeLogic) {
        Set<NK> changedNodes = new HashSet<NK>(this.nodes.keySet());
        while (!changedNodes.isEmpty()) {
            changedNodes = this.distributeInfoToParent(changedNodes, this.nodes, distributeLogic);
        }
    }

    private Set<NK> distributeInfoToParent(Set<NK> nodeIds, Map<NK, GraphNode<NK, NV, EK, EV>> nodeMap, BiFunction<NV, NV, Boolean> distributeLogic) {
        HashSet changedNodes = new HashSet();
        for (NK nodeId : nodeIds) {
            GraphNode node = nodeMap.get(nodeId);
            node.incomeStream().forEach(income -> {
                GraphNode from = (GraphNode)nodeMap.get(income.getFrom());
                if (((Boolean)distributeLogic.apply(node.getValue(), from.getValue())).booleanValue()) {
                    changedNodes.add(from.getId());
                }
            });
        }
        return changedNodes;
    }

    public void removeEdge(GraphEdge<EK, EV, NK> edge) {
        this.nodes.get(edge.getFrom()).getOutcomes().remove(edge.getId());
        GraphNode<NK, NV, EK, EV> to = this.nodes.get(edge.getTo());
        Map<EK, GraphEdge<EK, EV, NK>> incomes = to.getIncomes();
        if (incomes != null) {
            incomes.remove(edge.getId());
        }
    }

    public void mergeNode(GraphNode<NK, NV, EK, EV> mainNode, GraphNode<NK, NV, EK, EV> subNode) {
        NK mainId = mainNode.getId();
        List outcomes = subNode.getOutcomes() == null ? Collections.emptyList() : subNode.getOutcomes().values();
        for (GraphEdge edge : new ArrayList(outcomes)) {
            this.removeEdge(edge);
            GraphEdge newEdge = new GraphEdge(edge.getId(), mainId, edge.getTo(), edge.getValue());
            this.acceptEdge(newEdge);
        }
        List incomes = subNode.getIncomes() == null ? Collections.emptyList() : subNode.getIncomes().values();
        for (GraphEdge edge : new ArrayList(incomes)) {
            this.removeEdge(edge);
            GraphEdge newEdge = new GraphEdge(edge.getId(), edge.getFrom(), mainId, edge.getValue());
            this.acceptEdge(newEdge);
        }
        this.nodes.remove(subNode.getId());
    }

    public DirectGraph<NK, NV, EK, EV> cloneGraph() {
        DirectGraph<NK, NV, EK, EV> graph = new DirectGraph<NK, NV, EK, EV>();
        for (GraphNode<NK, NV, EK, EV> node : this.nodes.values()) {
            GraphNode<NK, NV, EK, EV> newNode = node.cloneNode();
            graph.nodes.put(newNode.getId(), newNode);
        }
        return graph;
    }

    public void handoverNodes(Predicate<GraphNode<NK, NV, EK, EV>> nodeChecker, Supplier<EK> edgeIdGenerator, BiFunction<EV, EV, EV> edgeValueGenerator) {
        for (GraphNode node : new ArrayList<GraphNode<NK, NV, EK, EV>>(this.nodes.values())) {
            if (!nodeChecker.test(node)) continue;
            Object curNodeId = node.getId();
            node.incomeStream().filter(inEdge -> !curNodeId.equals(inEdge.getFrom())).flatMap(inEdge -> node.outcomeStream().filter(outEdge -> !curNodeId.equals(outEdge.getTo())).map(arg_0 -> DirectGraph.lambda$null$18((Supplier)edgeIdGenerator, inEdge, edgeValueGenerator, arg_0))).forEach(this::acceptEdge);
            this.removeNode(node);
        }
    }

    public void removeNode(GraphNode<NK, NV, EK, EV> node) {
        this.removeEdges(node.getIncomes());
        this.removeEdges(node.getOutcomes());
        this.nodes.remove(node.getId());
    }

    public void removeNodes(Predicate<GraphNode<NK, NV, EK, EV>> checker) {
        for (GraphNode<NK, NV, EK, EV> node : new ArrayList<GraphNode<NK, NV, EK, EV>>(this.nodes.values())) {
            if (!checker.test(node)) continue;
            this.removeNode(node);
        }
    }

    private void removeEdges(Map<EK, GraphEdge<EK, EV, NK>> edges) {
        if (edges == null) {
            return;
        }
        for (GraphEdge<EK, EV, NK> edge : new ArrayList<GraphEdge<EK, EV, NK>>(edges.values())) {
            this.removeEdge(edge);
        }
    }

    public Map<NK, GraphNode<NK, NV, EK, EV>> getNodes() {
        return this.nodes;
    }

    private static /* synthetic */ GraphEdge lambda$null$18(Supplier edgeIdGenerator, GraphEdge inEdge, BiFunction edgeValueGenerator, GraphEdge outEdge) {
        return new GraphEdge(edgeIdGenerator.get(), inEdge.getFrom(), outEdge.getTo(), edgeValueGenerator.apply(inEdge.getValue(), outEdge.getValue()));
    }
}

