/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.graph;

import com.happy3w.math.graph.GraphEdge;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class GraphNode<NK, NV, EK, EV> {
    private NK id;
    private Map<EK, GraphEdge<EK, EV, NK>> incomes;
    private Map<EK, GraphEdge<EK, EV, NK>> outcomes;
    private NV value;

    public GraphNode(NK id) {
        this.id = id;
    }

    public GraphNode<NK, NV, EK, EV> withValue(NV value) {
        this.value = value;
        return this;
    }

    public Stream<EV> outcomeValues() {
        return this.outcomes == null ? Stream.empty() : this.outcomes.values().stream().map(GraphEdge::getValue);
    }

    public GraphNode<NK, NV, EK, EV> withOutcome(GraphEdge<EK, EV, NK> edge) {
        if (this.outcomes == null) {
            this.outcomes = new HashMap<EK, GraphEdge<EK, EV, NK>>();
        }
        this.outcomes.put(edge.getId(), edge);
        return this;
    }

    public GraphNode<NK, NV, EK, EV> withIncome(GraphEdge<EK, EV, NK> edge) {
        if (this.incomes == null) {
            this.incomes = new HashMap<EK, GraphEdge<EK, EV, NK>>();
        }
        this.incomes.put(edge.getId(), edge);
        return this;
    }

    public Stream<GraphEdge<EK, EV, NK>> outcomeStream() {
        return this.outcomes == null ? Stream.empty() : this.outcomes.values().stream();
    }

    public Stream<GraphEdge<EK, EV, NK>> incomeStream() {
        return this.incomes == null ? Stream.empty() : this.incomes.values().stream();
    }

    public void removeOutcome(GraphEdge<EK, EV, NK> outcome) {
        if (this.outcomes == null || outcome == null) {
            return;
        }
        this.outcomes.remove(outcome.getId());
    }

    public void removeIncome(GraphEdge<EK, EV, NK> income) {
        if (this.incomes == null || income == null) {
            return;
        }
        this.incomes.remove(income.getId());
    }

    public GraphNode<NK, NV, EK, EV> cloneNode() {
        GraphNode<NK, NV, EK, EV> newNode = new GraphNode<NK, NV, EK, EV>(this.id);
        newNode.incomes = this.cloneEdges(this.incomes);
        newNode.outcomes = this.cloneEdges(this.outcomes);
        newNode.value = this.value;
        return newNode;
    }

    private Map<EK, GraphEdge<EK, EV, NK>> cloneEdges(Map<EK, GraphEdge<EK, EV, NK>> edges) {
        if (edges == null) {
            return null;
        }
        HashMap<EK, GraphEdge<EK, EV, NK>> newEdges = new HashMap<EK, GraphEdge<EK, EV, NK>>();
        for (GraphEdge<EK, EV, NK> edge : edges.values()) {
            GraphEdge<EK, EV, NK> newEdge = edge.cloneEdge();
            newEdges.put(newEdge.getId(), newEdge);
        }
        return newEdges;
    }

    public NK getId() {
        return this.id;
    }

    public Map<EK, GraphEdge<EK, EV, NK>> getIncomes() {
        return this.incomes;
    }

    public Map<EK, GraphEdge<EK, EV, NK>> getOutcomes() {
        return this.outcomes;
    }

    public NV getValue() {
        return this.value;
    }

    public void setValue(NV value) {
        this.value = value;
    }
}

