/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.graph;

import com.happy3w.math.graph.DirectGraph;
import com.happy3w.math.graph.GraphEdge;
import com.happy3w.math.graph.GraphNode;
import com.happy3w.math.tree.SimpleTreeNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GraphTool {
    public static <NK, NV, EK, EV> DirectGraph<NK, NV, EK, EV> buildGraph(List<NK> startNodeIds, Function<List<NK>, List<GraphNode<NK, NV, EK, EV>>> loader) {
        return GraphTool.buildLimitGraph(startNodeIds, loader, -1);
    }

    public static <NK, NV, EK, EV> DirectGraph<NK, NV, EK, EV> buildLimitGraph(List<NK> startNodeIds, Function<List<NK>, List<GraphNode<NK, NV, EK, EV>>> loader, int layLimit) {
        DirectGraph directGraph = new DirectGraph();
        HashSet existIds = new HashSet();
        List<Object> nodesToLoad = new ArrayList<NK>(startNodeIds);
        for (int times = 0; !(nodesToLoad.isEmpty() || layLimit > 0 && times > layLimit); ++times) {
            List<GraphNode<NK, NV, EK, EV>> newNodes = loader.apply(nodesToLoad);
            directGraph.acceptNodes(newNodes);
            nodesToLoad = newNodes.stream().flatMap(node -> node.outcomeStream()).map(GraphEdge::getTo).filter(to -> !existIds.contains(to)).peek(to -> existIds.add(to)).collect(Collectors.toList());
        }
        if (!nodesToLoad.isEmpty()) {
            directGraph.nodeStream().forEach(node -> {
                Map outcomes = node.getOutcomes();
                if (outcomes != null) {
                    Iterator edgeIt = outcomes.values().iterator();
                    while (edgeIt.hasNext()) {
                        GraphEdge edge = edgeIt.next();
                        if (directGraph.node(edge.getTo()) != null) continue;
                        edgeIt.remove();
                    }
                }
            });
        }
        return directGraph;
    }

    public static <NK, NV, EK, EV, TT> SimpleTreeNode<TT> graphToTree(DirectGraph<NK, NV, EK, EV> graph, NK startNodeId, BiFunction<NV, Boolean, TT> treeNodeGenerator) {
        AtomicReference<Object> treeHolder = new AtomicReference<Object>(null);
        HashSet visitedNodes = new HashSet();
        LinkedList queue = new LinkedList();
        GraphNode<NK, NV, EK, EV> startStackNode = graph.node(startNodeId);
        queue.add(new GraphTreeNodeHolder(startStackNode, treeNode -> treeHolder.set(treeNode)));
        GraphTreeNodeHolder curHolder = (GraphTreeNodeHolder)queue.poll();
        while (curHolder != null) {
            GraphNode graphNode = curHolder.getGraphNode();
            boolean repeated = visitedNodes.contains(graphNode.getId());
            TT treeNodeData = treeNodeGenerator.apply(graphNode.getValue(), repeated);
            SimpleTreeNode curTreeNode = new SimpleTreeNode(treeNodeData);
            curHolder.getTreeNodeCollector().accept(curTreeNode);
            if (!repeated) {
                visitedNodes.add(graphNode.getId());
                graphNode.outcomeStream().sorted(Comparator.comparing(GraphEdge::getValue, Comparator.naturalOrder())).map(edge -> graph.node(edge.getTo())).filter(Objects::nonNull).forEach(node -> queue.add(new GraphTreeNodeHolder(node, treeNode -> curTreeNode.addSubNode(treeNode))));
            }
            curHolder = (GraphTreeNodeHolder)queue.poll();
        }
        return treeHolder.get();
    }

    private static class GraphTreeNodeHolder<NK, NV, EK, EV, TT> {
        private GraphNode<NK, NV, EK, EV> graphNode;
        private Consumer<SimpleTreeNode<TT>> treeNodeCollector;

        public GraphNode<NK, NV, EK, EV> getGraphNode() {
            return this.graphNode;
        }

        public Consumer<SimpleTreeNode<TT>> getTreeNodeCollector() {
            return this.treeNodeCollector;
        }

        public GraphTreeNodeHolder(GraphNode<NK, NV, EK, EV> graphNode, Consumer<SimpleTreeNode<TT>> treeNodeCollector) {
            this.graphNode = graphNode;
            this.treeNodeCollector = treeNodeCollector;
        }
    }
}

