/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.graph;

import com.happy3w.java.ext.NeedFindIterator;
import com.happy3w.java.ext.NullableOptional;
import com.happy3w.math.graph.CircleInfo;
import com.happy3w.math.graph.CombineScNode;
import com.happy3w.math.graph.GraphNode;
import com.happy3w.math.graph.ScNode;
import com.happy3w.math.graph.SingleScNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ScIterator<NK, NV, EK, EV>
extends NeedFindIterator<ScNode<NK, NV, EK, EV>> {
    private final Map<NK, GraphNode<NK, NV, EK, EV>> nodesToDeal;
    private Stack<CircleInfo<NK>> candidateCircles = new Stack();
    private Stack<NK> idPath = new Stack();

    public ScIterator(Map<NK, GraphNode<NK, NV, EK, EV>> nodes) {
        this.nodesToDeal = new HashMap<NK, GraphNode<NK, NV, EK, EV>>(nodes);
    }

    protected NullableOptional<ScNode<NK, NV, EK, EV>> findNext() {
        ScNode<NK, NV, EK, EV> leafNode = this.findLeafNode();
        if (leafNode == null) {
            return NullableOptional.empty();
        }
        leafNode.idStream().forEach(this.nodesToDeal::remove);
        return NullableOptional.of(leafNode);
    }

    private ScNode<NK, NV, EK, EV> findLeafNode() {
        while (!this.nodesToDeal.isEmpty()) {
            SingleScNode<NK, NV, EK, EV> curScNode;
            if (!this.idPath.isEmpty()) {
                NK lastId = this.idPath.pop();
                GraphNode<NK, NV, EK, EV> graphNode = this.nodesToDeal.get(lastId);
                curScNode = SingleScNode.from(graphNode);
            } else if (!this.candidateCircles.isEmpty()) {
                CircleInfo<NK> curCircle = this.candidateCircles.pop();
                NK newStartNode = curCircle.nextNewStartNode();
                if (newStartNode == null) {
                    this.idPath.addAll(curCircle.getPathFromParent());
                    return new CombineScNode(this.idToNode(curCircle.getCircle(), this.nodesToDeal::get));
                }
                this.candidateCircles.push(curCircle);
                GraphNode<NK, NV, EK, EV> graphNode = this.nodesToDeal.get(newStartNode);
                if (graphNode == null) continue;
                curScNode = SingleScNode.from(graphNode);
            } else {
                GraphNode<NK, NV, EK, EV> graphNode = this.nodesToDeal.values().iterator().next();
                curScNode = SingleScNode.from(graphNode);
            }
            NK curId = curScNode.getGraphNode().getId();
            CircleInfo<Object> curCircle = CircleInfo.createNewCircle(this.idPath, curId, this.nodesToDeal::get);
            if (curCircle != null) {
                this.idPath.clear();
                this.candidateCircles.push(curCircle);
                continue;
            }
            if (CircleInfo.mergeIntoBigCircle(this.idPath, curId, this.candidateCircles, this.nodesToDeal::get)) {
                this.idPath.clear();
                continue;
            }
            SingleScNode<Object, NV, EK, EV> outNode = this.pickAnyOutNode(curScNode.getGraphNode(), this.nodesToDeal::get);
            if (outNode == null) {
                return curScNode;
            }
            this.idPath.push(curId);
            this.idPath.push(outNode.getGraphNode().getId());
        }
        return null;
    }

    private SingleScNode<NK, NV, EK, EV> pickAnyOutNode(GraphNode<NK, NV, EK, EV> node, Function<NK, GraphNode<NK, NV, EK, EV>> nodeMapper) {
        return node.outcomeStream().map(edge -> (GraphNode)nodeMapper.apply(edge.getTo())).filter(Objects::nonNull).map(SingleScNode::from).findFirst().orElse(null);
    }

    private List<GraphNode<NK, NV, EK, EV>> idToNode(Collection<NK> ids, Function<NK, GraphNode<NK, NV, EK, EV>> idNodeTranslator) {
        return ids.stream().map(idNodeTranslator).collect(Collectors.toList());
    }
}

