/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.permutation;

import com.happy3w.math.util.IndexMapper;
import java.util.Arrays;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DuplicatedPermutationMaker<T> {
    private IndexMapper<T> mapper;

    public DuplicatedPermutationMaker(T[] baseValues, BiPredicate<T, T> equalChecker) {
        this.mapper = new IndexMapper<T>(baseValues, equalChecker);
    }

    public Stream<T[]> generate() {
        int[] startValues = this.mapper.createStartValues();
        return StreamSupport.stream(new PermutationSpliterator(startValues), false).map(this.mapper::convertValues);
    }

    public IndexMapper<T> getMapper() {
        return this.mapper;
    }

    private static class PermutationSpliterator
    extends Spliterators.AbstractSpliterator<int[]> {
        private int[] startValue;
        private int[] currentValue;

        protected PermutationSpliterator(int[] startValue) {
            super(0L, 0);
            this.startValue = startValue;
        }

        @Override
        public boolean tryAdvance(Consumer<? super int[]> action) {
            if (this.currentValue == null) {
                this.currentValue = this.startValue;
            } else {
                int[] nextValue = this.next(this.currentValue);
                if (nextValue == null) {
                    return false;
                }
                this.currentValue = nextValue;
            }
            action.accept((int[])Arrays.copyOf(this.currentValue, this.currentValue.length));
            return true;
        }

        private int[] next(int[] values) {
            int indexSmallThenRight = this.lastIndexOfSmallThenRight(values);
            if (indexSmallThenRight < 0) {
                return null;
            }
            int indexMinBigValue = this.findMinBigValue(values, indexSmallThenRight);
            this.switchValue(values, indexSmallThenRight, indexMinBigValue);
            Arrays.sort(values, indexSmallThenRight + 1, values.length);
            return values;
        }

        private void switchValue(int[] values, int indexA, int indexB) {
            int a = values[indexA];
            values[indexA] = values[indexB];
            values[indexB] = a;
        }

        private int findMinBigValue(int[] values, int startIndex) {
            int curValue = values[startIndex];
            int minBigValueIndex = startIndex + 1;
            int minBigValue = values[minBigValueIndex];
            for (int index = startIndex + 2; index < values.length; ++index) {
                int value = values[index];
                if (value <= curValue || value >= minBigValue) continue;
                minBigValueIndex = index;
                minBigValue = value;
            }
            return minBigValueIndex;
        }

        private int lastIndexOfSmallThenRight(int[] values) {
            int rightValue = values[values.length - 1];
            for (int index = values.length - 2; index >= 0; --index) {
                int curValue = values[index];
                if (curValue < rightValue) {
                    return index;
                }
                rightValue = curValue;
            }
            return -1;
        }
    }
}

