/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.permutation;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SimplePermutationMaker<T> {
    private T[] baseValues;
    private int[] factorial;

    public SimplePermutationMaker(T[] baseValues) {
        this.baseValues = baseValues;
    }

    public Stream<T[]> generate() {
        if (this.factorial == null) {
            this.factorial = this.initFactorial(this.baseValues.length);
        }
        return StreamSupport.stream(new PermutationSpliterator(this.baseValues.length, this.factorial), false).map(this::convertValues);
    }

    private T[] convertValues(int[] indexes) {
        int size = this.baseValues.length;
        Object[] values = (Object[])Array.newInstance(this.baseValues.getClass().getComponentType(), size);
        for (int i = 0; i < size; ++i) {
            values[i] = this.baseValues[indexes[i]];
        }
        return values;
    }

    private int[] initFactorial(int length) {
        int[] factorial = new int[length + 1];
        factorial[0] = 1;
        for (int i = 1; i <= length; ++i) {
            factorial[i] = factorial[i - 1] * i;
        }
        return factorial;
    }

    private static class PermutationSpliterator
    extends Spliterators.AbstractSpliterator<int[]> {
        private int[] factorial;
        private int size;
        private int index = 0;

        protected PermutationSpliterator(int size, int[] factorial) {
            super(0L, 0);
            this.factorial = factorial;
            this.size = size;
        }

        @Override
        public boolean tryAdvance(Consumer<? super int[]> action) {
            if (this.index >= this.factorial[this.size]) {
                return false;
            }
            int[] newPermutation = this.createPermutationByIndex(this.index);
            action.accept((int[])newPermutation);
            ++this.index;
            return true;
        }

        private int[] createPermutationByIndex(int leftIndex) {
            int[] newPermutation = new int[this.size];
            int[] valid = new int[this.size];
            Arrays.fill(valid, 1);
            for (int i = 0; i < this.size; ++i) {
                int curFactorial = this.factorial[this.size - i - 1];
                int order = leftIndex / curFactorial + 1;
                for (int j = 0; j < this.size; ++j) {
                    if ((order -= valid[j]) != 0) continue;
                    newPermutation[i] = j;
                    valid[j] = 0;
                    break;
                }
                leftIndex %= curFactorial;
            }
            return newPermutation;
        }
    }
}

