/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.section;

import com.happy3w.math.section.ItemValueType;
import com.happy3w.math.section.SectionItem;
import com.happy3w.math.section.SectionItemValue;
import com.happy3w.math.section.SectionItemValueComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public abstract class AbstractSection<T, S extends AbstractSection<T, S>> {
    public static final String SPLITER = "";
    protected List<SectionItem<T>> items = new ArrayList<SectionItem<T>>();
    protected Comparator<T> valueComparator;
    protected SectionItemValueComparator<T> itemValueComparator;

    public AbstractSection(SectionItem<T> ... itemArray) {
        this.init(Comparator.comparing(Function.identity()), itemArray);
    }

    public AbstractSection(Class<T> type, SectionItem<T> ... itemArray) {
        if (!Comparable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Param type should be Comparable");
        }
        this.init(Comparator.comparing(Function.identity()), itemArray);
    }

    public AbstractSection(Comparator<T> itemValueComparator, SectionItem<T> ... itemArray) {
        this.init(itemValueComparator, itemArray);
    }

    private void init(Comparator<T> comparator, SectionItem<T> ... itemArray) {
        this.valueComparator = comparator;
        this.itemValueComparator = new SectionItemValueComparator<T>(comparator);
        this.items.addAll(Arrays.asList(itemArray));
    }

    public S unionSection(S otherSection) {
        for (SectionItem<T> items : ((AbstractSection)otherSection).items) {
            this.unionItem(items);
        }
        return (S)this;
    }

    public S unionItem(SectionItem<T> newItem) {
        int itemFromIndex = this.unionFromItem(newItem);
        this.unionToItem(itemFromIndex, newItem);
        return (S)this;
    }

    public S subtractSection(S otherSection) {
        for (SectionItem<T> items : ((AbstractSection)otherSection).items) {
            this.subtractItem(items);
        }
        return (S)this;
    }

    public S subtractItem(SectionItem<T> subItem) {
        int itemFromIndex = this.subFromItem(subItem);
        this.subToItem(itemFromIndex, subItem);
        return (S)this;
    }

    protected abstract SectionItemValue<T> removePoint(SectionItemValue<T> var1, ItemValueType var2);

    protected void subToItem(int itemFromIndex, SectionItem<T> subItem) {
        if (itemFromIndex >= this.items.size()) {
            return;
        }
        SectionItemValue<T> subItemTo = subItem.getTo();
        int index = itemFromIndex;
        while (index < this.items.size()) {
            SectionItem<T> curItem = this.items.get(index);
            SectionItemValue<T> curItemFrom = curItem.getFrom();
            int crFrom = this.itemValueComparator.compare(subItemTo, ItemValueType.to, curItemFrom, ItemValueType.from);
            if (crFrom < 0) {
                return;
            }
            if (crFrom == 0) {
                if (subItemTo.isInclude()) {
                    curItem.setFrom(this.newItemValue(curItemFrom.getValue(), !curItemFrom.isInclude(), ItemValueType.from));
                }
                return;
            }
            SectionItemValue<T> curItemTo = curItem.getTo();
            int crTo = this.itemValueComparator.compare(subItemTo, ItemValueType.to, curItemTo, ItemValueType.to);
            if (crTo < 0) {
                curItem.setFrom(this.newItemValue(subItemTo.getValue(), !subItemTo.isInclude(), ItemValueType.from));
                return;
            }
            if (crTo == 0) {
                if (!subItemTo.isInclude() && curItemTo.isInclude()) {
                    curItem.setFrom(this.newItemValue(subItemTo.getValue(), !subItemTo.isInclude(), ItemValueType.from));
                } else {
                    this.items.remove(index);
                }
                return;
            }
            this.items.remove(index);
        }
    }

    protected SectionItemValue<T> newItemValue(T value, boolean include, ItemValueType type) {
        SectionItemValue<T> newItemValue = new SectionItemValue<T>(value, include);
        if (!include) {
            newItemValue = this.removePoint(newItemValue, type);
        }
        return newItemValue;
    }

    protected int subFromItem(SectionItem<T> subItem) {
        SectionItemValue<T> subItemFrom = subItem.getFrom();
        for (int index = 0; index < this.items.size(); ++index) {
            SectionItem<T> item = this.items.get(index);
            SectionItemValue<T> itemFrom = item.getFrom();
            int crFrom = this.itemValueComparator.compare(subItemFrom, ItemValueType.from, itemFrom, ItemValueType.from);
            if (crFrom < 0) {
                return index;
            }
            if (crFrom == 0) {
                if (itemFrom.isInclude() && !subItemFrom.isInclude()) {
                    this.items.add(index, SectionItem.ofValue(subItemFrom.getValue(), true, subItemFrom.getValue(), true));
                    return index + 1;
                }
                return index;
            }
            int crTo = this.itemValueComparator.compare(subItemFrom, ItemValueType.from, item.getTo(), ItemValueType.to);
            if (crTo < 0) {
                this.items.add(index + 1, item.newCopy());
                item.setTo(this.newItemValue(subItemFrom.getValue(), !subItemFrom.isInclude(), ItemValueType.to));
                return index + 1;
            }
            if (crTo != 0) continue;
            if (subItemFrom.isInclude()) {
                item.setTo(this.newItemValue(item.getTo().getValue(), false, ItemValueType.to));
            }
            return index + 1;
        }
        return this.items.size();
    }

    protected int unionFromItem(SectionItem<T> newItem) {
        SectionItemValue<T> newItemFrom = newItem.getFrom();
        for (int index = 0; index < this.items.size(); ++index) {
            SectionItem<T> item = this.items.get(index);
            SectionItemValue<T> itemFrom = item.getFrom();
            int crFrom = this.itemValueComparator.compare(newItemFrom, ItemValueType.from, itemFrom, ItemValueType.from);
            if (crFrom < 0) {
                this.items.add(index, newItem.newCopy());
                return index;
            }
            if (crFrom == 0) {
                if (newItemFrom.isInclude()) {
                    itemFrom.setInclude(true);
                }
                return index;
            }
            SectionItemValue<T> itemTo = item.getTo();
            int crTo = this.itemValueComparator.compare(newItemFrom, ItemValueType.from, itemTo, ItemValueType.to);
            if (crTo < 0) {
                return index;
            }
            if (crTo != 0) continue;
            if (itemTo.isInclude() || newItemFrom.isInclude()) {
                return index;
            }
            int newIndex = index + 1;
            this.items.add(newIndex, newItem.newCopy());
            return newIndex;
        }
        this.items.add(newItem.newCopy());
        return this.items.size() - 1;
    }

    protected void unionToItem(int itemFromIndex, SectionItem<T> newItem) {
        SectionItem<T> itemToUpdate = this.items.get(itemFromIndex);
        SectionItemValue<T> newItemTo = newItem.getTo();
        int index = itemFromIndex;
        while (index < this.items.size()) {
            int crTo;
            SectionItem<T> curItem = this.items.get(index);
            SectionItemValue<T> curItemFrom = curItem.getFrom();
            SectionItemValue<T> curItemTo = curItem.getTo();
            if (index != itemFromIndex) {
                int crFrom = this.itemValueComparator.compare(newItemTo, ItemValueType.to, curItemFrom, ItemValueType.from);
                if (crFrom < 0) {
                    itemToUpdate.configTo(newItemTo.getValue(), newItemTo.isInclude());
                    return;
                }
                if (crFrom == 0) {
                    if (curItemFrom.isInclude() || newItemTo.isInclude()) {
                        itemToUpdate.configTo(curItemTo.getValue(), curItemTo.isInclude());
                        this.items.remove(index);
                    } else {
                        itemToUpdate.configTo(newItemTo.getValue(), newItemTo.isInclude());
                    }
                    return;
                }
            }
            if ((crTo = this.itemValueComparator.compare(newItemTo, ItemValueType.to, curItemTo, ItemValueType.to)) < 0) {
                if (itemToUpdate != curItem) {
                    itemToUpdate.configTo(curItemTo.getValue(), curItemTo.isInclude());
                    this.items.remove(index);
                }
                return;
            }
            if (crTo == 0) {
                itemToUpdate.configTo(curItemTo.getValue(), curItemTo.isInclude() || newItemTo.isInclude());
            }
            if (itemToUpdate != curItem) {
                this.items.remove(index);
                continue;
            }
            ++index;
        }
        itemToUpdate.configTo(newItemTo.getValue(), newItemTo.isInclude());
    }

    public abstract S newEmptySection();

    public S reverse() {
        return (S)((AbstractSection)this.newEmptySection()).unionItem(SectionItem.ofValue(null, null)).subtractSection((AbstractSection)this);
    }

    public boolean contains(T value) {
        if (value == null) {
            return false;
        }
        for (SectionItem<T> item : this.items) {
            int crFrom = this.itemValueComparator.compareValue(value, item.getFrom(), ItemValueType.from);
            if (crFrom == 0) {
                return true;
            }
            int crTo = this.itemValueComparator.compareValue(value, item.getTo(), ItemValueType.to);
            if (crFrom < 0 || crTo > 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.formatText(Object::toString, "*", "*", SPLITER);
    }

    public String formatText(Function<T, String> valueFormatter, String nullFrom, String nullTo, String spliter) {
        StringBuilder buf = new StringBuilder();
        try {
            for (SectionItem<T> item : this.items) {
                if (buf.length() > 0) {
                    buf.append(spliter);
                }
                item.output(buf, valueFormatter, nullFrom, nullTo);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return buf.toString();
    }

    public List<SectionItem<T>> getItems() {
        return this.items;
    }

    public Comparator<T> getValueComparator() {
        return this.valueComparator;
    }

    public SectionItemValueComparator<T> getItemValueComparator() {
        return this.itemValueComparator;
    }

    public void setItems(List<SectionItem<T>> items) {
        this.items = items;
    }

    public void setValueComparator(Comparator<T> valueComparator) {
        this.valueComparator = valueComparator;
    }

    public void setItemValueComparator(SectionItemValueComparator<T> itemValueComparator) {
        this.itemValueComparator = itemValueComparator;
    }
}

