/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.section;

import com.happy3w.math.section.AbstractSection;
import com.happy3w.math.section.DiscretizeCalculator;
import com.happy3w.math.section.ItemValueType;
import com.happy3w.math.section.SectionItem;
import com.happy3w.math.section.SectionItemValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class DiscreteSection<T>
extends AbstractSection<T, DiscreteSection<T>> {
    private DiscretizeCalculator<T> discretizeCalculator;

    public DiscreteSection(DiscretizeCalculator<T> discretizeCalculator, SectionItem<T> ... itemArray) {
        super(itemArray);
        this.discretizeCalculator = discretizeCalculator;
        this.discretizeItems(this.items);
    }

    public DiscreteSection(DiscretizeCalculator<T> discretizeCalculator, Comparator<T> comparator, SectionItem<T> ... itemArray) {
        super(comparator, itemArray);
        this.discretizeCalculator = discretizeCalculator;
        this.discretizeItems(this.items);
    }

    @Override
    public DiscreteSection<T> unionItem(SectionItem<T> item) {
        SectionItem<T> newItem = this.discretizeItem(item);
        int itemFromIndex = this.unionFromItem(newItem);
        int newIndex = this.tryMerge(itemFromIndex);
        this.unionToItem(newIndex, newItem);
        this.tryMerge(newIndex + 1);
        return this;
    }

    public DiscreteSection<T> unionValue(T value) {
        return this.unionItem((SectionItem)new SectionItem<T>(new SectionItemValue<T>(value, true), new SectionItemValue<T>(value, true)));
    }

    protected int tryMerge(int itemIndex) {
        if (itemIndex > 0 && itemIndex < this.items.size()) {
            SectionItem preItem = (SectionItem)this.items.get(itemIndex - 1);
            SectionItem curItem = (SectionItem)this.items.get(itemIndex);
            T newValue = this.discretizeCalculator.plus(preItem.getTo().getValue(), 1L);
            if (this.valueComparator.compare(newValue, curItem.getFrom().getValue()) == 0) {
                preItem.setTo(curItem.getTo());
                this.items.remove(itemIndex);
                return itemIndex - 1;
            }
        }
        return itemIndex;
    }

    @Override
    public DiscreteSection<T> subtractItem(SectionItem<T> subItem) {
        SectionItem<T> item = this.discretizeItem(subItem);
        return (DiscreteSection)super.subtractItem(item);
    }

    public DiscreteSection<T> subtractValue(T value) {
        return this.subtractItem((SectionItem)new SectionItem<T>(new SectionItemValue<T>(value, true), new SectionItemValue<T>(value, true)));
    }

    protected void discretizeItems(List<SectionItem<T>> items) {
        for (int i = 0; i < items.size(); ++i) {
            SectionItem<T> item = items.get(i);
            SectionItem<T> newItem = this.discretizeItem(item);
            items.set(i, newItem);
        }
    }

    protected SectionItem<T> discretizeItem(SectionItem<T> item) {
        SectionItemValue<T> from = this.discretizeValue(item.getFrom(), ItemValueType.from);
        SectionItemValue<T> to = this.discretizeValue(item.getTo(), ItemValueType.to);
        if (item.getTo() != to || item.getFrom() != from) {
            return new SectionItem<T>(from, to);
        }
        return item;
    }

    protected SectionItemValue<T> discretizeValue(SectionItemValue<T> value, ItemValueType type) {
        if (value.isInclude() || value.getValue() == null) {
            return value;
        }
        long delta = type == ItemValueType.from ? 1L : -1L;
        return new SectionItemValue<T>(this.discretizeCalculator.plus(value.getValue(), delta), true);
    }

    @Override
    protected SectionItemValue<T> removePoint(SectionItemValue<T> itemValue, ItemValueType type) {
        if (itemValue == null) {
            return null;
        }
        itemValue.setInclude(false);
        return this.discretizeValue(itemValue, type);
    }

    @Override
    public DiscreteSection<T> newEmptySection() {
        return new DiscreteSection<T>(this.discretizeCalculator, this.valueComparator, new SectionItem[0]);
    }

    public Stream<T> stream() {
        boolean endNull;
        if (this.items.isEmpty()) {
            return Stream.empty();
        }
        boolean startNull = ((SectionItem)this.items.get(0)).getFrom().getValue() == null;
        boolean bl = endNull = ((SectionItem)this.items.get(this.items.size() - 1)).getTo().getValue() == null;
        if (startNull && endNull) {
            throw new IllegalArgumentException("Can not stream DiscreteSection with both null.");
        }
        return startNull ? this.streamDesc() : this.streamAsc();
    }

    public Stream<T> streamAsc() {
        return this.items.stream().flatMap(item -> item.streamAsc(this.discretizeCalculator, this.valueComparator));
    }

    public Stream<T> streamDesc() {
        ArrayList descItems = new ArrayList(this.items);
        Collections.reverse(descItems);
        return descItems.stream().flatMap(item -> item.streamDesc(this.discretizeCalculator, this.valueComparator));
    }

    public DiscretizeCalculator<T> getDiscretizeCalculator() {
        return this.discretizeCalculator;
    }

    public void setDiscretizeCalculator(DiscretizeCalculator<T> discretizeCalculator) {
        this.discretizeCalculator = discretizeCalculator;
    }
}

