/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.section;

import com.happy3w.math.section.DiscretizeCalculator;
import com.happy3w.math.section.SectionItemValue;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Stream;

public class SectionItem<T> {
    public static final String NULL_TEXT = "*";
    private SectionItemValue<T> from;
    private SectionItemValue<T> to;

    public SectionItem(SectionItemValue<T> from, SectionItemValue<T> to) {
        this.from = from;
        this.to = to;
    }

    public SectionItem<T> newCopy() {
        return new SectionItem<T>(this.from, this.to);
    }

    public void configFrom(T from, boolean includeFrom) {
        this.from = new SectionItemValue<T>(from, includeFrom);
    }

    public void configTo(T to, boolean includeTo) {
        this.to = new SectionItemValue<T>(to, includeTo);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            this.output(buf, Object::toString, NULL_TEXT, NULL_TEXT);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception.", e);
        }
        return buf.toString();
    }

    public void output(Appendable buf, Function<T, String> valueFormatter, String nullFrom, String nullTo) throws IOException {
        buf.append(this.from.isInclude() ? (char)'[' : '(').append(this.from.getValue() == null ? nullFrom : (CharSequence)valueFormatter.apply(this.from.getValue())).append(',').append(this.to.getValue() == null ? nullTo : (CharSequence)valueFormatter.apply(this.to.getValue())).append(this.to.isInclude() ? (char)']' : ')');
    }

    public static <T> SectionItem<T> ofValue(T from, T to) {
        return new SectionItem<T>(new SectionItemValue<T>(from, true), new SectionItemValue<T>(to, true));
    }

    public static <T> SectionItem<T> ofValue(T from, boolean includeFrom, T to, boolean includeTo) {
        return new SectionItem<T>(new SectionItemValue<T>(from, includeFrom), new SectionItemValue<T>(to, includeTo));
    }

    public Stream<T> stream(DiscretizeCalculator<T> discretizeCalculator, Comparator<T> valueComparator) {
        if (this.from.getValue() == null && this.to.getValue() == null) {
            throw new IllegalArgumentException("Can not stream SectionItem with both null.");
        }
        if (this.from.getValue() != null) {
            return this.streamAsc(discretizeCalculator, valueComparator);
        }
        return this.streamDesc(discretizeCalculator, valueComparator);
    }

    public Stream<T> streamAsc(DiscretizeCalculator<T> discretizeCalculator, Comparator<T> valueComparator) {
        return SectionItemValue.streamWithStartEnd(this.from, this.to, 1, discretizeCalculator, valueComparator);
    }

    public Stream<T> streamDesc(DiscretizeCalculator<T> discretizeCalculator, Comparator<T> valueComparator) {
        return SectionItemValue.streamWithStartEnd(this.to, this.from, -1, discretizeCalculator, valueComparator);
    }

    public SectionItemValue<T> getFrom() {
        return this.from;
    }

    public SectionItemValue<T> getTo() {
        return this.to;
    }

    public void setFrom(SectionItemValue<T> from) {
        this.from = from;
    }

    public void setTo(SectionItemValue<T> to) {
        this.to = to;
    }
}

