/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.section;

import com.happy3w.math.section.DiscretizeCalculator;
import java.util.Comparator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SectionItemValue<T> {
    private T value;
    private boolean include;

    public SectionItemValue(T value, boolean include) {
        this.value = value;
        this.include = value == null ? false : include;
    }

    public String toString() {
        return this.value + "," + this.include;
    }

    public static <T> Stream<T> streamWithStartEnd(SectionItemValue<T> start, SectionItemValue<T> end, int step, DiscretizeCalculator<T> discretizeCalculator, Comparator<T> valueComparator) {
        if (start.getValue() == null) {
            throw new IllegalArgumentException("Can not start stream with min value null");
        }
        T seed = start.isInclude() ? start.getValue() : discretizeCalculator.plus(start.getValue(), step);
        T endValue = end.getValue();
        if (endValue != null && !end.isInclude()) {
            endValue = discretizeCalculator.plus(end.getValue(), -step);
        }
        return SectionItemValue.streamWithStartEndValue(seed, endValue, step, discretizeCalculator, valueComparator);
    }

    public static <T> Stream<T> streamWithStartEndValue(T start, T end, int step, DiscretizeCalculator<T> discretizeCalculator, Comparator<T> valueComparator) {
        return StreamSupport.stream(new StartEndStream<T>(start, end, step, discretizeCalculator, valueComparator), false);
    }

    public T getValue() {
        return this.value;
    }

    public boolean isInclude() {
        return this.include;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    public SectionItemValue() {
    }

    public static class StartEndStream<T>
    extends Spliterators.AbstractSpliterator<T> {
        private T start;
        private T end;
        private int step;
        private DiscretizeCalculator<T> discretizeCalculator;
        private Comparator<T> valueComparator;
        private boolean isInit = false;
        private T preValue;

        public StartEndStream(T start, T end, int step, DiscretizeCalculator<T> discretizeCalculator, Comparator<T> valueComparator) {
            super(Long.MAX_VALUE, 0);
            this.start = start;
            this.end = end;
            this.step = step;
            this.discretizeCalculator = discretizeCalculator;
            this.valueComparator = valueComparator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (!this.isInit) {
                this.isInit = true;
                this.preValue = this.start;
                action.accept(this.preValue);
                return true;
            }
            T newValue = this.discretizeCalculator.plus(this.preValue, this.step);
            this.preValue = newValue;
            if (this.end == null) {
                action.accept(newValue);
                return true;
            }
            int cr = this.valueComparator.compare(newValue, this.end);
            if (cr * this.step <= 0) {
                action.accept(newValue);
                return true;
            }
            return false;
        }
    }
}

