/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.section;

import com.happy3w.math.section.ItemValueType;
import com.happy3w.math.section.SectionItemValue;
import java.util.Comparator;

public class SectionItemValueComparator<T> {
    private final Comparator<T> valueComparator;

    public SectionItemValueComparator(Comparator<T> valueComparator) {
        this.valueComparator = valueComparator;
    }

    public int compareValue(T value, SectionItemValue<T> o1, ItemValueType type1) {
        int kind1 = this.getValueKind(o1, type1);
        if (kind1 != 0) {
            return -kind1;
        }
        int crValue = this.valueComparator.compare(value, o1.getValue());
        if (crValue == 0 && !o1.isInclude()) {
            return -type1.getValue();
        }
        return crValue;
    }

    public int compare(SectionItemValue<T> o1, ItemValueType type1, SectionItemValue<T> o2, ItemValueType type2) {
        int kind2;
        int kind1 = this.getValueKind(o1, type1);
        int crKind = kind1 - (kind2 = this.getValueKind(o2, type2));
        if (crKind != 0 || kind1 != 0) {
            return crKind;
        }
        return this.valueComparator.compare(o1.getValue(), o2.getValue());
    }

    private int getValueKind(SectionItemValue<T> itemValue, ItemValueType type) {
        if (itemValue.getValue() != null) {
            return 0;
        }
        if (type == ItemValueType.from) {
            return -1;
        }
        return 1;
    }
}

