/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.tree;

import com.happy3w.java.ext.ArrayUtils;
import com.happy3w.math.tree.TreeNode;
import com.happy3w.math.tree.WritableTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class BinTreeNode<T>
implements WritableTreeNode<T> {
    private T data;
    private BinTreeNode<T> left;
    private BinTreeNode<T> right;

    public BinTreeNode() {
    }

    public BinTreeNode(T data) {
        this.data = data;
    }

    public BinTreeNode(T data, BinTreeNode<T> left, BinTreeNode<T> right) {
        this.data = data;
        this.left = left;
        this.right = right;
    }

    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    public boolean[] toShapeDesc() {
        ArrayList shapeDesc = new ArrayList();
        this.visitTree(null, shapeDesc::add);
        return ArrayUtils.toBooleanArray(shapeDesc);
    }

    public static BinTreeNode from(boolean[] shapeDesc) {
        BinTreeNode head = new BinTreeNode();
        head.buildTree(null, ArrayUtils.toBooleanList((boolean[])shapeDesc).iterator()::next);
        return head;
    }

    public static <T> String serialize(BinTreeNode<T> head, Function<T, String> dataConvertor) {
        if (head == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        head.serialize(dataConvertor, String::valueOf, item -> {
            builder.append((String)item);
            builder.append(',');
        });
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    public <K> void serialize(Function<T, K> dataConvertor, Function<Boolean, K> shapeConvertor, Consumer<K> itemCollector) {
        this.visitTree(data -> itemCollector.accept(dataConvertor.apply(data)), shape -> itemCollector.accept(shapeConvertor.apply((Boolean)shape)));
    }

    public static <T> BinTreeNode<T> deserialize(String encodeStr, Function<String, T> dataConvertor) {
        if (encodeStr == null || encodeStr.isEmpty()) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(encodeStr, ",");
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        BinTreeNode<T> head = new BinTreeNode<T>();
        head.deserialize(tokenizer::nextToken, dataConvertor, Boolean::parseBoolean);
        return head;
    }

    public <K> void deserialize(Supplier<K> itemSupplier, Function<K, T> dataConvertor, Function<K, Boolean> shapeConvertor) {
        this.buildTree(() -> dataConvertor.apply(itemSupplier.get()), () -> (Boolean)shapeConvertor.apply(itemSupplier.get()));
    }

    public void buildTree(Supplier<T> dataSupplier, Supplier<Boolean> shapeSupplier) {
        Stack<BinTreeNode<T>> nodeStack = new Stack<BinTreeNode<T>>();
        nodeStack.push(this);
        while (!nodeStack.isEmpty()) {
            BinTreeNode node = (BinTreeNode)nodeStack.pop();
            if (dataSupplier != null) {
                node.data = dataSupplier.get();
            }
            if (shapeSupplier.get().booleanValue()) {
                node.left = new BinTreeNode<T>();
            }
            if (shapeSupplier.get().booleanValue()) {
                node.right = new BinTreeNode<T>();
                nodeStack.push(node.right);
            }
            if (node.left == null) continue;
            nodeStack.push(node.left);
        }
    }

    public void visitTree(Consumer<T> dataVisitor, Consumer<Boolean> shapeVisitor) {
        Stack<BinTreeNode<T>> nodeStack = new Stack<BinTreeNode<T>>();
        nodeStack.push(this);
        while (!nodeStack.isEmpty()) {
            BinTreeNode node = (BinTreeNode)nodeStack.pop();
            if (dataVisitor != null) {
                dataVisitor.accept(node.data);
            }
            boolean hasLeft = node.left != null;
            boolean hasRight = node.right != null;
            shapeVisitor.accept(hasLeft);
            shapeVisitor.accept(hasRight);
            if (hasRight) {
                nodeStack.push(node.right);
            }
            if (!hasLeft) continue;
            nodeStack.push(node.left);
        }
    }

    public void visitNode(Consumer<BinTreeNode<T>> nodeVisitor) {
        Stack<BinTreeNode<T>> nodeStack = new Stack<BinTreeNode<T>>();
        nodeStack.push(this);
        while (!nodeStack.isEmpty()) {
            BinTreeNode node = (BinTreeNode)nodeStack.pop();
            nodeVisitor.accept(node);
            if (node.right != null) {
                nodeStack.push(node.right);
            }
            if (node.left == null) continue;
            nodeStack.push(node.left);
        }
    }

    @Override
    public List<TreeNode<T>> getSubNodes() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    public TreeNode<T> cloneWithSubNodes(List<TreeNode<T>> newSubNodes) {
        BinTreeNode<T> newNode = new BinTreeNode<T>();
        newNode.setData(this.data);
        newNode.setSubNodes(newSubNodes);
        return newNode;
    }

    @Override
    public void setSubNodes(List<TreeNode<T>> subNodes) {
        if (subNodes == null || subNodes.isEmpty()) {
            this.left = null;
            this.right = null;
        } else {
            this.left = (BinTreeNode)subNodes.get(0);
            this.right = subNodes.size() > 1 ? (BinTreeNode)subNodes.get(1) : null;
        }
    }

    @Override
    public T getData() {
        return this.data;
    }

    public BinTreeNode<T> getLeft() {
        return this.left;
    }

    public BinTreeNode<T> getRight() {
        return this.right;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setLeft(BinTreeNode<T> left) {
        this.left = left;
    }

    public void setRight(BinTreeNode<T> right) {
        this.right = right;
    }
}

