/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.tree;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TreeEnumerator {
    public static Stream<boolean[]> enumFullBinTree(int nodeCount) {
        return TreeEnumerator.enumFullTree(nodeCount, 2);
    }

    public static Stream<boolean[]> enumFullTree(int nodeCount, int bifurcationCount) {
        int bifurcationNodeCount = nodeCount / bifurcationCount;
        if (bifurcationNodeCount * bifurcationCount + 1 != nodeCount) {
            throw new IllegalArgumentException(MessageFormat.format("Full {0} bifurcation tree node count wrong.expected is {1}, but input {2}.", bifurcationCount, bifurcationNodeCount * bifurcationCount + 1, nodeCount));
        }
        return StreamSupport.stream(new TreeShapeSpliterator(bifurcationNodeCount, bifurcationCount), false);
    }

    private static class TreeShapeSpliterator
    extends Spliterators.AbstractSpliterator<boolean[]> {
        private int bifurcationNodeCount;
        private int bifurcationCount;
        private boolean[] curBifurcationNodeShape;

        protected TreeShapeSpliterator(int bifurcationNodeCount, int bifurcationCount) {
            super(0L, 0);
            this.bifurcationNodeCount = bifurcationNodeCount;
            this.bifurcationCount = bifurcationCount;
        }

        @Override
        public boolean tryAdvance(Consumer<? super boolean[]> action) {
            if (this.curBifurcationNodeShape == null) {
                this.curBifurcationNodeShape = this.initBifurcationShape();
            } else if (!this.nextShape()) {
                return false;
            }
            boolean[] normalShape = this.generateNormalShape(this.curBifurcationNodeShape);
            action.accept((boolean[])normalShape);
            return true;
        }

        private boolean[] generateNormalShape(boolean[] curBifurcationNodeShape) {
            ArrayDeque<Boolean> nodeTypeStack = new ArrayDeque<Boolean>();
            Deque<boolean[]> groupStack = this.initGroupStack(curBifurcationNodeShape);
            boolean[] shape = new boolean[(this.bifurcationNodeCount * this.bifurcationCount + 1) * this.bifurcationCount];
            int shapeIndex = 0;
            while (true) {
                boolean shapeType;
                if (nodeTypeStack.isEmpty()) {
                    if (groupStack.isEmpty()) break;
                    shapeIndex = this.fetchFromGroup(groupStack, nodeTypeStack, shape, shapeIndex);
                }
                if (shapeType = ((Boolean)nodeTypeStack.pop()).booleanValue()) {
                    shapeIndex = this.fetchFromGroup(groupStack, nodeTypeStack, shape, shapeIndex);
                    continue;
                }
                shapeIndex = this.writeShape(shape, shapeIndex, false, this.bifurcationCount);
            }
            return shape;
        }

        private int writeShape(boolean[] shape, int shapeIndex, boolean shapeValue, int shapeCount) {
            for (int i = 0; i < shapeCount; ++i) {
                shape[shapeIndex + i] = shapeValue;
            }
            return shapeIndex + shapeCount;
        }

        private Deque<boolean[]> initGroupStack(boolean[] curBifurcationNodeShape) {
            ArrayDeque<boolean[]> groupStack = new ArrayDeque<boolean[]>();
            groupStack.push(new boolean[this.bifurcationCount]);
            for (int i = curBifurcationNodeShape.length; i > 0; i -= this.bifurcationCount) {
                boolean[] group = new boolean[this.bifurcationCount];
                System.arraycopy(curBifurcationNodeShape, i - this.bifurcationCount, group, 0, this.bifurcationCount);
                groupStack.push(group);
            }
            return groupStack;
        }

        private int fetchFromGroup(Deque<boolean[]> groupStack, Deque<Boolean> nodeTypeStack, boolean[] shape, int shapeIndex) {
            boolean[] bitGroup = groupStack.pop();
            this.pushToTypeStack(bitGroup, nodeTypeStack);
            return this.writeShape(shape, shapeIndex, true, this.bifurcationCount);
        }

        private void pushToTypeStack(boolean[] bitGroup, Deque<Boolean> nodeTypeStack) {
            for (int i = bitGroup.length - 1; i >= 0; --i) {
                nodeTypeStack.push(bitGroup[i]);
            }
        }

        private boolean nextShape() {
            int lastBifIndex = this.lastIndexOf(this.curBifurcationNodeShape, this.curBifurcationNodeShape.length - 1, true);
            int lastLeafIndex = this.lastIndexOf(this.curBifurcationNodeShape, lastBifIndex - 1, false);
            if (lastLeafIndex == -1) {
                return false;
            }
            this.curBifurcationNodeShape[lastLeafIndex] = true;
            for (int index = lastLeafIndex + 1; index <= lastBifIndex; ++index) {
                this.curBifurcationNodeShape[index] = false;
            }
            this.resetSubShape(this.curBifurcationNodeShape, lastBifIndex - lastLeafIndex - 1);
            return true;
        }

        private int lastIndexOf(boolean[] curBifurcationNodeShape, int index, boolean targetBit) {
            while (index >= 0) {
                if (curBifurcationNodeShape[index] == targetBit) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        private void resetSubShape(boolean[] bifurcationShape, int bifBitCount) {
            for (int curIndex = bifurcationShape.length - 1; bifBitCount > 0 && curIndex >= 0; curIndex -= this.bifurcationCount, --bifBitCount) {
                bifurcationShape[curIndex] = true;
            }
        }

        private boolean[] initBifurcationShape() {
            boolean[] bifurcationShape = new boolean[(this.bifurcationNodeCount - 1) * this.bifurcationCount];
            this.resetSubShape(bifurcationShape, this.bifurcationNodeCount - 1);
            return bifurcationShape;
        }
    }
}

