/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.tree;

import java.util.List;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface TreeNode<T> {
    public T getData();

    default public boolean beLeafNode() {
        List<TreeNode<T>> subNodes = this.getSubNodes();
        return subNodes == null || subNodes.isEmpty();
    }

    public List<TreeNode<T>> getSubNodes();

    default public Stream<TreeNode<T>> subNodeStream() {
        return this.beLeafNode() ? Stream.empty() : this.getSubNodes().stream();
    }

    default public Stream<TreeNode<T>> nodeStream() {
        return this.beLeafNode() ? Stream.of(this) : Stream.concat(Stream.of(this), this.getSubNodes().stream().flatMap(TreeNode::nodeStream));
    }

    default public Stream<TreeNode<T>> allSubNodeStream() {
        return this.beLeafNode() ? Stream.empty() : this.getSubNodes().stream().flatMap(TreeNode::nodeStream);
    }

    default public <R> Stream<R> allSubNodeStream(BiFunction<TreeNode<T>, TreeNode<T>, R> itemCreator) {
        List<TreeNode<T>> subNodes = this.getSubNodes();
        if (subNodes == null) {
            return Stream.empty();
        }
        return subNodes.stream().flatMap(item -> Stream.concat(Stream.of(itemCreator.apply((TreeNode<T>)item, this)), item.allSubNodeStream(itemCreator)));
    }

    default public TreeNode<T> cloneNode() {
        List<TreeNode<T>> subNodes = this.getSubNodes();
        List newSubNodes = subNodes == null ? null : subNodes.stream().map(TreeNode::cloneNode).collect(Collectors.toList());
        return this.cloneWithSubNodes(newSubNodes);
    }

    public TreeNode<T> cloneWithSubNodes(List<TreeNode<T>> var1);

    default public <NT> NT mapTree(Function<TreeNode<T>, NT> nodeConvertor, BiConsumer<NT, NT> newNodeAccepter) {
        NT head = nodeConvertor.apply(this);
        Stack digStack = new Stack();
        digStack.push(new NodeHolder<TreeNode, NT>(this, head));
        while (!digStack.isEmpty()) {
            NodeHolder curHolder = (NodeHolder)digStack.pop();
            Object newNode = curHolder.getNewNode();
            ((TreeNode)curHolder.treeNode).subNodeStream().forEach(subNode -> {
                Object newSubNode = nodeConvertor.apply((TreeNode<TreeNode>)subNode);
                newNodeAccepter.accept(newSubNode, newNode);
                if (!subNode.beLeafNode()) {
                    digStack.push(new NodeHolder((TreeNode)subNode, newSubNode));
                }
            });
        }
        return head;
    }

    public static class NodeHolder<TT, NT> {
        private TT treeNode;
        private NT newNode;

        public TT getTreeNode() {
            return this.treeNode;
        }

        public NT getNewNode() {
            return this.newNode;
        }

        public NodeHolder(TT treeNode, NT newNode) {
            this.treeNode = treeNode;
            this.newNode = newNode;
        }
    }
}

