/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.tree;

import com.happy3w.math.tree.TreeNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface WritableTreeNode<T>
extends TreeNode<T> {
    public void setSubNodes(List<TreeNode<T>> var1);

    default public WritableTreeNode<T> filterNodes(Predicate<TreeNode<T>> checker) {
        LinkedList<TreeNode<T>> queue = new LinkedList<TreeNode<T>>();
        queue.add(this);
        while (!queue.isEmpty()) {
            TreeNode curNode = (TreeNode)queue.poll();
            if (curNode.getSubNodes() == null) continue;
            List<TreeNode<T>> newSubNodes = this.filterNodes(curNode.getSubNodes(), checker, queue).collect(Collectors.toList());
            if (Objects.equals(curNode.getSubNodes(), newSubNodes)) continue;
            if (curNode instanceof WritableTreeNode) {
                ((WritableTreeNode)curNode).setSubNodes(newSubNodes);
                continue;
            }
            throw new UnsupportedOperationException("Failed to modify readonly tree node:" + curNode.getData() + " node type:" + curNode.getClass());
        }
        return this;
    }

    default public Stream<TreeNode<T>> filterNodes(List<TreeNode<T>> nodeList, Predicate<TreeNode<T>> checker, Queue<TreeNode<T>> queue) {
        return nodeList.stream().flatMap(subItem -> {
            if (checker.test((TreeNode<T>)subItem)) {
                queue.add((TreeNode<T>)subItem);
                return Stream.of(subItem);
            }
            if (subItem == null || subItem.beLeafNode()) {
                return Stream.empty();
            }
            return this.filterNodes(subItem.getSubNodes(), checker, queue);
        });
    }
}

