/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;

public class IndexMapper<T> {
    private int baseValueSize;
    private T[] metaValues;
    private int[] metaCounts;

    public IndexMapper(T[] baseValues, BiPredicate<T, T> equalChecker) {
        int[] itemCountsTemp = new int[baseValues.length];
        Arrays.fill(itemCountsTemp, 1);
        ArrayList<T> collectValues = new ArrayList<T>();
        for (T value : baseValues) {
            int index = IndexMapper.indexOf(collectValues, value, equalChecker);
            if (index >= 0) {
                int n = index;
                itemCountsTemp[n] = itemCountsTemp[n] + 1;
                continue;
            }
            collectValues.add(value);
        }
        this.baseValueSize = baseValues.length;
        this.metaValues = (Object[])Array.newInstance(baseValues.getClass().getComponentType(), collectValues.size());
        this.metaValues = collectValues.toArray(this.metaValues);
        this.metaCounts = Arrays.copyOf(itemCountsTemp, this.metaValues.length);
    }

    public T[] convertValues(int[] indexes) {
        int size = indexes.length;
        Object[] values = (Object[])Array.newInstance(this.metaValues.getClass().getComponentType(), size);
        for (int i = 0; i < size; ++i) {
            values[i] = this.metaValues[indexes[i]];
        }
        return values;
    }

    public int[] createStartValues() {
        int[] startValues = new int[this.baseValueSize];
        int curIndex = 0;
        for (int itemIndex = 0; itemIndex < this.metaCounts.length; ++itemIndex) {
            int count = this.metaCounts[itemIndex];
            Arrays.fill(startValues, curIndex, curIndex + count, itemIndex);
            curIndex += count;
        }
        return startValues;
    }

    private static <T> int indexOf(List<T> values, T value, BiPredicate<T, T> equalChecker) {
        for (int index = values.size() - 1; index >= 0; --index) {
            T existValue = values.get(index);
            if (!equalChecker.test(existValue, value)) continue;
            return index;
        }
        return -1;
    }

    public int getBaseValueSize() {
        return this.baseValueSize;
    }

    public T[] getMetaValues() {
        return this.metaValues;
    }

    public int[] getMetaCounts() {
        return this.metaCounts;
    }
}

