/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Packet;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class CallTest {
    @Test
    public void testGetResponse() throws Exception {
        Object response = new Object();
        Packet request = new Packet();
        long callId = 1L;
        Call call = new Call(Long.valueOf(callId), request);
        call.setResponse(response);
        Object realResponse = call.getResponse();
        Assert.assertEquals((Object)response, (Object)realResponse);
        Assert.assertEquals((long)callId, (long)request.getCallId());
    }

    @Test(expected=RuntimeException.class)
    public void testGetResponseAsException() throws Exception {
        RuntimeException response = new RuntimeException();
        Packet request = new Packet();
        long callId = 1L;
        Call call = new Call(Long.valueOf(callId), request);
        call.setResponse((Object)response);
        Object realResponse = call.getResponse();
        Assert.assertEquals((Object)response, (Object)realResponse);
        Assert.assertEquals((long)callId, (long)request.getCallId());
    }

    @Test
    public void testGetResponseOnTime() throws Exception {
        final Object response = new Object();
        Packet request = new Packet();
        long callId = 1L;
        final Call call = new Call(Long.valueOf(callId), request);
        new Thread(new Runnable(){

            public void run() {
                call.setResponse(response);
            }
        }).start();
        Object realResponse = call.getResponse(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)response, (Object)realResponse);
        Assert.assertEquals((long)callId, (long)request.getCallId());
    }

    @Test
    public void testGetResponseNotOnTime() throws Exception {
        final Object response = new Object();
        Packet request = new Packet();
        long callId = 1L;
        final Call call = new Call(Long.valueOf(callId), request);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                call.setResponse(response);
            }
        }).start();
        Object realResponse = call.getResponse(1L, TimeUnit.SECONDS);
        Assert.assertNull((Object)realResponse);
        Assert.assertEquals((long)callId, (long)request.getCallId());
    }
}

