/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientRunnable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class ClientRunnableTest {
    @Test
    public void testRun() throws Exception {
        final CountDownLatch waitLatch = new CountDownLatch(1);
        final ClientRunnable clientRunnable = new ClientRunnable(){

            protected void customRun() throws InterruptedException {
                waitLatch.countDown();
            }
        };
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    waitLatch.await(10L, TimeUnit.SECONDS);
                    Object object = clientRunnable.monitor;
                    synchronized (object) {
                        clientRunnable.running = false;
                        clientRunnable.monitor.wait();
                    }
                    latch.countDown();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
        clientRunnable.run();
        Assert.assertTrue((String)"Not notified", (boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testShutdown() throws Exception {
        final ClientRunnable clientRunnable = new ClientRunnable(){

            protected void customRun() throws InterruptedException {
            }
        };
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        final CountDownLatch latchShutDown = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                try {
                    latch1.await();
                    latch2.countDown();
                    clientRunnable.shutdown();
                    latchShutDown.countDown();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
        latch1.countDown();
        latch2.await();
        Thread.sleep(10L);
        clientRunnable.notifyMonitor();
        Assert.assertTrue((boolean)latchShutDown.await(5L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)clientRunnable.running);
    }
}

