/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientBinder;
import com.hazelcast.client.Connection;
import com.hazelcast.client.ConnectionManager;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LifecycleServiceClientImpl;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManagerTest {
    private LifecycleServiceClientImpl createLifecycleServiceClientImpl(HazelcastClient hazelcastClient, final List<LifecycleEvent.LifecycleState> lifecycleEvents) {
        LifecycleServiceClientImpl lifecycleService = new LifecycleServiceClientImpl(hazelcastClient);
        lifecycleService.addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                lifecycleEvents.add(event.getState());
            }
        });
        return lifecycleService;
    }

    @Test
    public void testGetConnection() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        final Connection connection = (Connection)Mockito.mock(Connection.class);
        final CountDownLatch latch = new CountDownLatch(2);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                latch.countDown();
                return connection;
            }
        };
        ClientBinder binder = (ClientBinder)Mockito.mock(ClientBinder.class);
        connectionManager.setBinder(binder);
        connectionManager.getConnection();
        Assert.assertEquals((Object)connection, (Object)connectionManager.getConnection());
        ((ClientBinder)Mockito.verify((Object)binder)).bind(connection);
        Assert.assertEquals((Object)connection, (Object)connectionManager.getConnection());
        Assert.assertEquals((long)1L, (long)latch.getCount());
        Assert.assertArrayEquals((Object[])new Object[]{LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENING}, (Object[])lifecycleEvents.toArray());
    }

    @Test
    public void testGetConnectionWhenThereIsNoConnection() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                return null;
            }
        };
        ClientBinder binder = (ClientBinder)Mockito.mock(ClientBinder.class);
        connectionManager.setBinder(binder);
        connectionManager.getConnection();
        Assert.assertEquals(null, (Object)connectionManager.getConnection());
        Assert.assertEquals(null, (Object)connectionManager.getConnection());
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])lifecycleEvents.toArray());
    }

    @Test
    public void testDestroyConnection() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        final Connection connection = (Connection)Mockito.mock(Connection.class);
        final CountDownLatch latch = new CountDownLatch(2);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                latch.countDown();
                return connection;
            }
        };
        ClientBinder binder = (ClientBinder)Mockito.mock(ClientBinder.class);
        connectionManager.setBinder(binder);
        Assert.assertEquals((Object)connection, (Object)connectionManager.getConnection());
        connectionManager.destroyConnection(connection);
        connectionManager.getConnection();
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertArrayEquals((Object[])new Object[]{LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENING, LifecycleEvent.LifecycleState.CLIENT_CONNECTION_LOST, LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENING}, (Object[])lifecycleEvents.toArray());
    }

    @Test
    public void testSameMemberAdded() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        final Connection connection = (Connection)Mockito.mock(Connection.class);
        final CountDownLatch latch = new CountDownLatch(2);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                latch.countDown();
                return connection;
            }
        };
        ClientBinder binder = (ClientBinder)Mockito.mock(ClientBinder.class);
        connectionManager.setBinder(binder);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Member member = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)member.getInetSocketAddress()).thenReturn((Object)inetSocketAddress);
        MembershipEvent membershipEvent = new MembershipEvent(cluster, member, 1);
        connectionManager.memberAdded(membershipEvent);
        connectionManager.getClusterMembers().contains(inetSocketAddress);
        Assert.assertEquals((long)1L, (long)connectionManager.getClusterMembers().size());
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])lifecycleEvents.toArray());
    }

    @Test
    public void testDifferentMemberAdded() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        final Connection connection = (Connection)Mockito.mock(Connection.class);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                return connection;
            }
        };
        ClientBinder binder = (ClientBinder)Mockito.mock(ClientBinder.class);
        connectionManager.setBinder(binder);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress("hostname", 5702);
        Member member = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)member.getInetSocketAddress()).thenReturn((Object)inetSocketAddress2);
        MembershipEvent membershipEvent = new MembershipEvent(cluster, member, 1);
        connectionManager.memberAdded(membershipEvent);
        connectionManager.getClusterMembers().contains(inetSocketAddress2);
        Assert.assertEquals((long)2L, (long)connectionManager.getClusterMembers().size());
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])lifecycleEvents.toArray());
    }

    @Test
    public void testMemberRemoved() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        final Connection connection = (Connection)Mockito.mock(Connection.class);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                return connection;
            }
        };
        ClientBinder binder = (ClientBinder)Mockito.mock(ClientBinder.class);
        connectionManager.setBinder(binder);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Member member = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)member.getInetSocketAddress()).thenReturn((Object)inetSocketAddress);
        MembershipEvent membershipEvent = new MembershipEvent(cluster, member, 3);
        connectionManager.memberRemoved(membershipEvent);
        Assert.assertEquals((long)0L, (long)connectionManager.getClusterMembers().size());
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])lifecycleEvents.toArray());
    }

    @Test
    public void testUpdateMembers() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)client.getCluster()).thenReturn((Object)cluster);
        HashSet<Member> members = new HashSet<Member>();
        Member member1 = (Member)Mockito.mock(Member.class);
        Member member2 = (Member)Mockito.mock(Member.class);
        Member member3 = (Member)Mockito.mock(Member.class);
        InetSocketAddress inetSocketAddress1 = new InetSocketAddress("localhost", 9701);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress("localhost", 9702);
        InetSocketAddress inetSocketAddress3 = new InetSocketAddress("localhost", 9703);
        Mockito.when((Object)member1.getInetSocketAddress()).thenReturn((Object)inetSocketAddress1);
        Mockito.when((Object)member2.getInetSocketAddress()).thenReturn((Object)inetSocketAddress2);
        Mockito.when((Object)member3.getInetSocketAddress()).thenReturn((Object)inetSocketAddress3);
        members.add(member1);
        members.add(member2);
        members.add(member3);
        Mockito.when((Object)cluster.getMembers()).thenReturn(members);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        final Connection connection = (Connection)Mockito.mock(Connection.class);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                return connection;
            }
        };
        ClientBinder binder = (ClientBinder)Mockito.mock(ClientBinder.class);
        connectionManager.setBinder(binder);
        connectionManager.updateMembers();
        Assert.assertTrue((boolean)connectionManager.getClusterMembers().contains(inetSocketAddress1));
        Assert.assertTrue((boolean)connectionManager.getClusterMembers().contains(inetSocketAddress2));
        Assert.assertTrue((boolean)connectionManager.getClusterMembers().contains(inetSocketAddress3));
        Assert.assertFalse((boolean)connectionManager.getClusterMembers().contains(inetSocketAddress));
        Assert.assertEquals((long)3L, (long)connectionManager.getClusterMembers().size());
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])lifecycleEvents.toArray());
    }

    @Test
    public void testShouldExecuteOnDisconnect() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", 5701);
        final Connection connection = (Connection)Mockito.mock(Connection.class);
        ArrayList<LifecycleEvent.LifecycleState> lifecycleEvents = new ArrayList<LifecycleEvent.LifecycleState>();
        LifecycleServiceClientImpl lifecycleService = this.createLifecycleServiceClientImpl(client, lifecycleEvents);
        ConnectionManager connectionManager = new ConnectionManager(client, lifecycleService, inetSocketAddress){

            protected Connection getNextConnection() {
                return connection;
            }
        };
        Assert.assertTrue((boolean)connectionManager.shouldExecuteOnDisconnect(connection));
        Assert.assertFalse((boolean)connectionManager.shouldExecuteOnDisconnect(connection));
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])lifecycleEvents.toArray());
    }
}

