/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.TestUtility;
import com.hazelcast.config.Config;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HazelcastClientAtomicNumberTest {
    @Before
    @After
    public void after() throws Exception {
        System.out.flush();
        System.err.flush();
        TestUtility.destroyClients();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testSimple() throws Exception {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        HazelcastClient client = TestUtility.newHazelcastClient(h1);
        String name = "simple";
        AtomicNumber nodeAtomicNumber = h1.getAtomicNumber("simple");
        AtomicNumber clientAtomicNumber = client.getAtomicNumber("simple");
        this.check(nodeAtomicNumber, clientAtomicNumber, 0L);
        Assert.assertEquals((long)1L, (long)clientAtomicNumber.incrementAndGet());
        this.check(nodeAtomicNumber, clientAtomicNumber, 1L);
        Assert.assertEquals((long)1L, (long)clientAtomicNumber.getAndAdd(1L));
        this.check(nodeAtomicNumber, clientAtomicNumber, 2L);
        Assert.assertEquals((long)1L, (long)clientAtomicNumber.decrementAndGet());
        this.check(nodeAtomicNumber, clientAtomicNumber, 1L);
        Assert.assertEquals((long)2L, (long)clientAtomicNumber.addAndGet(1L));
        this.check(nodeAtomicNumber, clientAtomicNumber, 2L);
        clientAtomicNumber.set(3L);
        this.check(nodeAtomicNumber, clientAtomicNumber, 3L);
        Assert.assertFalse((boolean)clientAtomicNumber.compareAndSet(4L, 1L));
        this.check(nodeAtomicNumber, clientAtomicNumber, 3L);
        Assert.assertTrue((boolean)clientAtomicNumber.compareAndSet(3L, 1L));
        this.check(nodeAtomicNumber, clientAtomicNumber, 1L);
    }

    private void check(AtomicNumber nodeAtomicNumber, AtomicNumber clientAtomicNumber, long expectedValue) {
        Assert.assertEquals((long)expectedValue, (long)nodeAtomicNumber.get());
        Assert.assertEquals((long)expectedValue, (long)clientAtomicNumber.get());
    }
}

