/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientProperties;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.NoMemberAvailableException;
import com.hazelcast.client.TestUtility;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HazelcastClientClusterTest {
    @After
    @Before
    public void cleanup() throws Exception {
        Hazelcast.shutdownAll();
    }

    @After
    public void after() throws Exception {
        TestUtility.destroyClients();
    }

    @Test
    public void testUseBackupDataGet() throws Exception {
        Config config = new Config();
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName("q");
        mapConfig.setReadBackupData(true);
        config.setMapConfigs(Collections.singletonMap(mapConfig.getName(), mapConfig));
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)config);
        h1.getMap("q").put((Object)"q", (Object)"Q");
        Thread.sleep(50L);
        HazelcastClient client = TestUtility.newHazelcastClient(h2);
        Assert.assertEquals((Object)"Q", (Object)client.getMap("q").get((Object)"q"));
    }

    @Test
    public void testNearCache() throws Exception {
        Config config = new Config();
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setMaxSize(1000);
        config.getMapConfig("default").setNearCacheConfig(nearCacheConfig);
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)config);
        IMap m1 = h1.getMap("default");
        m1.put((Object)"1", (Object)"value");
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)config);
        IMap m2 = h2.getMap("default");
        Assert.assertEquals((Object)"value", (Object)m2.get((Object)"1"));
        Assert.assertEquals((Object)"value", (Object)m1.get((Object)"1"));
        HazelcastClient client1 = TestUtility.newHazelcastClient(h1);
        HazelcastClient client2 = TestUtility.newHazelcastClient(h2);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)"value", (Object)client1.getMap("default").get((Object)"1"));
            Assert.assertEquals((Object)"value", (Object)client2.getMap("default").get((Object)"1"));
        }
    }

    @Test
    public void testMembershipListener() throws Exception {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        HazelcastClient client = TestUtility.newHazelcastClient(h1);
        final CountDownLatch memberAddLatch = new CountDownLatch(1);
        final CountDownLatch memberRemoveLatch = new CountDownLatch(1);
        client.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                memberAddLatch.countDown();
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                memberRemoveLatch.countDown();
            }
        });
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)new Config());
        h2.getLifecycleService().shutdown();
        Assert.assertTrue((boolean)memberAddLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)memberRemoveLatch.await(10L, TimeUnit.SECONDS));
        client.shutdown();
    }

    @Test(expected=IllegalStateException.class, timeout=50000L)
    public void testNoClusterOnStart() throws Exception {
        ClientProperties clientProperties = ClientProperties.crateBaseClientProperties((String)"dev", (String)"dev-pass");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.INIT_CONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT, "500");
        HazelcastClient.newHazelcastClient((ClientProperties)clientProperties, (String)"localhost:5701");
    }

    @Test(expected=NoMemberAvailableException.class, timeout=50000L)
    public void testNoClusterAfterStart() throws Exception {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        ClientProperties clientProperties = ClientProperties.crateBaseClientProperties((String)"dev", (String)"dev-pass");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.INIT_CONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT, "100");
        HazelcastClient client = TestUtility.newHazelcastClient(clientProperties, h1);
        IMap map = client.getMap("default");
        map.put((Object)"smth", (Object)"nothing");
        h1.getLifecycleService().shutdown();
        map.put((Object)"smth", (Object)"nothing");
    }

    @Test(timeout=120000L)
    public void testRestartCluster() throws Exception {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        ClientProperties clientProperties = ClientProperties.crateBaseClientProperties((String)"dev", (String)"dev-pass");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.INIT_CONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT, "500");
        HazelcastClient client = TestUtility.newHazelcastClient(clientProperties, h1);
        IMap map = client.getMap("default");
        final CopyOnWriteArrayList values = new CopyOnWriteArrayList();
        map.addEntryListener((EntryListener)new EntryAdapter<String, String>(){

            public void entryAdded(EntryEvent<String, String> event) {
                values.add(event.getValue());
            }

            public void entryUpdated(EntryEvent<String, String> event) {
                values.add(event.getValue());
            }
        }, true);
        final LinkedBlockingQueue states = new LinkedBlockingQueue();
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                states.add(event.getState());
            }
        });
        map.put((Object)"smth", (Object)"nothing1");
        Thread.sleep(50L);
        Assert.assertArrayEquals((String)((Object)values).toString(), (Object[])new String[]{"nothing1"}, (Object[])values.toArray(new String[0]));
        h1.getLifecycleService().shutdown();
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTION_LOST, states.poll(500L, TimeUnit.MILLISECONDS));
        Thread.sleep(50L);
        try {
            map.put((Object)"smth", (Object)"nothing2");
            Assert.fail((String)"nothing2");
        }
        catch (NoMemberAvailableException e) {
            // empty catch block
        }
        try {
            map.put((Object)"smth", (Object)"nothing3");
            Assert.fail((String)"nothing3");
        }
        catch (NoMemberAvailableException e) {
            // empty catch block
        }
        h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENING, states.poll(500L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENED, states.poll(30000L, TimeUnit.MILLISECONDS));
        map.put((Object)"smth", (Object)"nothing4");
        Thread.sleep(50L);
        Assert.assertArrayEquals((String)((Object)values).toString(), (Object[])new String[]{"nothing1", "nothing4"}, (Object[])values.toArray(new String[0]));
    }

    @Test(timeout=120000L)
    public void testRestartClusterTwice() throws Exception {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        ClientProperties clientProperties = ClientProperties.crateBaseClientProperties((String)"dev", (String)"dev-pass");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.INIT_CONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_ATTEMPTS_LIMIT, "5");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT, "1000");
        HazelcastClient client = TestUtility.newHazelcastClient(clientProperties, h1);
        IMap map = client.getMap("default");
        final ArrayList values = new ArrayList();
        map.addEntryListener((EntryListener)new EntryAdapter<String, String>(){

            public void entryAdded(EntryEvent<String, String> event) {
                values.add(event.getValue());
            }

            public void entryUpdated(EntryEvent<String, String> event) {
                values.add(event.getValue());
            }
        }, true);
        final LinkedBlockingQueue states = new LinkedBlockingQueue();
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                states.add(event.getState());
            }
        });
        map.put((Object)"smth", (Object)"nothing");
        for (int i = 0; i < 2; ++i) {
            h1.getLifecycleService().shutdown();
            Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTION_LOST, states.poll(500L, TimeUnit.MILLISECONDS));
            try {
                map.put((Object)"smth", (Object)("nothing-" + i));
                Assert.fail();
            }
            catch (NoMemberAvailableException e) {
                // empty catch block
            }
            Thread.sleep(50L);
            try {
                map.put((Object)"smth", (Object)("nothing_" + i));
                Assert.fail();
            }
            catch (NoMemberAvailableException e) {
                // empty catch block
            }
            Thread.sleep(50L);
            h1 = Hazelcast.newHazelcastInstance((Config)new Config());
            Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENING, states.poll(500L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENED, states.poll(1000L, TimeUnit.MILLISECONDS));
            map.put((Object)"smth", (Object)("nothing" + i));
            Thread.sleep(50L);
        }
        Assert.assertArrayEquals((String)((Object)values).toString(), (Object[])new String[]{"nothing", "nothing0", "nothing1"}, (Object[])values.toArray(new String[0]));
    }

    @Test(expected=NoMemberAvailableException.class)
    public void testNoClusterAfterStartIssue328() throws Exception {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        ClientProperties clientProperties = ClientProperties.crateBaseClientProperties((String)"dev", (String)"dev-pass");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.INIT_CONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT, "500");
        HazelcastClient client = TestUtility.newHazelcastClient(clientProperties, h1);
        IMap map = client.getMap("default");
        h1.getLifecycleService().shutdown();
        map.put((Object)"smth", (Object)"nothing");
    }
}

