/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ExecutorServiceTest;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiTask;
import com.hazelcast.monitor.DistributedMapStatsCallable;
import com.hazelcast.monitor.DistributedMemberInfoCallable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Test;

public class HazelcastClientExecutorServiceTest
extends HazelcastClientTestBase {
    private static final int COUNT = 10;

    @Test
    public void isTwoGetFromFuture() throws Exception {
        ExecutorServiceTest.BasicTestTask task = new ExecutorServiceTest.BasicTestTask();
        ExecutorService executor = this.getExecutorService();
        Future future = executor.submit(task);
        String s1 = (String)future.get();
        Assert.assertEquals((String)ExecutorServiceTest.BasicTestTask.RESULT, (String)s1);
        Assert.assertTrue((boolean)future.isDone());
        String s2 = (String)future.get();
        Assert.assertEquals((String)ExecutorServiceTest.BasicTestTask.RESULT, (String)s2);
        Assert.assertTrue((boolean)future.isDone());
        String s3 = (String)future.get();
        Assert.assertEquals((String)ExecutorServiceTest.BasicTestTask.RESULT, (String)s3);
        Assert.assertTrue((boolean)future.isDone());
        String s4 = (String)future.get();
        Assert.assertEquals((String)ExecutorServiceTest.BasicTestTask.RESULT, (String)s4);
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void testInvokeAll() throws Exception {
        int i;
        ExecutorServiceTest.BasicTestTask task = new ExecutorServiceTest.BasicTestTask();
        ExecutorService executor = this.getExecutorService();
        ArrayList<ExecutorServiceTest.BasicTestTask> tasks = new ArrayList<ExecutorServiceTest.BasicTestTask>();
        tasks.add(task);
        List futures = executor.invokeAll(tasks);
        Assert.assertEquals((int)futures.size(), (int)1);
        Assert.assertEquals((String)((String)futures.get(0).get()), (String)ExecutorServiceTest.BasicTestTask.RESULT);
        tasks.clear();
        for (i = 0; i < 10; ++i) {
            tasks.add(new ExecutorServiceTest.BasicTestTask());
        }
        futures = executor.invokeAll(tasks);
        Assert.assertEquals((int)futures.size(), (int)10);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((String)((String)futures.get(i).get()), (String)ExecutorServiceTest.BasicTestTask.RESULT);
        }
    }

    @Test(expected=NullPointerException.class)
    public void submitNullTask() {
        Callable callable = null;
        this.getExecutorService().submit(callable);
        Assert.fail();
    }

    private ExecutorService getExecutorService() {
        HazelcastClient hClient = this.getHazelcastClient();
        return hClient.getExecutorService();
    }

    @Test
    public void testBasicTask() throws Exception {
        ExecutorServiceTest.BasicTestTask task = new ExecutorServiceTest.BasicTestTask();
        ExecutorService executor = this.getExecutorService();
        Future future = executor.submit(task);
        Assert.assertEquals(future.get(), (Object)ExecutorServiceTest.BasicTestTask.RESULT);
    }

    @Test
    public void isDoneMethod() throws Exception {
        ExecutorServiceTest.BasicTestTask task = new ExecutorServiceTest.BasicTestTask();
        ExecutorService executor = this.getExecutorService();
        Future future = executor.submit(task);
        if (future.isDone()) {
            Assert.assertTrue((boolean)future.isDone());
        }
        Assert.assertEquals(future.get(), (Object)ExecutorServiceTest.BasicTestTask.RESULT);
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void isDoneMethod_issue129() throws Exception {
        ExecutorService executor = this.getExecutorService();
        for (int i = 0; i < 10; ++i) {
            ExecutorServiceTest.BasicTestTask task1 = new ExecutorServiceTest.BasicTestTask();
            ExecutorServiceTest.BasicTestTask task2 = new ExecutorServiceTest.BasicTestTask();
            Future future1 = executor.submit(task1);
            Future future2 = executor.submit(task2);
            Assert.assertEquals(future2.get(), (Object)ExecutorServiceTest.BasicTestTask.RESULT);
            Assert.assertTrue((boolean)future2.isDone());
            Assert.assertEquals(future1.get(), (Object)ExecutorServiceTest.BasicTestTask.RESULT);
            Assert.assertTrue((boolean)future1.isDone());
        }
    }

    @Test
    public void testBasicRunnable() throws Exception {
        ExecutorService executor = this.getExecutorService();
        Future<?> future = executor.submit(new BasicRunnable());
        Assert.assertNull(future.get());
    }

    @Test
    public void multiTaskWithOneMember() throws ExecutionException, InterruptedException {
        ExecutorService esService = this.getExecutorService();
        Set members = this.getHazelcastClient().getCluster().getMembers();
        MultiTask task = new MultiTask((Callable)new DistributedMapStatsCallable("default"), members);
        esService.submit((Runnable)task);
        Collection mapStats = null;
        mapStats = task.get();
        for (DistributedMapStatsCallable.MemberMapStat memberMapStat : mapStats) {
            Assert.assertNotNull((Object)memberMapStat);
        }
        Assert.assertEquals((int)members.size(), (int)mapStats.size());
    }

    @Test
    public void distributedTaskOnMember() throws ExecutionException, InterruptedException {
        ExecutorService ex = this.getExecutorService();
        Member member = (Member)this.getHazelcastClient().getCluster().getMembers().iterator().next();
        DistributedTask task = new DistributedTask((Callable)new ExecutorServiceTest.BasicTestTask(), member);
        ex.execute((Runnable)task);
        Object resul = task.get();
        Assert.assertEquals((Object)ExecutorServiceTest.BasicTestTask.RESULT, (Object)resul);
    }

    @Test
    public void distributedTaskCallBack() throws ExecutionException, InterruptedException {
        ExecutorService ex = this.getExecutorService();
        Member member = (Member)this.getHazelcastClient().getCluster().getMembers().iterator().next();
        DistributedTask task = new DistributedTask((Callable)new ExecutorServiceTest.BasicTestTask(), member);
        final CountDownLatch latch = new CountDownLatch(1);
        task.setExecutionCallback(new ExecutionCallback(){

            public void done(Future future) {
                latch.countDown();
            }
        });
        ex.execute((Runnable)task);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void multiTaskCallBack() throws ExecutionException, InterruptedException {
        ExecutorService esService = this.getExecutorService();
        Set members = this.getHazelcastClient().getCluster().getMembers();
        MultiTask task = new MultiTask((Callable)new DistributedMapStatsCallable("default"), members);
        final CountDownLatch latch = new CountDownLatch(1);
        task.setExecutionCallback(new ExecutionCallback(){

            public void done(Future future) {
                latch.countDown();
            }
        });
        esService.execute((Runnable)task);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void distributedTaskGetMemberInfo() throws ExecutionException, InterruptedException {
        ExecutorService esService = this.getExecutorService();
        Member member = (Member)this.getHazelcastClient().getCluster().getMembers().iterator().next();
        DistributedTask task = new DistributedTask((Callable)new DistributedMemberInfoCallable(), member);
        esService.execute((Runnable)task);
        DistributedMemberInfoCallable.MemberInfo result = (DistributedMemberInfoCallable.MemberInfo)task.get();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testClientCancel() throws Exception {
        Future future = this.getExecutorService().submit(new SimpleTask());
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)future.cancel(true));
        Assert.assertTrue((boolean)future.isCancelled());
    }

    static class SimpleTask
    implements Callable,
    Serializable {
        SimpleTask() {
        }

        public Object call() {
            System.out.println("*** Task has started...");
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    System.out.println("*** Task is running...");
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("*** Task has finished...");
            return null;
        }
    }

    public static class BasicRunnable
    implements Runnable,
    Serializable {
        public void run() {
        }
    }
}

