/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.CountDownItemListener;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.IList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class HazelcastClientListTest
extends HazelcastClientTestBase {
    @Test(expected=NullPointerException.class)
    public void addNull() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("addNull");
        list.add(null);
    }

    @Test
    public void getListName() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("getListName");
        Assert.assertEquals((Object)"getListName", (Object)list.getName());
    }

    @Test
    @Ignore
    public void addRemoveItemListener() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("addRemoveItemListenerList");
        CountDownLatch addLatch = new CountDownLatch(4);
        CountDownLatch removeLatch = new CountDownLatch(4);
        CountDownItemListener listener = new CountDownItemListener(addLatch, removeLatch);
        list.addItemListener(listener, true);
        list.add((Object)"hello");
        list.add((Object)"hello");
        list.remove((Object)"hello");
        list.remove((Object)"hello");
        list.removeItemListener(listener);
        list.add((Object)"hello");
        list.add((Object)"hello");
        list.remove((Object)"hello");
        list.remove((Object)"hello");
        Thread.sleep(10L);
        Assert.assertEquals((long)2L, (long)addLatch.getCount());
        Assert.assertEquals((long)2L, (long)removeLatch.getCount());
    }

    @Test
    public void destroy() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("destroy");
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)list.add((Object)i));
        }
        IList list2 = hClient.getList("destroy");
        Assert.assertTrue((list == list2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.getId().equals(list2.getId()));
        list.destroy();
        list2 = hClient.getList("destroy");
        Assert.assertFalse((list == list2 ? 1 : 0) != 0);
    }

    @Test
    public void add() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("add");
        int count = 100;
        for (int i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)list.add((Object)i));
        }
    }

    @Test
    public void contains() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("contains");
        int count = 100;
        for (i = 0; i < count; ++i) {
            list.add((Object)i);
        }
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)list.contains((Object)i));
        }
        for (i = count; i < 2 * count; ++i) {
            Assert.assertFalse((boolean)list.contains((Object)i));
        }
    }

    @Test
    public void addAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("addAll");
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            arrList.add(i);
        }
        Assert.assertTrue((boolean)list.addAll(arrList));
    }

    @Test
    public void containsAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("containsAll");
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            arrList.add(i);
        }
        Assert.assertTrue((boolean)list.addAll(arrList));
        Assert.assertTrue((boolean)list.containsAll(arrList));
        arrList.set(count / 2, count + 1);
        Assert.assertFalse((boolean)list.containsAll(arrList));
    }

    @Test
    public void size() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("size");
        int count = 100;
        Assert.assertTrue((boolean)list.isEmpty());
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)list.add((Object)i));
        }
        Assert.assertEquals((long)count, (long)list.size());
        for (i = 0; i < count / 2; ++i) {
            Assert.assertTrue((boolean)list.add((Object)i));
        }
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((long)(count + count / 2), (long)list.size());
    }

    @Test
    public void remove() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("remove");
        int count = 100;
        Assert.assertTrue((boolean)list.isEmpty());
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)list.add((Object)i));
        }
        Assert.assertEquals((long)count, (long)list.size());
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)list.remove((Object)i));
        }
        Assert.assertTrue((boolean)list.isEmpty());
        for (i = count; i < 2 * count; ++i) {
            Assert.assertFalse((boolean)list.remove((Object)i));
        }
    }

    @Test
    public void clear() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("clear");
        int count = 100;
        Assert.assertTrue((boolean)list.isEmpty());
        for (int i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)list.add((Object)i));
        }
        Assert.assertEquals((long)count, (long)list.size());
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void removeAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("removeAll");
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            arrList.add(i);
        }
        Assert.assertTrue((boolean)list.addAll(arrList));
        Assert.assertTrue((boolean)list.removeAll(arrList));
        Assert.assertFalse((boolean)list.removeAll(arrList.subList(0, count / 10)));
    }

    @Test
    public void iterate() {
        HazelcastClient hClient = this.getHazelcastClient();
        IList list = hClient.getList("iterate");
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)2);
        list.add((Object)3);
        Assert.assertEquals((long)4L, (long)list.size());
        HashMap<Integer, Integer> counter = new HashMap<Integer, Integer>();
        counter.put(1, 1);
        counter.put(2, 2);
        counter.put(3, 1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer integer = (Integer)iterator.next();
            counter.put(integer, (Integer)counter.get(integer) - 1);
            iterator.remove();
        }
        Assert.assertEquals((Object)0, counter.get(1));
        Assert.assertEquals((Object)0, counter.get(2));
        Assert.assertEquals((Object)0, counter.get(3));
        Assert.assertTrue((boolean)list.isEmpty());
    }
}

