/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.ILock;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class HazelcastClientLockTest
extends HazelcastClientTestBase {
    @Test(expected=NullPointerException.class)
    public void testLockNull() {
        HazelcastClient hClient = this.getHazelcastClient();
        ILock lock = hClient.getLock(null);
        lock.lock();
    }

    @Test
    public void testLockUnlock() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final ILock lock = hClient.getLock((Object)"testLockUnlock");
        lock.lock();
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch unlockLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)lock.tryLock());
                unlockLatch.countDown();
                lock.lock();
                latch.countDown();
            }
        }).start();
        Assert.assertTrue((boolean)unlockLatch.await(10L, TimeUnit.SECONDS));
        lock.unlock();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testTryLock() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final ILock lock = hClient.getLock((Object)"testTryLock");
        Assert.assertTrue((boolean)lock.tryLock());
        lock.lock();
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch unlockLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)lock.tryLock());
                unlockLatch.countDown();
                try {
                    Assert.assertTrue((boolean)lock.tryLock(10L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                latch.countDown();
            }
        }).start();
        Assert.assertTrue((boolean)unlockLatch.await(10L, TimeUnit.SECONDS));
        lock.unlock();
        lock.unlock();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }
}

