/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.CountDownLatchEntryListener;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Transaction;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.query.EntryObject;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.SqlPredicate;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HazelcastClientMapTest
extends HazelcastClientTestBase {
    static ThreadGroup rootThreadGroup = null;

    @BeforeClass
    public static void before() {
        single.destroy();
        single.init();
    }

    @AfterClass
    public static void after() {
        System.out.println("AfterClass " + runningTestName);
        single.destroy();
    }

    @Test(expected=NullPointerException.class)
    public void testPutNull() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap imap = hClient.getMap("testPutNull");
        imap.put((Object)1, null);
    }

    @Test
    public void testIssue508And513() throws Exception {
        HazelcastClient client = this.getHazelcastClient();
        IMap callEventsMap = client.getMap("CALL_EVENTS");
        IMap metaDataMap = client.getMap("CALL_META_DATA");
        IMap callStartMap = client.getMap("CALL_START_EVENTS");
        MultiMap calls = client.getMultiMap("CALLS");
        calls.lock((Object)"1");
        calls.unlock((Object)"1");
        byte[] bytes = new byte[10];
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        hashSet.add(bytes);
        String callId = "1";
        callEventsMap.put((Object)callId, hashSet);
        callStartMap.put((Object)callId, (Object)bytes);
        metaDataMap.put((Object)callId, (Object)10L);
        Transaction txn = client.getTransaction();
        txn.begin();
        try {
            callEventsMap.remove((Object)callId);
            metaDataMap.remove((Object)callId);
            callStartMap.remove((Object)callId);
            calls.put((Object)callId, (Object)callId);
            txn.commit();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertNull((Object)callEventsMap.get((Object)callId));
        Assert.assertNull((Object)metaDataMap.get((Object)callId));
        Assert.assertNull((Object)callStartMap.get((Object)callId));
        Assert.assertEquals((long)0L, (long)callEventsMap.size());
        Assert.assertEquals((long)0L, (long)metaDataMap.size());
        Assert.assertEquals((long)0L, (long)callStartMap.size());
    }

    @Test
    public void testIssue321() throws Exception {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap imap = hClient.getMap("testIssue321_1");
        final LinkedBlockingQueue events1 = new LinkedBlockingQueue();
        final LinkedBlockingQueue events2 = new LinkedBlockingQueue();
        imap.addEntryListener((EntryListener)new EntryAdapter<Integer, Integer>(){

            public void entryAdded(EntryEvent event) {
                events2.add(event);
            }
        }, false);
        imap.addEntryListener((EntryListener)new EntryAdapter<Integer, Integer>(){

            public void entryAdded(EntryEvent event) {
                events1.add(event);
            }
        }, true);
        imap.put((Object)1, (Object)1);
        EntryEvent event1 = (EntryEvent)events1.poll(10L, TimeUnit.MILLISECONDS);
        EntryEvent event2 = (EntryEvent)events2.poll(10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)event1);
        Assert.assertNotNull((Object)event2);
        Assert.assertNotNull((Object)event1.getValue());
        Assert.assertNull((Object)event2.getValue());
    }

    @Test
    public void testIssue321_2() throws Exception {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap imap = hClient.getMap("testIssue321_2");
        final LinkedBlockingQueue events1 = new LinkedBlockingQueue();
        final LinkedBlockingQueue events2 = new LinkedBlockingQueue();
        imap.addEntryListener((EntryListener)new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                events1.add(event);
            }
        }, true);
        Thread.sleep(50L);
        imap.addEntryListener((EntryListener)new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                events2.add(event);
            }
        }, false);
        imap.put((Object)1, (Object)1);
        EntryEvent event1 = (EntryEvent)events1.poll(10L, TimeUnit.MILLISECONDS);
        EntryEvent event2 = (EntryEvent)events2.poll(10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)event1);
        Assert.assertNotNull((Object)event2);
        Assert.assertNotNull((Object)event1.getValue());
        Assert.assertNull((Object)event2.getValue());
    }

    @Test
    public void testIssue321_3() throws Exception {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap imap = hClient.getMap("testIssue321_3");
        final LinkedBlockingQueue events = new LinkedBlockingQueue();
        EntryAdapter listener = new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                events.add(event);
            }
        };
        imap.addEntryListener((EntryListener)listener, true);
        Thread.sleep(50L);
        imap.addEntryListener((EntryListener)listener, false);
        imap.put((Object)1, (Object)1);
        EntryEvent event1 = (EntryEvent)events.poll(10L, TimeUnit.MILLISECONDS);
        EntryEvent event2 = (EntryEvent)events.poll(10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)event1);
        Assert.assertNotNull((Object)event2);
        Assert.assertNotNull((Object)event1.getValue());
        Assert.assertNull((Object)event2.getValue());
    }

    @Test
    public void getMapName() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("getMapName");
        Assert.assertEquals((Object)"getMapName", (Object)map.getName());
    }

    @Test
    public void testGetAsync() throws Exception {
        HazelcastClient hClient = this.getHazelcastClient();
        String key = "key";
        String value1 = "value1";
        IMap map = hClient.getMap("map:test:getAsync");
        map.put((Object)key, (Object)value1);
        Future f1 = map.getAsync((Object)key);
        Assert.assertEquals((Object)value1, f1.get());
    }

    @Test
    public void lockMapKey() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final IMap map = hClient.getMap("lockMapKey");
        final CountDownLatch latch = new CountDownLatch(1);
        map.put((Object)"a", (Object)"b");
        Thread.sleep(10L);
        map.lock((Object)"a");
        new Thread(new Runnable(){

            public void run() {
                map.lock((Object)"a");
                latch.countDown();
            }
        }).start();
        Thread.sleep(10L);
        Assert.assertEquals((long)1L, (long)latch.getCount());
        map.unlock((Object)"a");
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void lockMap() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final IMap map = hClient.getMap("lockMap");
        final CountDownLatch unlockLatch = new CountDownLatch(1);
        final CountDownLatch latch = new CountDownLatch(1);
        map.put((Object)"a", (Object)"b");
        map.lockMap(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)map.tryPut((Object)"a", (Object)"c", 10L, TimeUnit.MILLISECONDS));
        new Thread(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)map.lockMap(10L, TimeUnit.MILLISECONDS));
                unlockLatch.countDown();
                Assert.assertTrue((boolean)map.lockMap(Long.MAX_VALUE, TimeUnit.SECONDS));
                latch.countDown();
            }
        }).start();
        Assert.assertTrue((boolean)unlockLatch.await(10L, TimeUnit.SECONDS));
        Thread.sleep(2000L);
        map.unlockMap();
        Assert.assertEquals((Object)"c", (Object)map.getMapEntry((Object)"a").getValue());
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void addIndex() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("addIndex");
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            map.put((Object)String.valueOf(i), (Object)new Employee("name" + i, i, true, 0.0));
        }
        EntryObject e = new PredicateBuilder().getEntryObject();
        PredicateBuilder predicate = e.get("age").equal((Object)23);
        long begin = System.currentTimeMillis();
        Set set = map.entrySet((Predicate)predicate);
        long timeWithoutIndex = System.currentTimeMillis() - begin;
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertEquals((long)size, (long)map.size());
        map.destroy();
        map = hClient.getMap("addIndex");
        map.addIndex("age", true);
        for (int i = 0; i < size; ++i) {
            map.put((Object)String.valueOf(i), (Object)new Employee("name" + i, i, true, 0.0));
        }
        begin = System.currentTimeMillis();
        set = map.entrySet((Predicate)predicate);
        long timeWithIndex = System.currentTimeMillis() - begin;
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertEquals((long)size, (long)map.size());
        Assert.assertTrue((timeWithoutIndex > 2L * timeWithIndex ? 1 : 0) != 0);
    }

    @Test
    public void putToTheMap() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap clientMap = hClient.getMap("putToTheMap");
        Assert.assertEquals((long)0L, (long)clientMap.size());
        String result = clientMap.put("1", "CBDEF");
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)"CBDEF", clientMap.get("1"));
        Assert.assertEquals((Object)"CBDEF", clientMap.get("1"));
        Assert.assertEquals((Object)"CBDEF", clientMap.get("1"));
        Assert.assertEquals((long)1L, (long)clientMap.size());
        result = clientMap.put("1", "B");
        Assert.assertEquals((Object)"CBDEF", (Object)result);
        Assert.assertEquals((Object)"B", clientMap.get("1"));
        Assert.assertEquals((Object)"B", clientMap.get("1"));
    }

    @Test
    public void putWithTTL() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("putWithTTL");
        Assert.assertEquals((long)0L, (long)map.size());
        map.put((Object)"1", (Object)"CBDEF", 100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)map.size());
        Thread.sleep(200L);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void tryPut() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("tryPut");
        Assert.assertEquals((long)0L, (long)map.size());
        Boolean result = map.tryPut((Object)"1", (Object)"CBDEF", 1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void putAndGetEmployeeObjects() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        int counter = 1000;
        IMap clientMap = hClient.getMap("putAndGetEmployeeObjects");
        for (i = 0; i < counter; ++i) {
            Employee employee = new Employee("name" + i, i, true, 5000 + i);
            employee.setMiddleName("middle" + i);
            employee.setFamilyName("familiy" + i);
            clientMap.put("" + i, employee);
        }
        for (i = 0; i < counter; ++i) {
            Employee e = (Employee)clientMap.get("" + i);
            Assert.assertEquals((Object)("name" + i), (Object)e.getName());
            Assert.assertEquals((Object)("middle" + i), (Object)e.getMiddleName());
            Assert.assertEquals((Object)("familiy" + i), (Object)e.getFamilyName());
            Assert.assertEquals((long)i, (long)e.getAge());
            Assert.assertEquals((Object)true, (Object)e.isActive());
            Assert.assertEquals((double)(5000 + i), (double)e.getSalary(), (double)0.0);
        }
    }

    @Test
    public void getPuttedValueFromTheMap() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap clientMap = hClient.getMap("getPuttedValueFromTheMap");
        int size = clientMap.size();
        clientMap.put("1", "Z");
        String value = (String)clientMap.get("1");
        Assert.assertEquals((Object)"Z", (Object)value);
        Assert.assertEquals((long)(size + 1), (long)clientMap.size());
    }

    @Test
    public void removeFromMap() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("removeFromMap");
        Assert.assertNull((Object)map.put("a", "b"));
        Assert.assertEquals((Object)"b", map.get("a"));
        Assert.assertEquals((Object)"b", map.remove("a"));
        Assert.assertNull(map.remove("a"));
        Assert.assertNull(map.get("a"));
    }

    @Test
    public void evictFromMap() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("evictFromMap");
        Assert.assertNull((Object)map.put((Object)"a", (Object)"b"));
        Assert.assertEquals((Object)"b", (Object)map.get((Object)"a"));
        Assert.assertTrue((boolean)map.evict((Object)"a"));
        Assert.assertNull((Object)map.get((Object)"a"));
    }

    @Test
    public void getSize() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("getSize");
        Assert.assertEquals((long)0L, (long)map.size());
        map.put((Object)"a", (Object)"b");
        Assert.assertEquals((long)1L, (long)map.size());
        for (i = 0; i < 100; ++i) {
            map.put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
        Assert.assertEquals((long)101L, (long)map.size());
        map.remove((Object)"a");
        Assert.assertEquals((long)100L, (long)map.size());
        for (i = 0; i < 50; ++i) {
            map.remove((Object)String.valueOf(i));
        }
        Assert.assertEquals((long)50L, (long)map.size());
        for (i = 50; i < 100; ++i) {
            map.remove((Object)String.valueOf(i));
        }
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void valuesToArray() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("valuesToArray");
        Assert.assertEquals((long)0L, (long)map.size());
        map.put((Object)"a", (Object)"1");
        map.put((Object)"b", (Object)"2");
        map.put((Object)"c", (Object)"3");
        Assert.assertEquals((long)3L, (long)map.size());
        Object[] values = map.values().toArray();
        Arrays.sort(values);
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "3"}, (Object[])values);
        values = map.values().toArray(new String[3]);
        Arrays.sort(values);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])values);
        values = map.values().toArray(new String[2]);
        Arrays.sort(values);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])values);
        values = map.values().toArray(new String[5]);
        Arrays.sort(values, 0, 3);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3", null, null}, (Object[])values);
    }

    @Test
    public void getMapEntry() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("getMapEntry");
        Assert.assertNull((Object)map.put((Object)"a", (Object)"b"));
        map.get((Object)"a");
        map.get((Object)"a");
        MapEntry entry = map.getMapEntry((Object)"a");
        Assert.assertEquals((Object)"a", (Object)entry.getKey());
        Assert.assertEquals((Object)"b", (Object)entry.getValue());
        Assert.assertEquals((long)2L, (long)entry.getHits());
        Assert.assertEquals((Object)"b", (Object)entry.getValue());
        Assert.assertEquals((Object)"b", (Object)entry.setValue((Object)"c"));
        Assert.assertEquals((Object)"c", (Object)map.get((Object)"a"));
        Assert.assertEquals((Object)"c", (Object)entry.getValue());
    }

    @Test
    public void itertateOverMapKeys() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("itertateOverMapKeys");
        map.put("1", "A");
        map.put("2", "B");
        map.put("3", "C");
        Set keySet = map.keySet();
        Assert.assertEquals((long)3L, (long)keySet.size());
        HashSet<String> s = new HashSet<String>();
        for (String string : keySet) {
            s.add(string);
            Assert.assertTrue((boolean)Arrays.asList("1", "2", "3").contains(string));
        }
        Assert.assertEquals((long)3L, (long)s.size());
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void itertateOverMapEntries() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("itertateOverMapEntries");
        map.put((Object)"1", (Object)"A");
        map.put((Object)"2", (Object)"B");
        map.put((Object)"3", (Object)"C");
        Set entrySet = map.entrySet();
        Assert.assertEquals((long)3L, (long)entrySet.size());
        Set keySet = map.keySet();
        for (Map.Entry entry : entrySet) {
            Assert.assertTrue((boolean)keySet.contains(entry.getKey()));
            Assert.assertEquals(entry.getValue(), (Object)map.get(entry.getKey()));
        }
        Iterator it = entrySet.iterator();
        for (String key : keySet) {
            MapEntry mapEntry = map.getMapEntry((Object)key);
            Assert.assertEquals((long)1L, (long)mapEntry.getHits());
        }
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void tryLock() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final IMap map = hClient.getMap("tryLock");
        final CountDownLatch latch = new CountDownLatch(3);
        map.put((Object)"1", (Object)"A");
        map.lock((Object)"1");
        new Thread(new Runnable(){

            public void run() {
                if (!map.tryLock((Object)"1", 100L, TimeUnit.MILLISECONDS)) {
                    latch.countDown();
                }
                if (!map.tryLock((Object)"1")) {
                    latch.countDown();
                }
                if (map.tryLock((Object)"2")) {
                    latch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void addListener() throws InterruptedException, IOException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("addListener");
        map.clear();
        Assert.assertEquals((long)0L, (long)map.size());
        CountDownLatch entryAddLatch = new CountDownLatch(1);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(1);
        CountDownLatch entryRemovedLatch = new CountDownLatch(1);
        CountDownLatchEntryListener listener = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener, true);
        Assert.assertNull((Object)map.get((Object)"hello"));
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        Assert.assertEquals((Object)"new world", (Object)map.get((Object)"hello"));
        map.remove((Object)"hello");
        Assert.assertTrue((boolean)entryAddLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)entryUpdatedLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)entryRemovedLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void addListenerForKey() throws InterruptedException, IOException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("addListenerForKey");
        map.clear();
        Assert.assertEquals((long)0L, (long)map.size());
        CountDownLatch entryAddLatch = new CountDownLatch(1);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(1);
        CountDownLatch entryRemovedLatch = new CountDownLatch(1);
        CountDownLatchEntryListener listener = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener, (Object)"hello", true);
        Assert.assertNull((Object)map.get((Object)"hello"));
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        Assert.assertEquals((Object)"new world", (Object)map.get((Object)"hello"));
        map.remove((Object)"hello");
        Assert.assertTrue((boolean)entryAddLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)entryUpdatedLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)entryRemovedLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void addListenerAndMultiPut() throws InterruptedException, IOException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("addListenerAndMultiPut");
        map.clear();
        int counter = 100;
        Assert.assertEquals((long)0L, (long)map.size());
        CountDownLatch entryAddLatch = new CountDownLatch(counter);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(counter);
        CountDownLatch entryRemovedLatch = new CountDownLatch(counter);
        CountDownLatchEntryListener listener = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener, true);
        Assert.assertNull((Object)map.get((Object)"hello"));
        HashMap<String, byte[]> many = new HashMap<String, byte[]>();
        for (int i = 0; i < counter; ++i) {
            many.put("" + i, new byte[i]);
        }
        map.putAll(many);
        Assert.assertTrue((boolean)entryAddLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void addTwoListener1ToMapOtherToKey() throws InterruptedException, IOException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("addTwoListener1ToMapOtherToKey");
        CountDownLatch entryAddLatch = new CountDownLatch(5);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(5);
        CountDownLatch entryRemovedLatch = new CountDownLatch(5);
        CountDownLatchEntryListener listener1 = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        CountDownLatchEntryListener listener2 = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener1, true);
        map.addEntryListener(listener2, (Object)"hello", true);
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        Thread.sleep(100L);
        Assert.assertEquals((long)3L, (long)entryAddLatch.getCount());
        Assert.assertEquals((long)3L, (long)entryRemovedLatch.getCount());
        Assert.assertEquals((long)3L, (long)entryUpdatedLatch.getCount());
    }

    @Test
    public void addSameListener1stToKeyThenToMap() throws InterruptedException, IOException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("addSameListener1stToKeyThenToMap");
        CountDownLatch entryAddLatch = new CountDownLatch(5);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(5);
        CountDownLatch entryRemovedLatch = new CountDownLatch(5);
        CountDownLatchEntryListener listener1 = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener1, (Object)"hello", true);
        map.addEntryListener(listener1, true);
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        Thread.sleep(100L);
        Assert.assertEquals((long)3L, (long)entryAddLatch.getCount());
        Assert.assertEquals((long)3L, (long)entryRemovedLatch.getCount());
        Assert.assertEquals((long)3L, (long)entryUpdatedLatch.getCount());
    }

    @Test
    public void removeListener() throws InterruptedException, IOException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("removeListener");
        CountDownLatch entryAddLatch = new CountDownLatch(5);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(5);
        CountDownLatch entryRemovedLatch = new CountDownLatch(5);
        CountDownLatchEntryListener listener1 = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        CountDownLatchEntryListener listener2 = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener1, true);
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        Thread.sleep(100L);
        Assert.assertEquals((long)4L, (long)entryAddLatch.getCount());
        Assert.assertEquals((long)4L, (long)entryRemovedLatch.getCount());
        Assert.assertEquals((long)4L, (long)entryUpdatedLatch.getCount());
        map.removeEntryListener(listener1);
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        Thread.sleep(100L);
        Assert.assertEquals((long)4L, (long)entryAddLatch.getCount());
        Assert.assertEquals((long)4L, (long)entryRemovedLatch.getCount());
        Assert.assertEquals((long)4L, (long)entryUpdatedLatch.getCount());
    }

    @Test
    public void putIfAbsent() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("putIfAbsent");
        String result = (String)map.put((Object)"1", (Object)"CBDEF");
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)map.putIfAbsent((Object)"2", (Object)"C"));
        Assert.assertEquals((Object)"C", (Object)map.putIfAbsent((Object)"2", (Object)"D"));
    }

    @Test
    public void putIfAbsentWithTtl() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("putIfAbsentWithTtl");
        String result = (String)map.put((Object)"1", (Object)"CBDEF");
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)map.putIfAbsent((Object)"2", (Object)"C", 100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"C", (Object)map.putIfAbsent((Object)"2", (Object)"D", 100L, TimeUnit.MILLISECONDS));
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void removeIfSame() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("remove");
        String result = (String)map.put((Object)"1", (Object)"CBDEF");
        Assert.assertNull((Object)result);
        Assert.assertFalse((boolean)map.remove((Object)"1", (Object)"CBD"));
        Assert.assertEquals((Object)"CBDEF", (Object)map.get((Object)"1"));
        Assert.assertTrue((boolean)map.remove((Object)"1", (Object)"CBDEF"));
    }

    @Test
    public void replace() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("replace");
        String result = (String)map.put((Object)"1", (Object)"CBDEF");
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)"CBDEF", (Object)map.replace((Object)"1", (Object)"CBD"));
        Assert.assertNull((Object)map.replace((Object)"2", (Object)"CBD"));
        Assert.assertFalse((boolean)map.replace((Object)"2", (Object)"CBD", (Object)"ABC"));
        Assert.assertTrue((boolean)map.replace((Object)"1", (Object)"CBD", (Object)"XX"));
    }

    @Test
    public void clear() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("clear");
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)map.put((Object)i, (Object)i));
            Assert.assertEquals((Object)i, (Object)map.get((Object)i));
        }
        map.clear();
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)map.get((Object)i));
        }
    }

    @Test
    public void destroyMap() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("destroy");
        for (int i = 0; i < 100; ++i) {
            Assert.assertNull((Object)map.put((Object)i, (Object)i));
            Assert.assertEquals((Object)i, (Object)map.get((Object)i));
        }
        IMap map2 = hClient.getMap("destroy");
        Assert.assertTrue((map == map2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.getId().equals(map2.getId()));
        map.destroy();
        for (int i = 0; i < 100; ++i) {
        }
    }

    @Test
    public void containsKey() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("containsKey");
        int counter = 100;
        for (i = 0; i < counter; ++i) {
            Assert.assertNull((Object)map.put((Object)i, (Object)i));
            Assert.assertEquals((Object)i, (Object)map.get((Object)i));
        }
        for (i = 0; i < counter; ++i) {
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @Test
    public void containsValue() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("containsValue");
        int counter = 100;
        for (i = 0; i < counter; ++i) {
            Assert.assertNull((Object)map.put((Object)i, (Object)i));
            Assert.assertEquals((Object)i, (Object)map.get((Object)i));
        }
        for (i = 0; i < counter; ++i) {
            Assert.assertTrue((boolean)map.containsValue((Object)i));
        }
    }

    @Test
    public void isEmpty() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("isEmpty");
        int counter = 100;
        Assert.assertTrue((boolean)map.isEmpty());
        for (int i = 0; i < counter; ++i) {
            Assert.assertNull((Object)map.put((Object)i, (Object)i));
            Assert.assertEquals((Object)i, (Object)map.get((Object)i));
        }
        Assert.assertFalse((boolean)map.isEmpty());
    }

    @Test
    public void putAll() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("putAll");
        int counter = 100;
        HashMap<Integer, Integer> tempMap = new HashMap<Integer, Integer>();
        for (i = 0; i < counter; ++i) {
            tempMap.put(i, i);
        }
        map.putAll(tempMap);
        for (i = 0; i < counter; ++i) {
            Assert.assertEquals((Object)i, (Object)map.get((Object)i));
        }
    }

    @Test
    public void putAllMany() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("putAllMany");
        int counter = 100;
        int j = 0;
        while (j < 4) {
            HashMap<Integer, Integer> tempMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < counter; ++i) {
                tempMap.put(i, i);
            }
            map.putAll(tempMap);
            Assert.assertEquals((Object)1, (Object)map.get((Object)1));
            ++j;
            counter *= 10;
        }
        map.destroy();
    }

    public static void printThreads() {
        Thread[] threads = HazelcastClientMapTest.getAllThreads();
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            if (t == null) continue;
            System.out.println(t.getName());
        }
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }

    public static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = HazelcastClientMapTest.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return threads;
    }

    @Test
    public void testTwoMembersWithIndexes() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap imap = hClient.getMap("testTwoMembersWithIndexes");
        imap.addIndex("name", false);
        imap.addIndex("age", true);
        imap.addIndex("active", false);
        this.doFunctionalQueryTest(imap);
    }

    @Test
    public void testGetNullMapEntry() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap imap = hClient.getMap("testGetNullMapEntry");
        String key = "key";
        MapEntry mapEntry = imap.getMapEntry((Object)key);
        Assert.assertNull((Object)mapEntry);
    }

    public void doFunctionalQueryTest(IMap imap) {
        Employee c;
        imap.put((Object)"1", (Object)new Employee("joe", 33, false, 14.56));
        imap.put((Object)"2", (Object)new Employee("ali", 23, true, 15.0));
        for (int i = 3; i < 103; ++i) {
            imap.put((Object)String.valueOf(i), (Object)new Employee("name" + i, i % 60, i % 2 == 1, i));
        }
        Set entries = imap.entrySet();
        Assert.assertEquals((long)102L, (long)entries.size());
        int itCount = 0;
        for (Map.Entry entry : entries) {
            Employee c2 = (Employee)entry.getValue();
            ++itCount;
        }
        Assert.assertEquals((long)102L, (long)itCount);
        EntryObject e = new PredicateBuilder().getEntryObject();
        PredicateBuilder predicate = e.is("active").and((Predicate)e.get("age").equal((Object)23));
        entries = imap.entrySet((Predicate)predicate);
        Assert.assertEquals((long)3L, (long)entries.size());
        for (Map.Entry entry : entries) {
            c = (Employee)entry.getValue();
            Assert.assertEquals((long)c.getAge(), (long)23L);
            Assert.assertTrue((boolean)c.isActive());
        }
        imap.remove((Object)"2");
        entries = imap.entrySet((Predicate)predicate);
        Assert.assertEquals((long)2L, (long)entries.size());
        for (Map.Entry entry : entries) {
            c = (Employee)entry.getValue();
            Assert.assertEquals((long)c.getAge(), (long)23L);
            Assert.assertTrue((boolean)c.isActive());
        }
    }

    @Test
    public void testSqlPredicate() {
        HazelcastInstance h = this.getHazelcastInstance();
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("testSqlPredicate");
        for (int i = 0; i < 100; ++i) {
            h.getMap("testSqlPredicate").put((Object)i, (Object)new Employee("" + i, i, i % 2 == 0, i));
        }
        Set set = map.entrySet((Predicate)new SqlPredicate("active AND age < 30"));
        for (Map.Entry entry : set) {
            System.out.println(entry.getValue());
            Assert.assertTrue((((Employee)entry.getValue()).age < 30 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Employee)entry.getValue()).active);
        }
    }

    @AfterClass
    public static void shutdown() {
    }

    public static class Employee
    implements Serializable {
        String name;
        String familyName;
        String middleName;
        int age;
        boolean active;
        double salary;

        public Employee() {
        }

        public Employee(String name, int age, boolean live, double price) {
            this.name = name;
            this.age = age;
            this.active = live;
            this.salary = price;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public double getSalary() {
            return this.salary;
        }

        public boolean isActive() {
            return this.active;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Employee");
            sb.append("{name='").append(this.name).append('\'');
            sb.append(", age=").append(this.age);
            sb.append(", active=").append(this.active);
            sb.append(", salary=").append(this.salary);
            sb.append('}');
            return sb.toString();
        }
    }

    public class Customer
    implements DataSerializable {
        private String name;
        private int age;

        public Customer(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public int getAge() {
            return this.age;
        }

        public void readData(DataInput in) throws IOException {
            this.age = in.readInt();
            int size = in.readInt();
            byte[] bytes = new byte[size];
            in.readFully(bytes);
            this.name = new String(bytes);
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.age);
            byte[] bytes = this.name.getBytes();
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }
}

