/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.client.impl.Values;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class HazelcastClientMultiMapTest
extends HazelcastClientTestBase {
    @Test(expected=NullPointerException.class)
    public void testPutNull() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testPutNull");
        map.put((Object)1, null);
    }

    @Test
    public void putToMultiMap() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("putToMultiMap");
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
    }

    @Test
    public void removeFromMultiMap() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("removeFromMultiMap");
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
        Assert.assertTrue((boolean)multiMap.remove((Object)"a", (Object)1));
    }

    @Test
    public void containsKey() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("containsKey");
        Assert.assertFalse((boolean)multiMap.containsKey((Object)"a"));
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
        Assert.assertTrue((boolean)multiMap.containsKey((Object)"a"));
    }

    @Test
    public void containsValue() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("containsValue");
        Assert.assertFalse((boolean)multiMap.containsValue((Object)1));
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
        Assert.assertTrue((boolean)multiMap.containsValue((Object)1));
    }

    @Test
    public void containsEntry() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("containsEntry");
        Assert.assertFalse((boolean)multiMap.containsEntry((Object)"a", (Object)1));
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
        Assert.assertTrue((boolean)multiMap.containsEntry((Object)"a", (Object)1));
        Assert.assertFalse((boolean)multiMap.containsEntry((Object)"a", (Object)2));
    }

    @Test
    public void size() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("size");
        Assert.assertEquals((long)0L, (long)multiMap.size());
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
        Assert.assertEquals((long)1L, (long)multiMap.size());
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)2));
        Assert.assertEquals((long)2L, (long)multiMap.size());
    }

    @Test
    public void get() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("get");
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)2));
        HashMap<Integer, CountDownLatch> map = new HashMap<Integer, CountDownLatch>();
        map.put(1, new CountDownLatch(1));
        map.put(2, new CountDownLatch(1));
        Collection collection = multiMap.get((Object)"a");
        Assert.assertEquals(Values.class, collection.getClass());
        Assert.assertEquals((long)2L, (long)collection.size());
        for (Integer o : collection) {
            ((CountDownLatch)map.get(o)).countDown();
        }
        Assert.assertTrue((boolean)((CountDownLatch)map.get(1)).await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)((CountDownLatch)map.get(2)).await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void removeKey() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("removeKey");
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)1));
        Assert.assertTrue((boolean)multiMap.put((Object)"a", (Object)2));
        HashMap<Integer, CountDownLatch> map = new HashMap<Integer, CountDownLatch>();
        map.put(1, new CountDownLatch(1));
        map.put(2, new CountDownLatch(1));
        Collection collection = multiMap.remove((Object)"a");
        Assert.assertEquals(Values.class, collection.getClass());
        Assert.assertEquals((long)2L, (long)collection.size());
        for (Object o : collection) {
            ((CountDownLatch)map.get((Integer)o)).countDown();
        }
        Assert.assertTrue((boolean)((CountDownLatch)map.get(1)).await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)((CountDownLatch)map.get(2)).await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void keySet() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("keySet");
        int count = 100;
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j <= i; ++j) {
                multiMap.put((Object)String.valueOf(i), (Object)String.valueOf(j));
            }
        }
        Assert.assertEquals((long)(count * (count + 1) / 2), (long)multiMap.size());
        Set set = multiMap.keySet();
        Assert.assertEquals((long)count, (long)set.size());
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            s.add(String.valueOf(i));
        }
        Assert.assertEquals(s, (Object)set);
    }

    @Test
    public void entrySet() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("entrySet");
        HashMap keyValueListMap = new HashMap();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j <= i; ++j) {
                String key = String.valueOf(i);
                String value = String.valueOf(j);
                multiMap.put((Object)key, (Object)value);
                if (keyValueListMap.get(key) == null) {
                    keyValueListMap.put(key, new ArrayList());
                }
                ((List)keyValueListMap.get(key)).add(value);
            }
        }
        Assert.assertEquals((long)(count * (count + 1) / 2), (long)multiMap.size());
        Set set = multiMap.entrySet();
        Assert.assertEquals((long)(count * (count + 1) / 2), (long)set.size());
        for (Map.Entry o : set) {
            Assert.assertTrue((Integer.valueOf((String)o.getValue()) < count ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((List)keyValueListMap.get(o.getKey())).contains(o.getValue()));
        }
    }

    @Test
    public void values() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap multiMap = hClient.getMultiMap("entrySet");
        HashMap valueKeyListMap = new HashMap();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j <= i; ++j) {
                String key = String.valueOf(i);
                String value = String.valueOf(j);
                multiMap.put((Object)key, (Object)value);
                if (valueKeyListMap.get(value) == null) {
                    valueKeyListMap.put(value, new ArrayList());
                }
                ((List)valueKeyListMap.get(value)).add(key);
            }
        }
        Assert.assertEquals((long)(count * (count + 1) / 2), (long)multiMap.size());
        Collection collection = multiMap.values();
        Assert.assertEquals((long)(count * (count + 1) / 2), (long)collection.size());
        Iterator iterator = collection.iterator();
        System.out.println(iterator.getClass());
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            Assert.assertNotNull(((List)valueKeyListMap.get(value)).remove(0));
            if (((List)valueKeyListMap.get(value)).size() != 0) continue;
            valueKeyListMap.remove(value);
        }
        Assert.assertTrue((boolean)valueKeyListMap.isEmpty());
    }

    @Test
    public void testMultiMapPutAndGet() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapPutAndGet");
        map.put((Object)"Hello", (Object)"World");
        Collection values = map.get((Object)"Hello");
        Assert.assertEquals((Object)"World", values.iterator().next());
        map.put((Object)"Hello", (Object)"Europe");
        map.put((Object)"Hello", (Object)"America");
        map.put((Object)"Hello", (Object)"Asia");
        map.put((Object)"Hello", (Object)"Africa");
        map.put((Object)"Hello", (Object)"Antarctica");
        map.put((Object)"Hello", (Object)"Australia");
        values = map.get((Object)"Hello");
        Assert.assertEquals((long)7L, (long)values.size());
        Assert.assertTrue((boolean)map.containsKey((Object)"Hello"));
        Assert.assertFalse((boolean)map.containsKey((Object)"Hi"));
    }

    @Test
    public void testMultiMapGetNameAndType() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapGetNameAndType");
        Assert.assertEquals((Object)"testMultiMapGetNameAndType", (Object)map.getName());
        Instance.InstanceType type = map.getInstanceType();
        Assert.assertEquals((Object)Instance.InstanceType.MULTIMAP, (Object)type);
    }

    @Test
    public void testMultiMapClear() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapClear");
        map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals((long)1L, (long)map.size());
        map.clear();
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testMultiMapContainsKey() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapContainsKey");
        map.put((Object)"Hello", (Object)"World");
        Assert.assertTrue((boolean)map.containsKey((Object)"Hello"));
    }

    @Test
    public void testMultiMapContainsValue() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapContainsValue");
        map.put((Object)"Hello", (Object)"World");
        Assert.assertTrue((boolean)map.containsValue((Object)"World"));
    }

    @Test
    public void testMultiMapContainsEntry() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapContainsEntry");
        map.put((Object)"Hello", (Object)"World");
        Assert.assertTrue((boolean)map.containsEntry((Object)"Hello", (Object)"World"));
    }

    @Test
    public void testMultiMapKeySet() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapKeySet");
        map.put((Object)"Hello", (Object)"World");
        map.put((Object)"Hello", (Object)"Europe");
        map.put((Object)"Hello", (Object)"America");
        map.put((Object)"Hello", (Object)"Asia");
        map.put((Object)"Hello", (Object)"Africa");
        map.put((Object)"Hello", (Object)"Antarctica");
        map.put((Object)"Hello", (Object)"Australia");
        Set keys = map.keySet();
        Assert.assertEquals((long)1L, (long)keys.size());
    }

    @Test
    public void testMultiMapValues() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapValues");
        map.put((Object)"Hello", (Object)"World");
        map.put((Object)"Hello", (Object)"Europe");
        map.put((Object)"Hello", (Object)"America");
        map.put((Object)"Hello", (Object)"Asia");
        map.put((Object)"Hello", (Object)"Africa");
        map.put((Object)"Hello", (Object)"Antarctica");
        map.put((Object)"Hello", (Object)"Australia");
        Collection values = map.values();
        Assert.assertEquals((long)7L, (long)values.size());
    }

    @Test
    public void testMultiMapRemove() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapRemove");
        map.put((Object)"Hello", (Object)"World");
        map.put((Object)"Hello", (Object)"Europe");
        map.put((Object)"Hello", (Object)"America");
        map.put((Object)"Hello", (Object)"Asia");
        map.put((Object)"Hello", (Object)"Africa");
        map.put((Object)"Hello", (Object)"Antarctica");
        map.put((Object)"Hello", (Object)"Australia");
        Assert.assertEquals((long)7L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.keySet().size());
        Collection values = map.remove((Object)"Hello");
        Assert.assertEquals((long)7L, (long)values.size());
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertEquals((long)0L, (long)map.keySet().size());
        map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.keySet().size());
    }

    @Test
    public void testMultiMapRemoveEntries() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapRemoveEntries");
        map.put((Object)"Hello", (Object)"World");
        map.put((Object)"Hello", (Object)"Europe");
        map.put((Object)"Hello", (Object)"America");
        map.put((Object)"Hello", (Object)"Asia");
        map.put((Object)"Hello", (Object)"Africa");
        map.put((Object)"Hello", (Object)"Antartica");
        map.put((Object)"Hello", (Object)"Australia");
        boolean removed = map.remove((Object)"Hello", (Object)"World");
        Assert.assertTrue((boolean)removed);
        Assert.assertEquals((long)6L, (long)map.size());
    }

    @Test
    public void testMultiMapEntrySet() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapEntrySet");
        map.put((Object)"Hello", (Object)"World");
        map.put((Object)"Hello", (Object)"Europe");
        map.put((Object)"Hello", (Object)"America");
        map.put((Object)"Hello", (Object)"Asia");
        map.put((Object)"Hello", (Object)"Africa");
        map.put((Object)"Hello", (Object)"Antarctica");
        map.put((Object)"Hello", (Object)"Australia");
        Set entries = map.entrySet();
        Assert.assertEquals((long)7L, (long)entries.size());
        int itCount = 0;
        for (Map.Entry entry : entries) {
            Assert.assertEquals((Object)"Hello", entry.getKey());
            ++itCount;
        }
        Assert.assertEquals((long)7L, (long)itCount);
    }

    @Test
    public void testMultiMapValueCount() {
        HazelcastClient hClient = this.getHazelcastClient();
        MultiMap map = hClient.getMultiMap("testMultiMapValueCount");
        map.put((Object)1, (Object)"World");
        map.put((Object)2, (Object)"Africa");
        map.put((Object)1, (Object)"America");
        map.put((Object)2, (Object)"Antarctica");
        map.put((Object)1, (Object)"Asia");
        map.put((Object)1, (Object)"Europe");
        map.put((Object)2, (Object)"Australia");
        Assert.assertEquals((long)4L, (long)map.valueCount((Object)1));
        Assert.assertEquals((long)3L, (long)map.valueCount((Object)2));
    }

    @Test
    @Ignore
    public void testLotsOfRemove() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final MultiMap map = hClient.getMultiMap("testLotsOfRemove");
        map.put((Object)1, (Object)"adam");
        final AtomicBoolean running = new AtomicBoolean(true);
        final AtomicInteger p = new AtomicInteger(0);
        final AtomicInteger r = new AtomicInteger(0);
        Thread.sleep(1000L);
        new Thread(new Runnable(){

            public void run() {
                while (running.get()) {
                    map.put((Object)1, (Object)("" + Math.random()));
                    p.incrementAndGet();
                }
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                while (running.get()) {
                    map.remove((Object)1);
                    r.incrementAndGet();
                }
            }
        }).start();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                int ip = p.get();
                int ir = r.get();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (p.get() == ip || r.get() == ir) {
                    System.out.println("STUCK p= " + p.get() + "::: r" + r.get());
                } else {
                    latch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        running.set(false);
    }
}

