/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class HazelcastClientQueueTest
extends HazelcastClientTestBase {
    @Test(expected=NullPointerException.class)
    public void testPutNull() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("testPutNull");
        queue.put(null);
    }

    @Test
    public void testQueueName() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("testQueueName");
        Assert.assertEquals((Object)"testQueueName", (Object)queue.getName());
    }

    @Test
    public void testQueueOffer() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("testQueueOffer");
        junit.framework.Assert.assertTrue((boolean)queue.offer((Object)"a"));
        junit.framework.Assert.assertTrue((boolean)queue.offer((Object)"b", 10L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"a", (Object)queue.poll());
        Assert.assertEquals((Object)"b", (Object)queue.poll());
    }

    @Test
    public void testQueuePoll() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final CountDownLatch cl = new CountDownLatch(1);
        final IQueue queue = hClient.getQueue("testQueuePoll");
        junit.framework.Assert.assertTrue((boolean)queue.offer((Object)"a"));
        Assert.assertEquals((Object)"a", (Object)queue.poll());
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(100L);
                    Assert.assertEquals((Object)"b", (Object)queue.poll(100L, TimeUnit.MILLISECONDS));
                    cl.countDown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        Thread.sleep(50L);
        junit.framework.Assert.assertTrue((boolean)queue.offer((Object)"b"));
        junit.framework.Assert.assertTrue((boolean)cl.await(200L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testQueueRemove() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("testQueueRemove");
        junit.framework.Assert.assertTrue((boolean)queue.offer((Object)"a"));
        Assert.assertEquals((Object)"a", (Object)queue.remove());
    }

    @Test
    public void testQueuePeek() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("testQueuePeek");
        junit.framework.Assert.assertTrue((boolean)queue.offer((Object)"a"));
        Assert.assertEquals((Object)"a", (Object)queue.peek());
    }

    @Test
    public void element() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("element");
        junit.framework.Assert.assertTrue((boolean)queue.offer((Object)"a"));
        Assert.assertEquals((Object)"a", (Object)queue.element());
    }

    @Test
    public void addAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("addAll");
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        junit.framework.Assert.assertTrue((boolean)queue.addAll(list));
        Assert.assertEquals((Object)"a", (Object)queue.poll());
        Assert.assertEquals((Object)"b", (Object)queue.poll());
    }

    @Test
    public void clear() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("clear");
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        junit.framework.Assert.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((boolean)queue.addAll(list));
        junit.framework.Assert.assertTrue((queue.size() == 2 ? 1 : 0) != 0);
        queue.clear();
        junit.framework.Assert.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void containsAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("containsAll");
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        junit.framework.Assert.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((boolean)queue.addAll(list));
        junit.framework.Assert.assertTrue((queue.size() == 2 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((boolean)queue.containsAll(list));
    }

    @Test
    public void isEmpty() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("isEmpty");
        junit.framework.Assert.assertTrue((boolean)queue.isEmpty());
        queue.offer((Object)"asd");
        Assert.assertFalse((boolean)queue.isEmpty());
    }

    @Test
    public void iterator() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("iterator");
        junit.framework.Assert.assertTrue((boolean)queue.isEmpty());
        int count = 100;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < count; ++i) {
            queue.offer((Object)("" + i));
            map.put(i, 1);
        }
        for (String o : queue) {
            map.put(Integer.valueOf(o), (Integer)map.get(Integer.valueOf(o)) - 1);
        }
        for (int i = 0; i < count; ++i) {
            junit.framework.Assert.assertTrue(((Integer)map.get(i) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void removeAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("removeAll");
        junit.framework.Assert.assertTrue((boolean)queue.isEmpty());
        int count = 100;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < count; ++i) {
            queue.offer((Object)("" + i));
            map.put(i, 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count / 2; ++i) {
            list.add(String.valueOf(i));
        }
        queue.removeAll(list);
        junit.framework.Assert.assertTrue((queue.size() == count / 2 ? 1 : 0) != 0);
    }

    @Test
    public void testIterator() {
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("testIterator");
        junit.framework.Assert.assertTrue((boolean)queue.isEmpty());
        int count = 100;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < count; ++i) {
            queue.offer((Object)("" + i));
            map.put(i, 1);
        }
        Iterator it = queue.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            map.remove(Integer.valueOf(item));
            it.remove();
        }
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testQueueItemListener() {
        final CountDownLatch latch = new CountDownLatch(2);
        HazelcastClient hClient = this.getHazelcastClient();
        IQueue queue = hClient.getQueue("testQueueListener");
        queue.addItemListener((ItemListener)new ItemListener<String>(){

            public void itemAdded(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }

            public void itemRemoved(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }
        }, true);
        queue.offer((Object)"hello");
        Assert.assertEquals((Object)"hello", (Object)queue.poll());
        try {
            junit.framework.Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
    }

    @AfterClass
    public static void shutdown() {
    }
}

