/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.CountDownItemListener;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.ISet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class HazelcastClientSetTest
extends HazelcastClientTestBase {
    @Test(expected=NullPointerException.class)
    public void testAddNull() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("testAddNull");
        set.add(null);
    }

    @Test
    public void getSetName() {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("getSetName");
        Assert.assertEquals((Object)"getSetName", (Object)set.getName());
    }

    @Test
    public void addRemoveItemListener() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("addRemoveItemListenerSet");
        CountDownLatch addLatch = new CountDownLatch(2);
        CountDownLatch removeLatch = new CountDownLatch(2);
        CountDownItemListener listener = new CountDownItemListener(addLatch, removeLatch);
        set.addItemListener(listener, true);
        set.add((Object)"hello");
        set.add((Object)"hello");
        set.remove((Object)"hello");
        set.remove((Object)"hello");
        while (removeLatch.getCount() != 1L) {
            Thread.sleep(50L);
        }
        set.removeItemListener(listener);
        set.add((Object)"hello");
        set.add((Object)"hello");
        set.remove((Object)"hello");
        set.remove((Object)"hello");
        Thread.sleep(50L);
        Assert.assertEquals((long)1L, (long)addLatch.getCount());
        Assert.assertEquals((long)1L, (long)removeLatch.getCount());
    }

    @Test
    @Ignore
    public void TenTimesAddRemoveItemListener() throws InterruptedException {
        ExecutorService ex = Executors.newFixedThreadPool(1);
        int count = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        ex.execute(new Runnable(){

            public void run() {
                for (int i = 0; i < 10; ++i) {
                    try {
                        System.out.println("i: " + i);
                        HazelcastClientSetTest.this.addRemoveItemListener();
                        latch.countDown();
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
    }

    @Test
    public void destroy() {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("destroy");
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)set.add((Object)i));
        }
        ISet set2 = hClient.getSet("destroy");
        Assert.assertTrue((set == set2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)set.getId().equals(set2.getId()));
        set.destroy();
        set2 = hClient.getSet("destroy");
        Assert.assertFalse((set == set2 ? 1 : 0) != 0);
    }

    @Test
    public void add() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("add");
        int count = 100;
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)set.add((Object)i));
        }
        for (i = 0; i < count; ++i) {
            Assert.assertFalse((boolean)set.add((Object)i));
        }
        Assert.assertEquals((long)count, (long)set.size());
    }

    @Test
    public void contains() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("contains");
        int count = 100;
        for (i = 0; i < count; ++i) {
            set.add((Object)i);
        }
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)set.contains((Object)i));
        }
        for (i = count; i < 2 * count; ++i) {
            Assert.assertFalse((boolean)set.contains((Object)i));
        }
    }

    @Test
    public void addAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("addAll");
        ArrayList<Integer> arr = new ArrayList<Integer>();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            arr.add(i);
        }
        Assert.assertTrue((boolean)set.addAll(arr));
    }

    @Test
    public void containsAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("containsAll");
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            arrList.add(i);
        }
        Assert.assertTrue((boolean)set.addAll(arrList));
        Assert.assertTrue((boolean)set.containsAll(arrList));
        arrList.set(count / 2, count + 1);
        Assert.assertFalse((boolean)set.containsAll(arrList));
    }

    @Test
    public void size() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("size");
        int count = 100;
        Assert.assertTrue((boolean)set.isEmpty());
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)set.add((Object)i));
        }
        Assert.assertEquals((long)count, (long)set.size());
        for (i = 0; i < count / 2; ++i) {
            Assert.assertFalse((boolean)set.add((Object)i));
        }
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertEquals((long)count, (long)set.size());
    }

    @Test
    public void remove() {
        int i;
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("remove");
        int count = 100;
        Assert.assertTrue((boolean)set.isEmpty());
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)set.add((Object)i));
        }
        Assert.assertEquals((long)count, (long)set.size());
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)set.remove((Object)i));
        }
        Assert.assertTrue((boolean)set.isEmpty());
        for (i = count; i < 2 * count; ++i) {
            Assert.assertFalse((boolean)set.remove((Object)i));
        }
    }

    @Test
    public void clear() {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("clear");
        int count = 100;
        Assert.assertTrue((boolean)set.isEmpty());
        for (int i = 0; i < count; ++i) {
            Assert.assertTrue((boolean)set.add((Object)i));
        }
        Assert.assertEquals((long)count, (long)set.size());
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void removeAll() {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("removeAll");
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            arrList.add(i);
        }
        Assert.assertTrue((boolean)set.addAll(arrList));
        Assert.assertTrue((boolean)set.removeAll(arrList));
        Assert.assertFalse((boolean)set.removeAll(arrList.subList(0, count / 10)));
    }

    @Test
    public void iterate() {
        HazelcastClient hClient = this.getHazelcastClient();
        ISet set = hClient.getSet("iterate");
        set.add((Object)1);
        set.add((Object)2);
        set.add((Object)2);
        set.add((Object)3);
        Assert.assertEquals((long)3L, (long)set.size());
        HashMap<Integer, Integer> counter = new HashMap<Integer, Integer>();
        counter.put(1, 1);
        counter.put(2, 1);
        counter.put(3, 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer integer = (Integer)iterator.next();
            counter.put(integer, (Integer)counter.get(integer) - 1);
            iterator.remove();
        }
        Assert.assertEquals((Object)0, counter.get(1));
        Assert.assertEquals((Object)0, counter.get(2));
        Assert.assertEquals((Object)0, counter.get(3));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @AfterClass
    public static void shutdown() {
    }
}

