/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.client.IOUtil;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Member;
import com.hazelcast.core.MessageListener;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class HazelcastClientTest
extends HazelcastClientTestBase {
    @BeforeClass
    public static void before() {
        single.destroy();
        single.init();
    }

    @AfterClass
    public static void after() {
        System.out.println("AfterClass " + runningTestName);
        single.destroy();
    }

    @Test
    public void testGetClusterMemberSize() {
        Cluster cluster = this.getHazelcastClient().getCluster();
        Set members = cluster.getMembers();
        Assert.assertEquals((long)1L, (long)members.size());
    }

    @Test
    public void iterateOverMembers() {
        Cluster cluster = this.getHazelcastClient().getCluster();
        Set members = cluster.getMembers();
        for (Member member : members) {
            Assert.assertNotNull((Object)member);
        }
    }

    @Test
    public void addInstanceListener() throws InterruptedException {
        final CountDownLatch destroyedLatch = new CountDownLatch(1);
        final CountDownLatch createdLatch = new CountDownLatch(1);
        final IMap instance = this.getHazelcastClient().getMap("addInstanceListener");
        InstanceListener listener = new InstanceListener(){

            public void instanceDestroyed(InstanceEvent event) {
                Assert.assertEquals((Object)InstanceEvent.InstanceEventType.DESTROYED, (Object)event.getEventType());
                Assert.assertEquals((Object)instance, (Object)event.getInstance());
                destroyedLatch.countDown();
            }

            public void instanceCreated(InstanceEvent event) {
                Assert.assertEquals((Object)InstanceEvent.InstanceEventType.CREATED, (Object)event.getEventType());
                IMap map = (IMap)event.getInstance();
                Assert.assertEquals((Object)instance.getName(), (Object)map.getName());
                createdLatch.countDown();
            }
        };
        this.getHazelcastClient().addInstanceListener(listener);
        instance.put((Object)1, (Object)1);
        Assert.assertEquals((long)1L, (long)instance.size());
        Assert.assertTrue((boolean)createdLatch.await(10L, TimeUnit.SECONDS));
        instance.destroy();
        Assert.assertTrue((boolean)destroyedLatch.await(10L, TimeUnit.SECONDS));
        this.getHazelcastClient().removeInstanceListener(listener);
    }

    @Test
    public void testGetClusterTime() {
        Cluster cluster = this.getHazelcastClient().getCluster();
        long clusterTime = cluster.getClusterTime();
        Assert.assertTrue((clusterTime > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testProxySerialization() {
        IMap mapProxy = this.getHazelcastClient().getMap("proxySerialization");
        ILock mapLock = this.getHazelcastClient().getLock((Object)mapProxy);
        Assert.assertNotNull((Object)mapLock);
    }

    @Test
    public void testMapGetName() {
        IMap map = this.getHazelcastClient().getMap("testMapGetName");
        Assert.assertEquals((Object)"testMapGetName", (Object)map.getName());
    }

    @Test
    public void testMapValuesSize() {
        IMap map = this.getHazelcastClient().getMap("testMapValuesSize");
        map.put("Hello", "World");
        Assert.assertEquals((long)1L, (long)map.values().size());
    }

    @Test
    public void testMapPutAndGet() {
        IMap map = this.getHazelcastClient().getMap("testMapPutAndGet");
        String value = (String)map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals((Object)"World", (Object)map.get((Object)"Hello"));
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertNull((Object)value);
        value = (String)map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals((Object)"World", (Object)map.get((Object)"Hello"));
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"World", (Object)value);
        value = (String)map.put((Object)"Hello", (Object)"New World");
        Assert.assertEquals((Object)"New World", (Object)map.get((Object)"Hello"));
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"World", (Object)value);
    }

    @Test
    public void testPutDate() {
        IMap map = this.getHazelcastClient().getMap("putDate");
        Date date = new Date();
        map.put("key", date);
        Date d = (Date)map.get("key");
        Assert.assertEquals((long)date.getTime(), (long)d.getTime());
    }

    @Test
    public void testPutBigInteger() {
        IMap map = this.getHazelcastClient().getMap("putBigInteger");
        BigInteger number = new BigInteger("12312312312");
        map.put("key", number);
        BigInteger b = (BigInteger)map.get("key");
        Assert.assertEquals((Object)number, (Object)b);
    }

    @Test
    public void testMapReplaceIfSame() {
        IMap map = this.getHazelcastClient().getMap("testMapReplaceIfSame");
        junit.framework.Assert.assertFalse((boolean)map.replace((Object)"Hello", (Object)"Java", (Object)"World"));
        String value = (String)map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals((Object)"World", (Object)map.get((Object)"Hello"));
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertNull((Object)value);
        junit.framework.Assert.assertFalse((boolean)map.replace((Object)"Hello", (Object)"Java", (Object)"NewWorld"));
        Assert.assertTrue((boolean)map.replace((Object)"Hello", (Object)"World", (Object)"NewWorld"));
        Assert.assertEquals((Object)"NewWorld", (Object)map.get((Object)"Hello"));
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testMapContainsKey() {
        IMap map = this.getHazelcastClient().getMap("testMapContainsKey");
        map.put((Object)"Hello", (Object)"World");
        Assert.assertTrue((boolean)map.containsKey((Object)"Hello"));
    }

    @Test
    public void testMapContainsValue() {
        IMap map = this.getHazelcastClient().getMap("testMapContainsValue");
        map.put((Object)"Hello", (Object)"World");
        Assert.assertTrue((boolean)map.containsValue((Object)"World"));
    }

    @Test
    public void testMapClear() {
        IMap map = this.getHazelcastClient().getMap("testMapClear");
        String value = (String)map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals(null, (Object)value);
        map.clear();
        Assert.assertEquals((long)0L, (long)map.size());
        value = (String)map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals(null, (Object)value);
        Assert.assertEquals((Object)"World", (Object)map.get((Object)"Hello"));
        Assert.assertEquals((long)1L, (long)map.size());
        map.remove((Object)"Hello");
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testMapRemove() {
        IMap map = this.getHazelcastClient().getMap("testMapRemove");
        map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.keySet().size());
        map.remove((Object)"Hello");
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertEquals((long)0L, (long)map.keySet().size());
        map.put((Object)"Hello", (Object)"World");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.keySet().size());
    }

    @Test
    public void testMapPutAll() {
        IMap map = this.getHazelcastClient().getMap("testMapPutAll");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("Hello", "World");
        m.put("hazel", "cast");
        map.putAll(m);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey((Object)"Hello"));
        Assert.assertTrue((boolean)map.containsKey((Object)"hazel"));
    }

    @Test
    public void testMapEntrySet() {
        IMap map = this.getHazelcastClient().getMap("testMapEntrySet");
        map.put((Object)"Hello", (Object)"World");
        Set set = map.entrySet();
        for (Map.Entry e : set) {
            Assert.assertEquals((Object)"Hello", e.getKey());
            Assert.assertEquals((Object)"World", e.getValue());
        }
    }

    @Test
    public void testMapEntrySetWhenRemoved() {
        IMap map = this.getHazelcastClient().getMap("testMapEntrySetWhenRemoved");
        map.put((Object)"Hello", (Object)"World");
        Set set = map.entrySet();
        map.remove((Object)"Hello");
        for (Map.Entry e : set) {
            Assert.assertTrue((boolean)((String)e.getValue()).equals("World"));
        }
    }

    @Test
    public void testMapEntryListener() {
        IMap map = this.getHazelcastClient().getMap("testMapEntrySet");
        final CountDownLatch latchAdded = new CountDownLatch(1);
        final CountDownLatch latchRemoved = new CountDownLatch(1);
        final CountDownLatch latchUpdated = new CountDownLatch(1);
        map.addEntryListener((EntryListener)new EntryListener<String, String>(){

            public void entryAdded(EntryEvent<String, String> event) {
                Assert.assertEquals((Object)"world", (Object)event.getValue());
                Assert.assertEquals((Object)"hello", (Object)event.getKey());
                latchAdded.countDown();
            }

            public void entryRemoved(EntryEvent<String, String> event) {
                Assert.assertEquals((Object)"hello", (Object)event.getKey());
                Assert.assertEquals((Object)"new world", (Object)event.getValue());
                latchRemoved.countDown();
            }

            public void entryUpdated(EntryEvent<String, String> event) {
                Assert.assertEquals((Object)"world", (Object)event.getOldValue());
                Assert.assertEquals((Object)"new world", (Object)event.getValue());
                Assert.assertEquals((Object)"hello", (Object)event.getKey());
                latchUpdated.countDown();
            }

            public void entryEvicted(EntryEvent<String, String> event) {
                this.entryRemoved(event);
            }
        }, true);
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        try {
            Assert.assertTrue((boolean)latchAdded.await(5L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)latchUpdated.await(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)latchRemoved.await(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            junit.framework.Assert.assertFalse((String)e.getMessage(), (boolean)true);
        }
    }

    @Test
    public void testMapEvict() {
        IMap map = this.getHazelcastClient().getMap("testMapEviction");
        map.put((Object)"currentIteratedKey", (Object)"currentIteratedValue");
        Assert.assertEquals((Object)true, (Object)map.containsKey((Object)"currentIteratedKey"));
        map.evict((Object)"currentIteratedKey");
        Assert.assertEquals((Object)false, (Object)map.containsKey((Object)"currentIteratedKey"));
    }

    @Test
    public void testListAdd() {
        IList list = this.getHazelcastClient().getList("testListAdd");
        list.add((Object)"Hello World");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Hello World", list.iterator().next());
    }

    @Test
    public void testListContains() {
        IList list = this.getHazelcastClient().getList("testListContains");
        list.add((Object)"Hello World");
        Assert.assertTrue((boolean)list.contains((Object)"Hello World"));
    }

    @Test
    public void testListGet() {
    }

    @Test
    public void testListIterator() {
        IList list = this.getHazelcastClient().getList("testListIterator");
        list.add((Object)"Hello World");
        Assert.assertEquals((Object)"Hello World", list.iterator().next());
    }

    @Test
    public void testListListIterator() {
    }

    @Test
    public void testListIndexOf() {
    }

    @Test
    public void testListIsEmpty() {
        IList list = this.getHazelcastClient().getList("testListIsEmpty");
        Assert.assertTrue((boolean)list.isEmpty());
        list.add((Object)"Hello World");
        junit.framework.Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    @Ignore
    public void testListItemListener() {
        final CountDownLatch latch = new CountDownLatch(2);
        IList list = this.getHazelcastClient().getList("testListListener");
        list.addItemListener((ItemListener)new ItemListener<String>(){

            public void itemAdded(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }

            public void itemRemoved(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }
        }, true);
        list.add((Object)"hello");
        list.remove((Object)"hello");
        try {
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void testSetItemListener() {
        final CountDownLatch latch = new CountDownLatch(2);
        ISet set = this.getHazelcastClient().getSet("testSetListener");
        set.addItemListener((ItemListener)new ItemListener<String>(){

            public void itemAdded(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }

            public void itemRemoved(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }
        }, true);
        set.add((Object)"hello");
        set.remove((Object)"hello");
        try {
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testQueueItemListener() {
        final CountDownLatch latch = new CountDownLatch(2);
        IQueue queue = this.getHazelcastClient().getQueue("testQueueListener");
        queue.addItemListener((ItemListener)new ItemListener<String>(){

            public void itemAdded(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }

            public void itemRemoved(String item) {
                Assert.assertEquals((Object)"hello", (Object)item);
                latch.countDown();
            }
        }, true);
        queue.offer((Object)"hello");
        Assert.assertEquals((Object)"hello", (Object)queue.poll());
        try {
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAdd() {
        ISet set = this.getHazelcastClient().getSet("testSetAdd");
        boolean added = set.add((Object)"HelloWorld");
        Assert.assertEquals((Object)true, (Object)added);
        added = set.add((Object)"HelloWorld");
        junit.framework.Assert.assertFalse((boolean)added);
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testSetIterator() {
        ISet set = this.getHazelcastClient().getSet("testSetIterator");
        boolean added = set.add((Object)"HelloWorld");
        Assert.assertTrue((boolean)added);
        Assert.assertEquals((Object)"HelloWorld", set.iterator().next());
    }

    @Test
    public void testSetContains() {
        ISet set = this.getHazelcastClient().getSet("testSetContains");
        boolean added = set.add((Object)"HelloWorld");
        Assert.assertTrue((boolean)added);
        boolean contains = set.contains((Object)"HelloWorld");
        Assert.assertTrue((boolean)contains);
    }

    @Test
    public void testSetClear() {
        ISet set = this.getHazelcastClient().getSet("testSetClear");
        boolean added = set.add((Object)"HelloWorld");
        Assert.assertTrue((boolean)added);
        set.clear();
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void testSetRemove() {
        ISet set = this.getHazelcastClient().getSet("testSetRemove");
        boolean added = set.add((Object)"HelloWorld");
        Assert.assertTrue((boolean)added);
        set.remove((Object)"HelloWorld");
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertTrue((boolean)set.add((Object)"HelloWorld"));
        junit.framework.Assert.assertFalse((boolean)set.add((Object)"HelloWorld"));
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testSetGetName() {
        ISet set = this.getHazelcastClient().getSet("testSetGetName");
        Assert.assertEquals((Object)"testSetGetName", (Object)set.getName());
    }

    @Test
    public void testSetAddAll() {
        ISet set = this.getHazelcastClient().getSet("testSetAddAll");
        String[] items = new String[]{"one", "two", "three", "four"};
        set.addAll(Arrays.asList(items));
        Assert.assertEquals((long)4L, (long)set.size());
        items = new String[]{"four", "five"};
        set.addAll(Arrays.asList(items));
        Assert.assertEquals((long)5L, (long)set.size());
    }

    @Test
    public void testTopicGetName() {
        ITopic topic = this.getHazelcastClient().getTopic("testTopicGetName");
        Assert.assertEquals((Object)"testTopicGetName", (Object)topic.getName());
    }

    @Test
    public void testTopicPublish() {
        ITopic topic = this.getHazelcastClient().getTopic("testTopicPublish");
        final CountDownLatch latch = new CountDownLatch(1);
        topic.addMessageListener((MessageListener)new MessageListener<String>(){

            public void onMessage(String msg) {
                Assert.assertEquals((Object)"Hello World", (Object)msg);
                latch.countDown();
            }
        });
        topic.publish((Object)"Hello World");
        try {
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testQueueAdd() {
        IQueue queue = this.getHazelcastClient().getQueue("testQueueAdd");
        queue.add((Object)"Hello World");
        Assert.assertEquals((long)1L, (long)queue.size());
    }

    @Test
    public void testQueueAddAll() {
        IQueue queue = this.getHazelcastClient().getQueue("testQueueAddAll");
        String[] items = new String[]{"one", "two", "three", "four"};
        queue.addAll(Arrays.asList(items));
        Assert.assertEquals((long)4L, (long)queue.size());
        queue.addAll(Arrays.asList(items));
        Assert.assertEquals((long)8L, (long)queue.size());
    }

    @Test
    public void testQueueContains() {
        IQueue queue = this.getHazelcastClient().getQueue("testQueueContains");
        String[] items = new String[]{"one", "two", "three", "four"};
        queue.addAll(Arrays.asList(items));
        Assert.assertTrue((boolean)queue.contains((Object)"one"));
        Assert.assertTrue((boolean)queue.contains((Object)"two"));
        Assert.assertTrue((boolean)queue.contains((Object)"three"));
        Assert.assertTrue((boolean)queue.contains((Object)"four"));
    }

    @Test
    public void testQueueContainsAll() {
        IQueue queue = this.getHazelcastClient().getQueue("testQueueContainsAll");
        String[] items = new String[]{"one", "two", "three", "four"};
        List<String> list = Arrays.asList(items);
        queue.addAll(list);
        Assert.assertTrue((boolean)queue.containsAll(list));
    }

    @Test
    public void testIdGenerator() {
        IdGenerator id = this.getHazelcastClient().getIdGenerator("testIdGenerator");
        Assert.assertEquals((long)1L, (long)id.newId());
        Assert.assertEquals((long)2L, (long)id.newId());
        Assert.assertEquals((Object)"testIdGenerator", (Object)id.getName());
    }

    @Test
    public void testLock() {
        ILock lock = this.getHazelcastClient().getLock((Object)"testLock");
        Assert.assertTrue((boolean)lock.tryLock());
        lock.unlock();
    }

    @Test
    public void testGetMapEntryHits() {
        IMap map = this.getHazelcastClient().getMap("testGetMapEntryHits");
        map.put((Object)"Hello", (Object)"World");
        MapEntry me = map.getMapEntry((Object)"Hello");
        Assert.assertEquals((long)0L, (long)me.getHits());
        map.get((Object)"Hello");
        map.get((Object)"Hello");
        map.get((Object)"Hello");
        me = map.getMapEntry((Object)"Hello");
        Assert.assertEquals((long)3L, (long)me.getHits());
    }

    @Test
    public void testGetMapEntryVersion() {
        IMap map = this.getHazelcastClient().getMap("testGetMapEntryVersion");
        map.put((Object)"Hello", (Object)"World");
        MapEntry me = map.getMapEntry((Object)"Hello");
        Assert.assertEquals((long)0L, (long)me.getVersion());
        map.put((Object)"Hello", (Object)"1");
        map.put((Object)"Hello", (Object)"2");
        map.put((Object)"Hello", (Object)"3");
        me = map.getMapEntry((Object)"Hello");
        Assert.assertEquals((long)3L, (long)me.getVersion());
    }

    @Test
    @Ignore
    public void testMapInstanceDestroy() throws Exception {
        IMap imap;
        IMap map = this.getHazelcastClient().getMap("testMapDestroy");
        Thread.sleep(1000L);
        Collection instances = this.getHazelcastClient().getInstances();
        boolean found = false;
        for (Instance instance : instances) {
            if (instance.getInstanceType() != Instance.InstanceType.MAP || !(imap = (IMap)instance).getName().equals("testMapDestroy")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        map.destroy();
        Thread.sleep(1000L);
        found = false;
        instances = this.getHazelcastClient().getInstances();
        for (Instance instance : instances) {
            if (instance.getInstanceType() != Instance.InstanceType.MAP || !(imap = (IMap)instance).getName().equals("testMapDestroy")) continue;
            found = true;
        }
        junit.framework.Assert.assertFalse((boolean)found);
    }

    @Test
    public void newSerializer() {
        String str = "Fuad";
        byte[] b = IOUtil.toByte((Object)"Fuad");
        Assert.assertEquals((Object)"Fuad", (Object)IOUtil.toObject((byte[])b));
    }

    @Test
    public void newSerializerExternalizable() {
        ExternalizableImpl o = new ExternalizableImpl();
        o.s = "Gallaxy";
        o.v = 42;
        byte[] b = IOUtil.toByte((Object)o);
        junit.framework.Assert.assertFalse((b.length == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertFalse((boolean)o.readExternal);
        Assert.assertTrue((boolean)o.writeExternal);
        ExternalizableImpl object = (ExternalizableImpl)IOUtil.toObject((byte[])b);
        Assert.assertNotNull((Object)object);
        Assert.assertNotSame((Object)o, (Object)object);
        Assert.assertEquals((Object)o, (Object)object);
        Assert.assertTrue((boolean)object.readExternal);
        junit.framework.Assert.assertFalse((boolean)object.writeExternal);
    }

    @Test
    public void testExternalizable() {
        IMap map = this.getHazelcastClient().getMap("testExternalizable");
        ExternalizableImpl o = new ExternalizableImpl();
        o.s = "Gallaxy";
        o.v = 42;
        map.put((Object)"Hello", (Object)o);
        junit.framework.Assert.assertFalse((boolean)o.readExternal);
        Assert.assertTrue((boolean)o.writeExternal);
        ExternalizableImpl object = (ExternalizableImpl)single.getHazelcastInstance().getMap("testExternalizable").get((Object)"Hello");
        Assert.assertNotNull((Object)object);
        Assert.assertNotSame((Object)o, (Object)object);
        Assert.assertEquals((Object)o, (Object)object);
        Assert.assertTrue((boolean)object.readExternal);
        junit.framework.Assert.assertFalse((boolean)object.writeExternal);
    }

    @Test
    public void testGetPartitions() throws InterruptedException {
        for (int i = 0; i < 1000; ++i) {
            this.getHazelcastClient().getMap("def").put((Object)i, (Object)i);
        }
        this.assertPartitionsUnique();
    }

    @Test
    public void testGetPartition() throws InterruptedException {
        IMap map = this.getHazelcastClient().getMap("def");
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            Partition p1 = single.getHazelcastInstance().getPartitionService().getPartition((Object)i);
            Partition p2 = single.getHazelcastClient().getPartitionService().getPartition((Object)i);
            Assert.assertEquals((long)p1.getPartitionId(), (long)p2.getPartitionId());
            Assert.assertEquals((Object)p1.getOwner(), (Object)p2.getOwner());
            set.add(p1.getPartitionId());
        }
        System.out.println("Size: " + set.size());
    }

    @Test
    public void testGetPartitionsFromDifferentThread() throws InterruptedException {
        for (int i = 0; i < 1000; ++i) {
            this.getHazelcastClient().getMap("def").put((Object)i, (Object)i);
        }
        new Thread(new Runnable(){

            public void run() {
                HazelcastClientTest.this.assertPartitionsUnique();
            }
        }).start();
    }

    private void assertPartitionsUnique() {
        HashSet<Integer> set = new HashSet<Integer>();
        PartitionService partitionService = this.getHazelcastClient().getPartitionService();
        Set partitions = partitionService.getPartitions();
        Assert.assertEquals((long)271L, (long)partitions.size());
        for (Partition partition : partitions) {
            Assert.assertNotNull((Object)partition.getPartitionId());
            Assert.assertTrue((boolean)set.add(partition.getPartitionId()));
        }
    }

    public static class ExternalizableImpl
    implements Externalizable {
        private int v;
        private String s;
        private boolean readExternal = false;
        private boolean writeExternal = false;

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExternalizableImpl)) {
                return false;
            }
            ExternalizableImpl other = (ExternalizableImpl)obj;
            return this.v == other.v && (this.s == null && other.s == null || this.s != null && this.s.equals(other.s));
        }

        public int hashCode() {
            return this.v + 31 * (this.s != null ? this.s.hashCode() : 0);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.v = in.readInt();
            this.s = in.readUTF();
            this.readExternal = true;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.v);
            out.writeUTF(this.s);
            this.writeExternal = true;
        }
    }
}

