/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class HazelcastClientTopicTest
extends HazelcastClientTestBase {
    @Test(expected=NullPointerException.class)
    public void testAddNull() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        ITopic topic = hClient.getTopic("testAddNull");
        topic.publish(null);
    }

    @Test
    public void testName() {
        HazelcastClient hClient = this.getHazelcastClient();
        ITopic topic = hClient.getTopic("testName");
        Assert.assertEquals((Object)"testName", (Object)topic.getName());
    }

    @Test
    public void addMessageListener() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        ITopic topic = hClient.getTopic("addMessageListener");
        final CountDownLatch latch = new CountDownLatch(1);
        String message = "Hazelcast Rocks!";
        topic.addMessageListener((MessageListener)new MessageListener<String>(){

            public void onMessage(String msg) {
                if (msg.equals("Hazelcast Rocks!")) {
                    latch.countDown();
                }
            }
        });
        topic.publish((Object)"Hazelcast Rocks!");
        Assert.assertTrue((boolean)latch.await(10000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void addTwoMessageListener() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        ITopic topic = hClient.getTopic("addTwoMessageListener");
        final CountDownLatch latch = new CountDownLatch(2);
        String message = "Hazelcast Rocks!";
        topic.addMessageListener((MessageListener)new MessageListener<String>(){

            public void onMessage(String msg) {
                if (msg.equals("Hazelcast Rocks!")) {
                    latch.countDown();
                }
            }
        });
        topic.addMessageListener((MessageListener)new MessageListener<String>(){

            public void onMessage(String msg) {
                if (msg.equals("Hazelcast Rocks!")) {
                    latch.countDown();
                }
            }
        });
        topic.publish((Object)"Hazelcast Rocks!");
        Assert.assertTrue((boolean)latch.await(10000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void removeMessageListener() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        ITopic topic = hClient.getTopic("removeMessageListener");
        final CountDownLatch latch = new CountDownLatch(2);
        final CountDownLatch cp = new CountDownLatch(1);
        MessageListener<String> messageListener = new MessageListener<String>(){

            public void onMessage(String msg) {
                System.out.println("Received " + msg + " at " + this);
                latch.countDown();
                cp.countDown();
            }
        };
        String message = "message_" + messageListener.hashCode() + "_";
        topic.addMessageListener((MessageListener)messageListener);
        topic.publish((Object)(message + "1"));
        cp.await();
        topic.removeMessageListener((MessageListener)messageListener);
        topic.publish((Object)(message + "2"));
        Thread.sleep(50L);
        Assert.assertEquals((long)1L, (long)latch.getCount());
    }

    @Test
    public void test10TimesRemoveMessageListener() throws InterruptedException {
        ExecutorService ex = Executors.newFixedThreadPool(1);
        final CountDownLatch latch = new CountDownLatch(10);
        ex.execute(new Runnable(){

            public void run() {
                for (int i = 0; i < 10; ++i) {
                    try {
                        HazelcastClientTopicTest.this.removeMessageListener();
                        latch.countDown();
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
    }

    @Test
    public void testPerformance() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        long begin = System.currentTimeMillis();
        int count = 10000;
        final ITopic topic = hClient.getTopic("perf");
        ExecutorService ex = Executors.newFixedThreadPool(10);
        final CountDownLatch l = new CountDownLatch(count);
        for (int i = 0; i < count; ++i) {
            ex.submit(new Runnable(){

                public void run() {
                    topic.publish((Object)"my object");
                    l.countDown();
                }
            });
        }
        Assert.assertTrue((boolean)l.await(20L, TimeUnit.SECONDS));
        long time = System.currentTimeMillis() - begin;
        System.out.println("per second: " + (long)(count * 1000) / time);
    }

    @Test
    public void add2listenerAndRemoveOne() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        ITopic topic = hClient.getTopic("removeMessageListener");
        final CountDownLatch latch = new CountDownLatch(4);
        final CountDownLatch cp = new CountDownLatch(2);
        String message = "Hazelcast Rocks!";
        MessageListener<String> messageListener1 = new MessageListener<String>(){

            public void onMessage(String msg) {
                if (msg.startsWith("Hazelcast Rocks!")) {
                    latch.countDown();
                    cp.countDown();
                }
            }
        };
        MessageListener<String> messageListener2 = new MessageListener<String>(){

            public void onMessage(String msg) {
                if (msg.startsWith("Hazelcast Rocks!")) {
                    latch.countDown();
                    cp.countDown();
                }
            }
        };
        topic.addMessageListener((MessageListener)messageListener1);
        topic.addMessageListener((MessageListener)messageListener2);
        topic.publish((Object)"Hazelcast Rocks!1");
        Thread.sleep(50L);
        topic.removeMessageListener((MessageListener)messageListener1);
        cp.await();
        topic.publish((Object)"Hazelcast Rocks!2");
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)latch.getCount());
    }

    @AfterClass
    public static void shutdown() {
    }
}

