/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.Transaction;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class HazelcastClientTransactionTest
extends HazelcastClientTestBase {
    @Test
    public void rollbackTransactionMap() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        IMap map = hClient.getMap("rollbackTransactionMap");
        map.put("1", "A");
        Assert.assertEquals((Object)"A", map.get("1"));
        transaction.rollback();
        Assert.assertNull(map.get("1"));
    }

    @Test
    public void commitTransactionMap() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        IMap map = hClient.getMap("commitTransactionMap");
        map.put("1", "A");
        Assert.assertEquals((Object)"A", map.get("1"));
        transaction.commit();
        Assert.assertEquals((Object)"A", map.get("1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionVisibilityFromDifferentThreads() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        final CountDownLatch latch = new CountDownLatch(1);
        final Object o = new Object();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        final IMap map = hClient.getMap("testTransactionVisibilityFromDifferentThreads");
        map.put((Object)"1", (Object)"A");
        Assert.assertEquals((Object)"A", (Object)map.get((Object)"1"));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Assert.assertNull((Object)map.get((Object)"1"));
                if (!map.containsKey((Object)"1")) {
                    latch.countDown();
                }
                Object object = o;
                synchronized (object) {
                    o.notify();
                }
            }
        }).start();
        Object object = o;
        synchronized (object) {
            o.wait();
        }
        transaction.rollback();
        Assert.assertNull((Object)map.get((Object)"1"));
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MICROSECONDS));
    }

    @Test
    public void rollbackTransactionList() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        IList list = hClient.getList("rollbackTransactionList");
        list.add("Istanbul");
        transaction.rollback();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void commitTransactionList() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        IList list = hClient.getList("commitTransactionList");
        list.add("Istanbul");
        transaction.commit();
        Assert.assertTrue((boolean)list.contains("Istanbul"));
    }

    @Test
    public void rollbackTransactionSet() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        ISet set = hClient.getSet("rollbackTransactionSet");
        set.add("Istanbul");
        transaction.rollback();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void commitTransactionSet() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        ISet set = hClient.getSet("commitTransactionSet");
        set.add("Istanbul");
        transaction.commit();
        Assert.assertTrue((boolean)set.contains("Istanbul"));
    }

    @Test
    public void rollbackTransactionQueue() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        IQueue q = hClient.getQueue("rollbackTransactionQueue");
        q.offer("Istanbul");
        transaction.rollback();
        Assert.assertTrue((boolean)q.isEmpty());
    }

    @Test
    public void commitTransactionQueue() {
        HazelcastClient hClient = this.getHazelcastClient();
        Transaction transaction = hClient.getTransaction();
        transaction.begin();
        IQueue q = hClient.getQueue("commitTransactionQueue");
        q.offer("Istanbul");
        transaction.commit();
        Assert.assertEquals((Object)"Istanbul", q.poll());
    }

    @AfterClass
    public static void shutdown() {
    }
}

