/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.QueueClientProxy;
import com.hazelcast.client.QueueItemIterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class QueueItemIteratorTest {
    @Test(expected=NoSuchElementException.class)
    public void emtpyIterator() {
        QueueItemIterator it = new QueueItemIterator((Object[])new String[0], null);
        Assert.assertFalse((boolean)it.hasNext());
        it.next();
    }

    @Test(expected=IllegalStateException.class)
    public void removeOnEmptyIterator() {
        QueueItemIterator it = new QueueItemIterator((Object[])new String[0], null);
        Assert.assertFalse((boolean)it.hasNext());
        it.remove();
    }

    @Test(expected=IllegalStateException.class)
    public void callremoveTwice() {
        QueueClientProxy mockQCP = (QueueClientProxy)Mockito.mock(QueueClientProxy.class);
        QueueItemIterator it = new QueueItemIterator((Object[])new String[]{"a"}, mockQCP);
        Assert.assertTrue((boolean)it.hasNext());
        String v = (String)it.next();
        Assert.assertEquals((Object)"a", (Object)v);
        it.remove();
        ((QueueClientProxy)Mockito.verify((Object)mockQCP)).remove((Object)"a");
        it.remove();
    }

    @Test
    public void fivelementsIterate() {
        QueueClientProxy mockQCP = (QueueClientProxy)Mockito.mock(QueueClientProxy.class);
        QueueItemIterator it = new QueueItemIterator((Object[])new String[]{"1", "2", "3", "4", "5"}, mockQCP);
        int counter = 0;
        while (it.hasNext()) {
            String v = (String)it.next();
            it.remove();
            ++counter;
        }
        Assert.assertEquals((long)5L, (long)counter);
        ((QueueClientProxy)Mockito.verify((Object)mockQCP)).remove((Object)"1");
        ((QueueClientProxy)Mockito.verify((Object)mockQCP)).remove((Object)"2");
        ((QueueClientProxy)Mockito.verify((Object)mockQCP)).remove((Object)"3");
        ((QueueClientProxy)Mockito.verify((Object)mockQCP)).remove((Object)"4");
        ((QueueClientProxy)Mockito.verify((Object)mockQCP)).remove((Object)"5");
    }
}

