/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.IOUtil;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTest {
    @Test(expected=RuntimeException.class)
    public void newNotSerializableException() {
        Object o = new Object();
        IOUtil.toByte((Object)o);
    }

    @Test
    public void newNullSerializer() {
        Object o = null;
        byte[] data = IOUtil.toByte(o);
        Assert.assertEquals(o, (Object)IOUtil.toObject((byte[])data));
    }

    @Test
    public void newStringSerializer() {
        String s = "newStringSerializer 2@Z";
        byte[] data = IOUtil.toByte((Object)"newStringSerializer 2@Z");
        Assert.assertEquals((Object)"newStringSerializer 2@Z", (Object)IOUtil.toObject((byte[])data));
    }

    @Test
    public void newDateSerializer() {
        Date date = new Date();
        byte[] data = IOUtil.toByte((Object)date);
        Assert.assertEquals((Object)date, (Object)IOUtil.toObject((byte[])data));
    }

    @Test
    public void newSerializerExternalizable() {
        ExternalizableImpl o = new ExternalizableImpl();
        o.s = "Gallaxy";
        o.v = 42;
        byte[] data = IOUtil.toByte((Object)o);
        junit.framework.Assert.assertFalse((data.length == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertFalse((boolean)o.readExternal);
        Assert.assertTrue((boolean)o.writeExternal);
        ExternalizableImpl object = (ExternalizableImpl)IOUtil.toObject((byte[])data);
        Assert.assertNotNull((Object)object);
        Assert.assertNotSame((Object)o, (Object)object);
        Assert.assertEquals((Object)o, (Object)object);
        Assert.assertTrue((boolean)object.readExternal);
        junit.framework.Assert.assertFalse((boolean)object.writeExternal);
    }

    @Test
    public void newSerializerProxyKey() {
        FactoryImpl.ProxyKey o = new FactoryImpl.ProxyKey("key", (Object)15L);
        byte[] data = IOUtil.toByte((Object)o);
        junit.framework.Assert.assertFalse((data.length == 0 ? 1 : 0) != 0);
        FactoryImpl.ProxyKey object = (FactoryImpl.ProxyKey)IOUtil.toObject((byte[])data);
        Assert.assertNotNull((Object)object);
        Assert.assertNotSame((Object)o, (Object)object);
        Assert.assertEquals((Object)o, (Object)object);
    }

    private static class DataSerializableImpl
    implements DataSerializable {
        private int v;
        private String s;
        private boolean readExternal = false;
        private boolean writeExternal = false;

        private DataSerializableImpl() {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DataSerializableImpl)) {
                return false;
            }
            DataSerializableImpl other = (DataSerializableImpl)obj;
            return this.v == other.v && (this.s == null && other.s == null || this.s != null && this.s.equals(other.s));
        }

        public int hashCode() {
            return this.v + 31 * (this.s != null ? this.s.hashCode() : 0);
        }

        public void readData(DataInput in) throws IOException {
            this.v = in.readInt();
            this.s = in.readUTF();
            this.readExternal = true;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.v);
            out.writeUTF(this.s);
            this.writeExternal = true;
        }
    }

    private static class ExternalizableImpl
    implements Externalizable {
        private int v;
        private String s;
        private boolean readExternal = false;
        private boolean writeExternal = false;

        private ExternalizableImpl() {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExternalizableImpl)) {
                return false;
            }
            ExternalizableImpl other = (ExternalizableImpl)obj;
            return this.v == other.v && (this.s == null && other.s == null || this.s != null && this.s.equals(other.s));
        }

        public int hashCode() {
            return this.v + 31 * (this.s != null ? this.s.hashCode() : 0);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.v = in.readInt();
            this.s = in.readUTF();
            this.readExternal = true;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.v);
            out.writeUTF(this.s);
            this.writeExternal = true;
        }
    }
}

