/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientProperties;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TestUtility {
    static final List<HazelcastClient> clients = new CopyOnWriteArrayList<HazelcastClient>();

    public static synchronized void destroyClients() {
        for (HazelcastClient c : clients) {
            c.shutdown();
        }
        clients.clear();
    }

    public static synchronized HazelcastClient newHazelcastClient(HazelcastInstance ... h) {
        String name = h[0].getConfig().getGroupConfig().getName();
        String pass = h[0].getConfig().getGroupConfig().getPassword();
        return TestUtility.newHazelcastClient(ClientProperties.crateBaseClientProperties((String)name, (String)pass), h);
    }

    public static synchronized HazelcastClient newHazelcastClient(ClientProperties properties, HazelcastInstance ... h) {
        InetSocketAddress[] addresses = new InetSocketAddress[h.length];
        for (int i = 0; i < h.length; ++i) {
            addresses[i] = h[i].getCluster().getLocalMember().getInetSocketAddress();
        }
        HazelcastClient client = HazelcastClient.newHazelcastClient((ClientProperties)properties, (boolean)true, (InetSocketAddress[])addresses);
        clients.add(client);
        return client;
    }
}

