/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.EntryHolder;
import com.hazelcast.client.ValueCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ValueCollectionTest {
    @Test
    public void testContainsAllEmptyCollection() {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet set = new HashSet();
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        valueCollection.containsAll(new ArrayList());
    }

    @Test
    public void testContainsAll() {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        map.put("3", "3");
        ValueCollection valueCollection = new ValueCollection(entryHolder, map.entrySet());
        ArrayList<String> c = new ArrayList<String>();
        c.add("1");
        c.add("2");
        c.add("3");
        boolean result = valueCollection.containsAll(c);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testContains() {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        ValueCollection valueCollection = new ValueCollection(entryHolder, map.entrySet());
        boolean result = valueCollection.contains((Object)"1");
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testToArray() {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        map.put("3", "3");
        ValueCollection valueCollection = new ValueCollection(entryHolder, map.entrySet());
        Object[] result = valueCollection.toArray();
        Assert.assertEquals((long)3L, (long)result.length);
        List<Object> l = Arrays.asList(result);
        Assert.assertTrue((boolean)l.containsAll(map.values()));
    }

    @Test
    public void testNotEmpty() {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "value");
        ValueCollection valueCollection = new ValueCollection(entryHolder, map.entrySet());
        Assert.assertFalse((boolean)valueCollection.isEmpty());
    }

    @Test
    public void testEmpty() {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        Mockito.when((Object)entryHolder.size()).thenReturn((Object)0);
        HashMap map = new HashMap();
        ValueCollection valueCollection = new ValueCollection(entryHolder, map.entrySet());
        Assert.assertTrue((boolean)valueCollection.isEmpty());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAdd() throws Exception {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet set = new HashSet();
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        valueCollection.add((Object)"1");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAll() throws Exception {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet set = new HashSet();
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        valueCollection.addAll(new ArrayList());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() throws Exception {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet set = new HashSet();
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        valueCollection.remove((Object)"1");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAll() throws Exception {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet set = new HashSet();
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        valueCollection.removeAll(null);
    }

    @Test
    public void testRetainAll() throws Exception {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet set = new HashSet();
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        Assert.assertFalse((boolean)valueCollection.retainAll(new ArrayList()));
    }

    @Test
    public void testToArrayWithArgument() {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet<MapEntry<String, String>> set = new HashSet<MapEntry<String, String>>();
        set.add(new MapEntry<String, String>("1", "1"));
        set.add(new MapEntry<String, String>("2", "2"));
        set.add(new MapEntry<String, String>("3", "3"));
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        Object[] values = valueCollection.toArray();
        Arrays.sort(values);
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "3"}, (Object[])values);
        values = (String[])valueCollection.toArray((Object[])new String[3]);
        Arrays.sort(values);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])values);
        values = (String[])valueCollection.toArray((Object[])new String[2]);
        Arrays.sort(values);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])values);
        values = (String[])valueCollection.toArray((Object[])new String[5]);
        Arrays.sort(values, 0, 3);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3", null, null}, (Object[])values);
    }

    @Test(expected=NullPointerException.class)
    public void testToArrayWithArgumentNPE() throws Exception {
        EntryHolder entryHolder = (EntryHolder)Mockito.mock(EntryHolder.class);
        HashSet set = new HashSet();
        ValueCollection valueCollection = new ValueCollection(entryHolder, set);
        valueCollection.toArray(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

