/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.impl.MembershipListenerManager;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.nio.Address;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MembershipListenerManagerTest {
    @Test
    public void testRegisterMembershipListener() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        MembershipListenerManager listenerManager = new MembershipListenerManager(client);
        MembershipListener listener = new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
            }
        };
        listenerManager.registerListener(listener);
        Assert.assertFalse((boolean)listenerManager.noListenerRegistered());
    }

    @Test
    public void testRemoveMembershipListener() throws Exception {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        MembershipListenerManager listenerManager = new MembershipListenerManager(client);
        MembershipListener listener = new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
            }
        };
        listenerManager.registerListener(listener);
        listenerManager.removeListener(listener);
        Assert.assertTrue((boolean)listenerManager.noListenerRegistered());
    }

    @Test
    public void testNotifyMembershipListenerMemberAdded() throws Exception {
        this.notifyMembershipListener(1);
    }

    @Test
    public void testNotifyMembershipListenerMemberRemoved() throws Exception {
        this.notifyMembershipListener(3);
    }

    private void notifyMembershipListener(final int type) throws InterruptedException {
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)client.getCluster()).thenReturn((Object)cluster);
        final MembershipListenerManager membershipListenerManager = new MembershipListenerManager(client);
        final CountDownLatch memberAdded = new CountDownLatch(1);
        final CountDownLatch memberRemoved = new CountDownLatch(1);
        MembershipListener listener = new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                memberAdded.countDown();
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                memberRemoved.countDown();
            }
        };
        membershipListenerManager.registerListener(listener);
        new Thread(new Runnable(){

            public void run() {
                Packet packet = new Packet();
                Address address = new Address();
                MemberImpl member = new MemberImpl(address, false);
                packet.setKey(IOUtil.toByte((Object)member));
                packet.setValue(IOUtil.toByte((Object)type));
                membershipListenerManager.notifyListeners(packet);
            }
        }).start();
        if (type == 1) {
            Assert.assertTrue((boolean)memberAdded.await(5L, TimeUnit.SECONDS));
        } else {
            Assert.assertTrue((boolean)memberRemoved.await(5L, TimeUnit.SECONDS));
        }
    }
}

