/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.impl.MessageListenerManager;
import com.hazelcast.core.MessageListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class MessageListenerManagerTest {
    @Test
    public void testRegisterMessageListener() throws Exception {
        MessageListenerManager manager = new MessageListenerManager();
        String name = "default";
        Assert.assertTrue((boolean)manager.noListenerRegistered(name));
        MessageListener listener = new MessageListener(){

            public void onMessage(Object message) {
            }
        };
        manager.registerListener(name, listener);
        Assert.assertFalse((boolean)manager.noListenerRegistered(name));
    }

    @Test
    public void testRemoveMessageListener() throws Exception {
        MessageListenerManager manager = new MessageListenerManager();
        String name = "default";
        Assert.assertTrue((boolean)manager.noListenerRegistered(name));
        MessageListener listener = new MessageListener(){

            public void onMessage(Object message) {
            }
        };
        manager.registerListener(name, listener);
        Assert.assertFalse((boolean)manager.noListenerRegistered(name));
        manager.removeListener(name, listener);
        Assert.assertTrue((boolean)manager.noListenerRegistered(name));
        manager.removeListener(name, listener);
        Assert.assertTrue((boolean)manager.noListenerRegistered(name));
    }

    @Test
    public void testNotifyMessageListeners() throws Exception {
        final MessageListenerManager manager = new MessageListenerManager();
        String name = "default";
        Assert.assertTrue((boolean)manager.noListenerRegistered("default"));
        String myMessage = "my myMessage";
        final CountDownLatch latch = new CountDownLatch(1);
        MessageListener listener = new MessageListener(){

            public void onMessage(Object message) {
                if (message.equals("my myMessage")) {
                    latch.countDown();
                }
            }
        };
        manager.registerListener("default", listener);
        Assert.assertFalse((boolean)manager.noListenerRegistered("default"));
        new Thread(new Runnable(){

            public void run() {
                Packet packet = new Packet();
                packet.setName("default");
                packet.setKey(IOUtil.toByte((Object)"my myMessage"));
                manager.notifyMessageListeners(packet);
            }
        }).start();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }
}

