/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.longrunning;

import com.hazelcast.client.ClientProperties;
import com.hazelcast.client.CountDownLatchEntryListener;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientMapTest;
import com.hazelcast.client.NoMemberAvailableException;
import com.hazelcast.client.TestUtility;
import com.hazelcast.config.Config;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DataSerializableUser;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAwareObject;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Instance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.SleepCallable;
import com.hazelcast.monitor.DistributedMapStatsCallable;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClusterTest {
    HazelcastClient client;
    Config config = new Config();

    @Before
    public void before() throws Exception {
        System.setProperty("junit.default.timeout", "300000");
        this.config.setProperty("hazelcast.wait.seconds.before.join", "1");
        this.config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        this.config.getNetworkConfig().getJoin().getTcpIpConfig().setMembers(Arrays.asList(Inet4Address.getLocalHost().getHostName()));
    }

    @After
    @Before
    public void after() throws Exception {
        TestUtility.destroyClients();
        Hazelcast.shutdownAll();
    }

    public void afterAwait() throws Exception {
        System.err.println("-------------------");
        System.in.read();
    }

    @Test
    public void continuePutAndGetIfOneOfConnectedClusterMemberFails() throws Exception {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h3 = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h1, h2);
        IMap realMap = h3.getMap("default");
        Map<Integer, HazelcastInstance> memberMap = this.getMapOfClusterMembers(h1, h2);
        IMap map = this.client.getMap("default");
        for (int counter = 0; counter < 2; ++counter) {
            try {
                map.put("currentIteratedKey", counter);
            }
            catch (Throwable e) {
                Assert.fail((String)e.getMessage());
            }
            junit.framework.Assert.assertEquals((Object)counter, realMap.get("currentIteratedKey"));
            junit.framework.Assert.assertEquals((Object)counter, map.get("currentIteratedKey"));
            int port = this.client.getConnectionManager().getConnection().getAddress().getPort();
            memberMap.get(port).shutdown();
        }
        h3.shutdown();
    }

    @Test
    public void fiveTimesContinuePutAndGetIfOneOfConnectedClusterMemberFails() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.continuePutAndGetIfOneOfConnectedClusterMemberFails();
        }
    }

    @Test
    public void test2Instances1ClusterMemberAndFailover() throws InterruptedException {
        int i;
        final CountDownLatch latch = new CountDownLatch(2);
        final CountDownLatch shutdownLatch = new CountDownLatch(1);
        final ConcurrentHashMap instanceMap = new ConcurrentHashMap();
        new Thread(new Runnable(){

            public void run() {
                HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)DynamicClusterTest.this.config);
                instanceMap.put(0, h);
                latch.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)DynamicClusterTest.this.config);
                instanceMap.put(1, h);
                latch.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ((HazelcastInstance)instanceMap.get(1)).getLifecycleService().shutdown();
            }
        }).start();
        latch.await();
        HazelcastClient client = TestUtility.newHazelcastClient((HazelcastInstance)instanceMap.get(1), (HazelcastInstance)instanceMap.get(0));
        IMap map = client.getMap("myMap");
        for (i = 0; i < 100; ++i) {
            map.put("test", i);
            if (i != 20) continue;
            shutdownLatch.countDown();
        }
        junit.framework.Assert.assertEquals((Object)(i - 1), map.get("test"));
        client.shutdown();
        ((HazelcastInstance)instanceMap.get(0)).shutdown();
    }

    @Test
    public void fiveTimesTest2Instances1ClusterMemberAndFailover() throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            this.test2Instances1ClusterMemberAndFailover();
        }
    }

    @Test(expected=RuntimeException.class)
    public void throwsRuntimeExceptionWhenNoMemberToConnect() throws InterruptedException, IOException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h3 = Hazelcast.newHazelcastInstance((Config)this.config);
        IMap realMap = h3.getMap("default");
        Map<Integer, HazelcastInstance> memberMap = this.getMapOfClusterMembers(h1, h2);
        this.client = TestUtility.newHazelcastClient(h1, h2, h3);
        IMap map = this.client.getMap("default");
        realMap.get("currentIteratedKey");
        for (int counter = 0; counter < 3; ++counter) {
            map.put("currentIteratedKey", counter);
            junit.framework.Assert.assertEquals((Object)counter, map.get("currentIteratedKey"));
            junit.framework.Assert.assertEquals((Object)counter, realMap.get("currentIteratedKey"));
            memberMap.get(this.client.getConnectionManager().getConnection().getAddress().getPort()).shutdown();
        }
    }

    @Test
    public void addListenerWithTwoMemberClusterAndKillOne() throws InterruptedException, IOException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        Map<Integer, HazelcastInstance> memberMap = this.getMapOfClusterMembers(h1, h2);
        this.client = TestUtility.newHazelcastClient(h1, h2);
        IMap map = this.client.getMap("default");
        CountDownLatch entryAddLatch = new CountDownLatch(2);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(2);
        CountDownLatch entryRemovedLatch = new CountDownLatch(2);
        CountDownLatchEntryListener listener = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener, true);
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        memberMap.remove(this.client.getConnectionManager().getConnection().getAddress().getPort()).shutdown();
        map.size();
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        junit.framework.Assert.assertTrue((boolean)entryAddLatch.await(10L, TimeUnit.SECONDS));
        junit.framework.Assert.assertTrue((boolean)entryUpdatedLatch.await(10L, TimeUnit.SECONDS));
        junit.framework.Assert.assertTrue((boolean)entryRemovedLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void addListenerWithTwoMemberClusterAndKillOnePutFromNodes() throws InterruptedException, IOException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        Map<Integer, HazelcastInstance> memberMap = this.getMapOfClusterMembers(h1, h2);
        this.client = TestUtility.newHazelcastClient(h1, h2);
        IMap clientMap = this.client.getMap("default");
        IMap map1 = h1.getMap("default");
        IMap map2 = h2.getMap("default");
        CountDownLatch entryAddLatch = new CountDownLatch(2);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(2);
        CountDownLatch entryRemovedLatch = new CountDownLatch(2);
        CountDownLatchEntryListener listener = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        clientMap.addEntryListener(listener, true);
        map1.put((Object)"hello", (Object)"world");
        map1.put((Object)"hello", (Object)"new world");
        map1.remove((Object)"hello");
        memberMap.remove(this.client.getConnectionManager().getConnection().getAddress().getPort()).shutdown();
        clientMap.size();
        clientMap.put((Object)"hello", (Object)"world");
        clientMap.put((Object)"hello", (Object)"new world");
        clientMap.remove((Object)"hello");
        junit.framework.Assert.assertTrue((boolean)entryAddLatch.await(10L, TimeUnit.SECONDS));
        junit.framework.Assert.assertTrue((boolean)entryUpdatedLatch.await(10L, TimeUnit.SECONDS));
        junit.framework.Assert.assertTrue((boolean)entryRemovedLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void add2ListenerWithTwoMemberClusterRemoveOneListenerAndKillOneClusterInstance() throws InterruptedException, IOException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        Map<Integer, HazelcastInstance> memberMap = this.getMapOfClusterMembers(h1, h2);
        this.client = TestUtility.newHazelcastClient(h1, h2);
        IMap map = this.client.getMap("default");
        CountDownLatch entryAddLatch = new CountDownLatch(4);
        CountDownLatch entryUpdatedLatch = new CountDownLatch(4);
        CountDownLatch entryRemovedLatch = new CountDownLatch(4);
        CountDownLatchEntryListener listener = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        CountDownLatchEntryListener listener2 = new CountDownLatchEntryListener(entryAddLatch, entryUpdatedLatch, entryRemovedLatch);
        map.addEntryListener(listener, true);
        map.addEntryListener(listener2, (Object)"hello", true);
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        map.removeEntryListener(listener2, (Object)"hello");
        memberMap.remove(this.client.getConnectionManager().getConnection().getAddress().getPort()).shutdown();
        map.put((Object)"hello", (Object)"world");
        map.put((Object)"hello", (Object)"new world");
        map.remove((Object)"hello");
        Thread.sleep(1000L);
        junit.framework.Assert.assertEquals((long)1L, (long)entryAddLatch.getCount());
        junit.framework.Assert.assertEquals((long)1L, (long)entryUpdatedLatch.getCount());
        junit.framework.Assert.assertEquals((long)1L, (long)entryRemovedLatch.getCount());
    }

    @Test
    public void addMessageListenerWhithClusterFailOver() throws InterruptedException, IOException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        Map<Integer, HazelcastInstance> memberMap = this.getMapOfClusterMembers(h1, h2);
        this.client = TestUtility.newHazelcastClient(h1, h2);
        final ITopic topic = this.client.getTopic("ABC");
        final CountDownLatch latch = new CountDownLatch(2);
        String message = "Hazelcast Rocks!";
        topic.addMessageListener((MessageListener)new MessageListener<String>(){

            public void onMessage(String msg) {
                if (msg.equals("Hazelcast Rocks!")) {
                    latch.countDown();
                }
                System.out.println(msg);
            }
        });
        topic.publish((Object)"Hazelcast Rocks!");
        HazelcastInstance h = memberMap.remove(this.client.getConnectionManager().getConnection().getAddress().getPort());
        h.shutdown();
        System.out.println("Shut down: " + h.getCluster().getLocalMember().getPort());
        Thread.sleep(1000L);
        for (int i = 0; i < 2; ++i) {
            new Thread(new Runnable(){

                public void run() {
                    System.out.println("Thread number " + Thread.currentThread().getId());
                    topic.publish((Object)"Hazelcast Rocks!");
                }
            }).start();
        }
        System.out.println("FINISHED");
        junit.framework.Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void shutdown() throws InterruptedException {
        for (int i = 0; i < 3; ++i) {
            HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
            this.client = TestUtility.newHazelcastClient(h1);
            IMap clientMap = this.client.getMap("map1");
            IMap hMap = h1.getMap("map1");
            clientMap.put("A", String.valueOf(i));
            junit.framework.Assert.assertEquals((String)String.valueOf(i), (String)((String)hMap.get("A")));
        }
    }

    @Test
    public void testGetInstancesCreatedFromClient() {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)new Config());
        this.client = TestUtility.newHazelcastClient(h);
        IList list = this.client.getList("testGetInstancesCreatedFromClient");
        IMap map = this.client.getMap("testGetInstancesCreatedFromClient");
        MultiMap mmap = this.client.getMultiMap("testGetInstancesCreatedFromClient");
        IQueue q = this.client.getQueue("testGetInstancesCreatedFromClient");
        ISet set = this.client.getSet("testGetInstancesCreatedFromClient");
        ITopic topic = this.client.getTopic("testGetInstancesCreatedFromClient");
        ILock lock = this.client.getLock((Object)"testGetInstancesCreatedFromClient");
        Collection caches = this.client.getInstances();
        junit.framework.Assert.assertEquals((int)0, (int)caches.size());
        ArrayList<Object> listOfInstances = new ArrayList<Object>();
        listOfInstances.add(list);
        listOfInstances.add(map);
        listOfInstances.add(mmap);
        listOfInstances.add(q);
        listOfInstances.add(set);
        listOfInstances.add(topic);
        listOfInstances.add(lock);
        list.add("List");
        map.put("key", "value");
        junit.framework.Assert.assertEquals((int)2, (int)this.client.getInstances().size());
        mmap.put((Object)"key", (Object)"value1");
        q.offer("Element");
        junit.framework.Assert.assertEquals((int)4, (int)this.client.getInstances().size());
        set.add("element");
        topic.publish((Object)"Message");
        caches = this.client.getInstances();
        for (Instance instance : caches) {
            junit.framework.Assert.assertTrue((boolean)instance.getId().toString().endsWith("testGetInstancesCreatedFromClient"));
            junit.framework.Assert.assertTrue((boolean)listOfInstances.contains(instance));
            instance.destroy();
        }
    }

    @Test
    @Ignore
    public void testGetInstancesCreatedFromCluster() {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        IList list = h.getList("testGetInstancesCreatedFromCluster");
        IMap map = h.getMap("testGetInstancesCreatedFromCluster");
        MultiMap mmap = h.getMultiMap("testGetInstancesCreatedFromCluster");
        IQueue q = h.getQueue("testGetInstancesCreatedFromCluster");
        ISet set = h.getSet("testGetInstancesCreatedFromCluster");
        ITopic topic = h.getTopic("testGetInstancesCreatedFromCluster");
        ILock lock = h.getLock((Object)"testGetInstancesCreatedFromCluster");
        ArrayList<Object> listOfInstances = new ArrayList<Object>();
        listOfInstances.add(list);
        listOfInstances.add(map);
        listOfInstances.add(mmap);
        listOfInstances.add(q);
        listOfInstances.add(set);
        listOfInstances.add(topic);
        listOfInstances.add(lock);
        this.client = TestUtility.newHazelcastClient(h);
        Collection caches = this.client.getInstances();
        junit.framework.Assert.assertEquals((int)listOfInstances.size(), (int)caches.size());
        for (Instance instance : caches) {
            junit.framework.Assert.assertTrue((boolean)instance.getId().toString().endsWith("testGetInstancesCreatedFromCluster"));
            junit.framework.Assert.assertTrue((boolean)listOfInstances.contains(instance));
        }
        h.shutdown();
    }

    @Test
    public void testAuthenticate() {
        String grName = "dev";
        String grPass = "pass";
        Config conf = new Config();
        conf.setProperty("hazelcast.wait.seconds.before.join", "1");
        GroupConfig gc = new GroupConfig();
        gc.setName(grName);
        gc.setPassword(grPass);
        conf.setGroupConfig(gc);
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)conf);
        this.client = HazelcastClient.newHazelcastClient((String)grName, (String)grPass, (boolean)true, (String[])new String[]{h.getCluster().getLocalMember().getInetSocketAddress().getAddress().getCanonicalHostName() + ":" + h.getCluster().getLocalMember().getInetSocketAddress().getPort()});
        IMap map = this.client.getMap("aasd");
        this.client.shutdown();
        h.shutdown();
    }

    @Test
    public void testAuthenticateWithEmptyPass() {
        String grName = "dev";
        String grPass = "";
        Config conf = new Config();
        GroupConfig gc = new GroupConfig();
        gc.setName(grName);
        gc.setPassword(grPass);
        conf.setGroupConfig(gc);
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)conf);
        this.client = HazelcastClient.newHazelcastClient((String)grName, (String)"", (boolean)true, (String[])new String[]{h.getCluster().getLocalMember().getInetSocketAddress().getAddress().getCanonicalHostName() + ":" + h.getCluster().getLocalMember().getInetSocketAddress().getPort()});
        IMap map = this.client.getMap("aasd");
        this.client.shutdown();
        h.shutdown();
    }

    @Test(expected=RuntimeException.class)
    public void testAuthenticateWrongPass() {
        String grName = "dev";
        String grPass = "pass";
        Config conf = new Config();
        GroupConfig gc = new GroupConfig();
        gc.setName(grName);
        gc.setPassword(grPass);
        conf.setGroupConfig(gc);
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)conf);
        this.client = HazelcastClient.newHazelcastClient((String)grName, (String)"wrong-pass", (boolean)true, (String[])new String[]{h.getCluster().getLocalMember().getInetSocketAddress().getAddress().getCanonicalHostName() + ":" + h.getCluster().getLocalMember().getInetSocketAddress().getPort()});
        IMap map = this.client.getMap("aasd");
        this.client.shutdown();
        h.shutdown();
    }

    @Test
    public void addMemberShipListener() throws InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h);
        final CountDownLatch added = new CountDownLatch(1);
        final CountDownLatch removed = new CountDownLatch(1);
        final HashMap map = new HashMap();
        this.client.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                map.put("Added", membershipEvent.getMember());
                added.countDown();
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                map.put("Removed", membershipEvent.getMember());
                removed.countDown();
            }
        });
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        Member member = h2.getCluster().getLocalMember();
        h2.shutdown();
        junit.framework.Assert.assertTrue((boolean)added.await(10L, TimeUnit.SECONDS));
        junit.framework.Assert.assertEquals((Object)member.getInetSocketAddress(), (Object)((Member)map.get("Added")).getInetSocketAddress());
        junit.framework.Assert.assertTrue((boolean)removed.await(10L, TimeUnit.SECONDS));
        junit.framework.Assert.assertEquals((Object)member.getInetSocketAddress(), (Object)((Member)map.get("Removed")).getInetSocketAddress());
    }

    @Test
    public void retrieveDataSerializableClass() throws InterruptedException {
        System.out.println("Start");
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h);
        IMap clientMap = this.client.getMap("retreiveDataSerializableClass");
        final DataSerializableUser user = new DataSerializableUser();
        user.setName("name");
        user.setFamilyName("fName");
        user.setAge(30);
        user.setAddress(new DataSerializableUser.Address());
        final CountDownLatch cdl = new CountDownLatch(2);
        EntryAdapter<Integer, DataSerializableUser> listener = new EntryAdapter<Integer, DataSerializableUser>(){

            public void entryAdded(EntryEvent<Integer, DataSerializableUser> entryEvent) {
                DataSerializableUser u = (DataSerializableUser)entryEvent.getValue();
                junit.framework.Assert.assertEquals((String)user.getName(), (String)u.getName());
                junit.framework.Assert.assertEquals((String)user.getFamilyName(), (String)u.getFamilyName());
                junit.framework.Assert.assertEquals((int)user.getAge(), (int)u.getAge());
                junit.framework.Assert.assertEquals((String)user.getAddress().getAddress(), (String)u.getAddress().getAddress());
                cdl.countDown();
            }
        };
        clientMap.addEntryListener((EntryListener)listener, true);
        IMap clusterMap = h.getMap("retreiveDataSerializableClass");
        clusterMap.addEntryListener((EntryListener)listener, true);
        clientMap.put((Object)1, (Object)user);
        DataSerializableUser dsu = (DataSerializableUser)clientMap.get((Object)1);
        junit.framework.Assert.assertEquals((String)user.getName(), (String)dsu.getName());
        junit.framework.Assert.assertEquals((String)user.getFamilyName(), (String)dsu.getFamilyName());
        junit.framework.Assert.assertEquals((int)user.getAge(), (int)dsu.getAge());
        junit.framework.Assert.assertEquals((String)user.getAddress().getAddress(), (String)dsu.getAddress().getAddress());
        junit.framework.Assert.assertTrue((boolean)cdl.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void clientWithAutoMemberListUpdate() throws InterruptedException {
        final HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = this.getAutoUpdatingClient(h1);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        Thread.sleep(1000L);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                h1.shutdown();
                latch.countDown();
            }
        }).start();
        IMap map = this.client.getMap("map");
        map.put(1, 1);
        junit.framework.Assert.assertEquals((Object)1, map.get(1));
        latch.await();
        map.put(2, 2);
        junit.framework.Assert.assertEquals((Object)2, map.get(2));
    }

    @Test
    public void ensureClientWillUpdateMembersList() throws InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = this.getAutoUpdatingClient(h1);
        Thread.sleep(1000L);
        h1.shutdown();
        IMap map = this.client.getMap("map");
        map.put(1, 1);
        junit.framework.Assert.assertEquals((Object)1, map.get(1));
    }

    private HazelcastClient getAutoUpdatingClient(HazelcastInstance h1) {
        Config conf = h1.getConfig();
        HazelcastClient client = HazelcastClient.newHazelcastClient((String)conf.getGroupConfig().getName(), (String)conf.getGroupConfig().getPassword(), (String)h1.getCluster().getLocalMember().getInetSocketAddress().toString().substring(1));
        return client;
    }

    @Test(timeout=25000L, expected=MemberLeftException.class)
    public void shouldThrowMemberLeftExcWhenNotConnectedMemberDiesWhileExecuting() throws ExecutionException, InterruptedException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h2);
        Set members = this.client.getCluster().getMembers();
        MultiTask task = new MultiTask((Callable)new SleepCallable(10000L), members);
        this.client.getExecutorService().submit((Runnable)task);
        Thread.sleep(2000L);
        h1.shutdown();
        task.get();
    }

    @Test(timeout=60000L, expected=ExecutionException.class)
    public void shouldThrowExExcptnWhenTheOnlyConnectedMemberDiesWhileExecuting() throws ExecutionException, InterruptedException {
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h2);
        Set members = this.client.getCluster().getMembers();
        MultiTask task = new MultiTask((Callable)new SleepCallable(10000L), members);
        this.client.getExecutorService().submit((Runnable)task);
        Thread.sleep(2000L);
        h2.shutdown();
        task.get();
    }

    @Test
    public void shouldThrowNoMemeberAvailableExceptionWhenThereIsNoMemberToConnect() throws InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h);
        IMap map = this.client.getMap("default");
        map.put(1, 1);
        h.shutdown();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                try {
                    DynamicClusterTest.this.client.getCluster().getMembers();
                }
                catch (NoMemberAvailableException e) {
                    latch.countDown();
                }
            }
        }).start();
        latch.await(10L, TimeUnit.SECONDS);
    }

    @Test(timeout=25000L, expected=MemberLeftException.class)
    public void shouldThrowMemberLeftExceptionWhenConnectedMemberDiesWhileExecuting() throws ExecutionException, InterruptedException, IOException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h1, h2);
        Set members = this.client.getCluster().getMembers();
        MultiTask task = new MultiTask((Callable)new SleepCallable(10000L), members);
        this.client.getExecutorService().submit((Runnable)task);
        Thread.sleep(2000L);
        int port = this.client.getConnectionManager().getConnection().getAddress().getPort();
        if (h1.getCluster().getLocalMember().getInetSocketAddress().getPort() == port) {
            h1.shutdown();
        } else {
            h2.shutdown();
        }
        task.get();
    }

    @Test
    public void shouldThrowExecExcWhenConnectedClusterMemberDies() throws ExecutionException, InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h);
        Future future1 = this.client.getExecutorService().submit(new SleepCallable(10000L));
        Future future2 = this.client.getExecutorService().submit(new SleepCallable(10000L));
        Thread.sleep(200L);
        h.shutdown();
        CountDownLatch latch = new CountDownLatch(2);
        try {
            future1.get();
        }
        catch (ExecutionException e) {
            latch.countDown();
        }
        try {
            future2.get();
        }
        catch (ExecutionException e) {
            latch.countDown();
        }
        latch.await(10L, TimeUnit.SECONDS);
        this.client.shutdown();
        this.config.setGroupConfig(new GroupConfig());
    }

    @Test(expected=NoMemberAvailableException.class)
    public void getClusterInFailOver() throws InterruptedException {
        final HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                h.shutdown();
            }
        }).start();
        while (true) {
            Set members = this.client.getCluster().getMembers();
            System.out.println("Members Size: " + members.size());
        }
    }

    private Map<Integer, HazelcastInstance> getMapOfClusterMembers(HazelcastInstance ... h) {
        HashMap<Integer, HazelcastInstance> memberMap = new HashMap<Integer, HazelcastInstance>();
        for (HazelcastInstance hazelcastInstance : h) {
            memberMap.put(hazelcastInstance.getCluster().getLocalMember().getPort(), hazelcastInstance);
        }
        return memberMap;
    }

    @Test
    public void twoClientsAndTransaction() {
        Config config1 = new XmlConfigBuilder().build();
        config1.setProperty("hazelcast.wait.seconds.before.join", "1");
        Config config2 = new XmlConfigBuilder().build();
        config2.setProperty("hazelcast.wait.seconds.before.join", "1");
        GroupConfig gConfig1 = new GroupConfig("g1", "pg1");
        GroupConfig gConfig2 = new GroupConfig("g2", "pg2");
        config1.setGroupConfig(gConfig1);
        config2.setGroupConfig(gConfig2);
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)config1);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)config2);
        HazelcastClient client1 = TestUtility.newHazelcastClient(h1);
        HazelcastClient client2 = TestUtility.newHazelcastClient(h2);
        Transaction t1 = client1.getTransaction();
        Transaction t2 = client2.getTransaction();
        t1.begin();
        client1.getMap("map").put((Object)1, (Object)4);
        t1.commit();
        client1.shutdown();
        client2.shutdown();
        h1.shutdown();
        h2.shutdown();
    }

    @Test
    public void rollbackTransactionWhenClientDies() {
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        HazelcastClient client = TestUtility.newHazelcastClient(h);
        Transaction transaction = client.getTransaction();
        transaction.begin();
        IMap map = client.getMap("rollbackTransactionWhenClientDies");
        map.put("1", "A");
        client.getLifecycleService().shutdown();
        junit.framework.Assert.assertTrue((boolean)h.getMap("rollbackTransactionWhenClientDies").isEmpty());
        h.getMap("rollbackTransactionWhenClientDies").put((Object)"1", (Object)"B");
        junit.framework.Assert.assertEquals((Object)"B", (Object)h.getMap("rollbackTransactionWhenClientDies").get((Object)"1"));
    }

    @Test
    public void multiTaskWithTwoMember() throws ExecutionException, InterruptedException {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        this.client = TestUtility.newHazelcastClient(h2);
        ExecutorService esService = this.client.getExecutorService();
        Set members = this.client.getCluster().getMembers();
        MultiTask task = new MultiTask((Callable)new DistributedMapStatsCallable("default"), members);
        esService.submit((Runnable)task);
        Collection mapStats = null;
        mapStats = task.get();
        for (DistributedMapStatsCallable.MemberMapStat memberMapStat : mapStats) {
            Assert.assertNotNull((Object)memberMapStat);
        }
        junit.framework.Assert.assertEquals((int)members.size(), (int)mapStats.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExecutionException.class)
    public void shouldThrowExceptionWhenCallableThrowsException() throws ExecutionException, InterruptedException {
        HazelcastInstance h1 = null;
        try {
            h1 = Hazelcast.newHazelcastInstance((Config)this.config);
            this.client = TestUtility.newHazelcastClient(h1);
            Set members = this.client.getCluster().getMembers();
            MultiTask task = new MultiTask((Callable)new ExceptionThrowingCallable(), members);
            this.client.getExecutorService().submit((Runnable)task);
            Collection result = null;
            result = task.get();
            junit.framework.Assert.assertEquals((int)members.size(), (int)result.size());
        }
        finally {
            h1.shutdown();
        }
    }

    @Test
    public void testClientHangOnShutdown() throws Exception {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        HazelcastClient client = TestUtility.newHazelcastClient(h);
        final IMap map = client.getMap("default");
        map.lock((Object)"1");
        final CountDownLatch l1 = new CountDownLatch(1);
        final CountDownLatch l2 = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                l1.countDown();
                try {
                    map.lock((Object)"1");
                    Assert.fail((String)"Should not lock!!");
                }
                catch (Exception e) {
                    l2.countDown();
                }
            }
        }).start();
        l1.await(10L, TimeUnit.SECONDS);
        Thread.sleep(5000L);
        h.shutdown();
        junit.framework.Assert.assertTrue((boolean)l2.await(100L, TimeUnit.SECONDS));
    }

    @Test
    public void throwsRuntimeExceptionWhenNoMemberToConnectTrwyWithLocks() {
        try {
            HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)this.config);
            HazelcastInstance h3 = Hazelcast.newHazelcastInstance((Config)this.config);
            IMap realMap = h1.getMap("default");
            Map<Integer, HazelcastInstance> memberMap = this.getMapOfClusterMembers(h1);
            this.client = TestUtility.newHazelcastClient(h1, h3);
            IMap map = this.client.getMap("default");
            realMap.get("currentIteratedKey");
            for (int counter = 0; counter < 2; ++counter) {
                map.put("currentIteratedKey", counter);
                junit.framework.Assert.assertEquals((Object)counter, map.get("currentIteratedKey"));
                junit.framework.Assert.assertEquals((Object)counter, realMap.get("currentIteratedKey"));
                memberMap.get(this.client.getConnectionManager().getConnection().getAddress().getPort()).shutdown();
            }
        }
        catch (Exception e) {
            System.out.println("Here is the exception: " + e);
        }
    }

    @Test
    public void twoQueueInstancesEqual() {
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)new Config());
        this.client = TestUtility.newHazelcastClient(h1);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)this.config);
        IQueue queue = this.client.getQueue("equals");
        junit.framework.Assert.assertEquals((Object)queue, (Object)h2.getQueue("equals"));
    }

    @Test(timeout=30000L)
    public void shutdownClient() throws InterruptedException {
        Thread[] initialThreads = HazelcastClientMapTest.getAllThreads();
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        ClientProperties clientProperties = ClientProperties.crateBaseClientProperties((String)"dev", (String)"dev-pass");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.INIT_CONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_ATTEMPTS_LIMIT, "2");
        clientProperties.setPropertyValue(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT, "500");
        HazelcastClient client = TestUtility.newHazelcastClient(clientProperties, h);
        client.getCluster().getMembers();
        h.shutdown();
        try {
            client.getMap("default").put((Object)"1", (Object)"1");
            Assert.fail();
        }
        catch (NoMemberAvailableException e) {
            // empty catch block
        }
        client.shutdown();
        Thread[] threads = HazelcastClientMapTest.getAllThreads();
        ArrayList<Thread> listOfThreads = new ArrayList<Thread>(Arrays.asList(threads));
        for (Thread thread : initialThreads) {
            listOfThreads.remove(thread);
        }
        boolean fail = false;
        for (Thread t : listOfThreads) {
            if (t == null || !t.getName().startsWith("hz.")) continue;
            System.out.println("Thread is active " + t.getName());
            fail = true;
        }
        Assert.assertFalse((String)"Some threads are still alive", (boolean)fail);
    }

    @Test
    public void lockIMapAndGetInstancesFromClient() throws InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance((Config)this.config);
        IMap iMap = h.getMap("map");
        iMap.put((Object)"key", (Object)"value");
        ILock lock = h.getLock((Object)iMap);
        lock.lock();
        final HazelcastClient client = TestUtility.newHazelcastClient(h);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                client.getInstances();
                latch.countDown();
            }
        }).start();
        junit.framework.Assert.assertTrue((String)"Could not get instances from client", (boolean)latch.await(1L, TimeUnit.SECONDS));
    }

    @Test(timeout=15000L)
    public void mapLockFromClientAndThenCrashClientShouldReleaseLock() {
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        HazelcastClient client = TestUtility.newHazelcastClient(h);
        client.getMap("def").lock((Object)"1");
        client.shutdown();
        h.getMap("def").lock((Object)"1");
        h.shutdown();
    }

    @Test(timeout=15000L)
    public void lockFromClientAndThenCrashClientShouldReleaseLock() {
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        HazelcastClient client = TestUtility.newHazelcastClient(h);
        ILock lock = client.getLock((Object)"1");
        lock.lock();
        client.shutdown();
        h.getLock((Object)"1").lock();
        h.shutdown();
    }

    @Test
    public void clientEndpointShouldbeRemovedAfterClientShutDown() throws InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        junit.framework.Assert.assertEquals((int)0, (int)this.getNumberOfClientsConnected(h));
        for (int i = 0; i < 10; ++i) {
            if (i % 10 == 0) {
                System.out.println(i);
            }
            HazelcastClient client = TestUtility.newHazelcastClient(h);
            System.out.println("Client " + client);
            junit.framework.Assert.assertEquals((int)1, (int)this.getNumberOfClientsConnected(h));
            client.shutdown();
        }
        Thread.sleep(5000L);
        junit.framework.Assert.assertEquals((int)0, (int)this.getNumberOfClientsConnected(h));
        h.shutdown();
    }

    @Test
    public void create10clientsThenShutdownNumberOfConnectedClientsShouldBeZero() throws InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        junit.framework.Assert.assertEquals((int)0, (int)this.getNumberOfClientsConnected(h));
        ArrayList<HazelcastClient> listOfHazelcastClient = new ArrayList<HazelcastClient>();
        for (int i = 0; i < 10; ++i) {
            HazelcastClient client = TestUtility.newHazelcastClient(h);
            listOfHazelcastClient.add(client);
        }
        junit.framework.Assert.assertEquals((int)10, (int)this.getNumberOfClientsConnected(h));
        for (HazelcastClient client : listOfHazelcastClient) {
            client.shutdown();
        }
        Thread.sleep(1000L);
        junit.framework.Assert.assertEquals((int)0, (int)this.getNumberOfClientsConnected(h));
        h.shutdown();
    }

    @Test
    public void afterClientTerminationListenersAttachedByItShouldBeRemovedFromMember() throws InterruptedException {
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        HazelcastClient client = TestUtility.newHazelcastClient(h);
        String mapName = "afterClientTerminationListenersAttachedByItShouldBeRemovedFromMember";
        IMap clientMap = client.getMap(mapName);
        clientMap.addEntryListener((EntryListener)new EntryAdapter(), true);
        IMap map = h.getMap(mapName);
        map.put((Object)"1", (Object)"1");
        Thread.sleep(100L);
        junit.framework.Assert.assertEquals((long)1L, (long)map.getLocalMapStats().getOperationStats().getNumberOfEvents());
        client.shutdown();
        map.put((Object)2, (Object)2);
        Thread.sleep(5000L);
        junit.framework.Assert.assertEquals((long)1L, (long)map.getLocalMapStats().getOperationStats().getNumberOfEvents());
    }

    @Test
    public void oneNode2Clients() throws InterruptedException {
        final AtomicBoolean finished = new AtomicBoolean(false);
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        int threadCount = 2;
        int operationCount = 100;
        final LinkedBlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>();
        for (int i = 0; i < operationCount; ++i) {
            queue.add(i);
        }
        final CountDownLatch latch = new CountDownLatch(operationCount);
        final CountDownLatch startUpLatch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int count = 0;
                    try {
                        HazelcastClient client;
                        System.out.println(Thread.currentThread() + " Running....");
                        AtomicBoolean atomicBoolean = finished;
                        synchronized (atomicBoolean) {
                            client = HazelcastClient.newHazelcastClient((String)"dev", (String)"dev-pass", (String)"localhost");
                        }
                        System.out.println(Thread.currentThread() + " Client init");
                        startUpLatch.countDown();
                        startUpLatch.await();
                        while (!finished.get()) {
                            queue.take();
                            client.getMap("map").put((Object)latch.getCount(), (Object)latch.getCount());
                            ++count;
                            latch.countDown();
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    System.out.println(Thread.currentThread() + "processed: " + count);
                }
            }).start();
        }
        junit.framework.Assert.assertTrue((boolean)latch.await(200L, TimeUnit.SECONDS));
        finished.set(true);
    }

    @Test
    public void perfomanceWithLotsOfExecutingTasks() throws InterruptedException, ExecutionException {
        Config config = new Config();
        config.addExecutorConfig(new ExecutorConfig("esname", 128, 512, 60));
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)config);
        System.out.println("Putting: ");
        for (int i = 0; i < 1000; ++i) {
            IMap map = h1.getMap("myMap");
            map.put(i, new byte[100000]);
        }
        System.out.println("Put finished: ");
        HazelcastClient client = TestUtility.newHazelcastClient(h2);
        ExecutorService executor = client.getExecutorService("esname");
        ConcurrentHashMap<Integer, DistributedTask> taskMap = new ConcurrentHashMap<Integer, DistributedTask>();
        long start = System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 1000; ++i) {
            DistributedTask task = new DistributedTask((Callable)new MyTask(i), (Object)i);
            executor.execute((Runnable)task);
            taskMap.put(i, task);
        }
        int counter = 0;
        for (Integer task : taskMap.keySet()) {
            int x = (Integer)((FutureTask)taskMap.get(task)).get();
            junit.framework.Assert.assertEquals((int)task, (int)x);
            ++counter;
        }
    }

    private int getNumberOfClientsConnected(HazelcastInstance h) {
        FactoryImpl.HazelcastInstanceProxy proxy = (FactoryImpl.HazelcastInstanceProxy)h;
        FactoryImpl factory = (FactoryImpl)proxy.getHazelcastInstance();
        int size = factory.node.clientService.numberOfConnectedClients();
        return size;
    }

    @Test
    public void splitBrain() throws Exception {
        boolean multicast = true;
        Config c1 = new Config();
        c1.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(multicast);
        c1.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(!multicast);
        c1.getNetworkConfig().getJoin().getTcpIpConfig().addMember("127.0.0.1");
        c1.getNetworkConfig().getInterfaces().clear();
        c1.getNetworkConfig().getInterfaces().addInterface("127.0.0.1");
        c1.getNetworkConfig().getInterfaces().setEnabled(true);
        Config c2 = new Config();
        c2.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(multicast);
        c2.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(!multicast);
        c2.getNetworkConfig().getJoin().getTcpIpConfig().addMember("127.0.0.1");
        c2.getNetworkConfig().getInterfaces().clear();
        c2.getNetworkConfig().getInterfaces().addInterface("127.0.0.1");
        c2.getNetworkConfig().getInterfaces().setEnabled(true);
        c1.getGroupConfig().setName("differentGroup");
        c2.getGroupConfig().setName("sameGroup");
        c1.setProperty("hazelcast.merge.first.run.delay.seconds", "5");
        c1.setProperty("hazelcast.merge.next.run.delay.seconds", "3");
        c2.setProperty("hazelcast.merge.first.run.delay.seconds", "5");
        c2.setProperty("hazelcast.merge.next.run.delay.seconds", "3");
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)c1);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)c2);
        HazelcastClient client2 = HazelcastClient.newHazelcastClient((String)c2.getGroupConfig().getName(), (String)c2.getGroupConfig().getPassword(), (String)"127.0.0.1:5702");
        client2.getTopic("def").addMessageListener((MessageListener)new MessageListener<Object>(){

            public void onMessage(Object message) {
            }
        });
        LifecycleCountingListener l = new LifecycleCountingListener();
        h2.getLifecycleService().addLifecycleListener((LifecycleListener)l);
        for (int i = 0; i < 500; ++i) {
            h2.getMap("default").put((Object)i, (Object)("value" + i));
            h2.getMultiMap("default").put((Object)i, (Object)("value" + i));
            h2.getMultiMap("default").put((Object)i, (Object)("value0" + i));
        }
        junit.framework.Assert.assertEquals((int)500, (int)h2.getMap("default").size());
        junit.framework.Assert.assertEquals((int)1000, (int)h2.getMultiMap("default").size());
        junit.framework.Assert.assertEquals((int)1, (int)h1.getCluster().getMembers().size());
        junit.framework.Assert.assertEquals((int)1, (int)h2.getCluster().getMembers().size());
        Thread.sleep(2000L);
        c1.getGroupConfig().setName("sameGroup");
        junit.framework.Assert.assertTrue((boolean)l.waitFor(LifecycleEvent.LifecycleState.RESTARTED, 40));
        junit.framework.Assert.assertEquals((int)1, (int)l.getCount(LifecycleEvent.LifecycleState.RESTARTING));
        junit.framework.Assert.assertEquals((int)1, (int)l.getCount(LifecycleEvent.LifecycleState.RESTARTED));
        junit.framework.Assert.assertEquals((int)2, (int)h1.getCluster().getMembers().size());
        junit.framework.Assert.assertEquals((int)2, (int)h2.getCluster().getMembers().size());
        junit.framework.Assert.assertEquals((int)500, (int)h1.getMap("default").size());
        junit.framework.Assert.assertEquals((int)500, (int)h2.getMap("default").size());
        junit.framework.Assert.assertEquals((int)1000, (int)h2.getMultiMap("default").size());
        junit.framework.Assert.assertEquals((int)1000, (int)h1.getMultiMap("default").size());
        Thread.sleep(10000L);
    }

    class LifecycleCountingListener
    implements LifecycleListener {
        Map<LifecycleEvent.LifecycleState, AtomicInteger> counter = new ConcurrentHashMap<LifecycleEvent.LifecycleState, AtomicInteger>();
        BlockingQueue<LifecycleEvent.LifecycleState> eventQueue = new LinkedBlockingQueue<LifecycleEvent.LifecycleState>();

        LifecycleCountingListener() {
            for (LifecycleEvent.LifecycleState state : LifecycleEvent.LifecycleState.values()) {
                this.counter.put(state, new AtomicInteger(0));
            }
        }

        public void stateChanged(LifecycleEvent event) {
            this.counter.get(event.getState()).incrementAndGet();
            this.eventQueue.offer(event.getState());
        }

        int getCount(LifecycleEvent.LifecycleState state) {
            return this.counter.get(state).get();
        }

        boolean waitFor(LifecycleEvent.LifecycleState state, int seconds) {
            long now;
            for (long remainingMillis = TimeUnit.SECONDS.toMillis(seconds); remainingMillis >= 0L; remainingMillis -= System.currentTimeMillis() - now) {
                LifecycleEvent.LifecycleState received = null;
                try {
                    now = System.currentTimeMillis();
                    received = this.eventQueue.poll(remainingMillis, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MyTask
    extends HazelcastInstanceAwareObject
    implements Callable,
    Serializable {
        final int x;
        byte[] b = new byte[100];
        String str = "asdadsddad";

        public MyTask(int x) {
            this.x = x;
        }

        public Object call() throws Exception {
            IMap map = this.hazelcastInstance.getMap("myMap");
            byte[] value = (byte[])map.get(this.x);
            map.put(this.x, value);
            Thread.sleep(10L);
            return this.x;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExceptionThrowingCallable
    implements Callable<String>,
    Serializable {
        @Override
        public String call() throws Exception {
            throw new RuntimeException("here is an exception");
        }
    }
}

