/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.longrunning;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.ConnectionManager;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientTestBase;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.Packet;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.client.TestUtility;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.impl.ClusterOperation;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastClientPerformanceTest
extends HazelcastClientTestBase {
    @Test
    public void putAndget100000RecordsWith1ClusterMember() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("putAndget100000RecordsWith1ClusterMember");
        this.putAndGet((Map<String, String>)map, 100000);
    }

    private void putAndGet(Map<String, String> map, int counter) {
        int i;
        long beginTime = System.currentTimeMillis();
        for (i = 1; i <= counter; ++i) {
            if (i % (counter / 10) == 0) {
                System.out.println(i + ": " + (System.currentTimeMillis() - beginTime) + " ms");
            }
            map.put("key_" + i, String.valueOf(i));
        }
        beginTime = System.currentTimeMillis();
        for (i = 1; i <= counter; ++i) {
            if (i % (counter / 10) == 0) {
                System.out.println(i + ": " + (System.currentTimeMillis() - beginTime) + " ms");
            }
            Assert.assertEquals((Object)String.valueOf(i), (Object)map.get("key_" + i));
        }
    }

    @Test
    public void putAndget100000RecordsWith1ClusterMemberFrom10Threads() throws InterruptedException {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap map = hClient.getMap("putAndget100000RecordsWith1ClusterMemberFrom10Threads");
        int count = 100000;
        int threads = 16;
        AtomicInteger getCounter = new AtomicInteger(count);
        final AtomicInteger putCounter = new AtomicInteger(count);
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        long beginTime = System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(threads);
        for (int i = 0; i < threads; ++i) {
            executorService.execute(new Runnable((Map)map, getCounter, latch){
                final /* synthetic */ Map val$map;
                final /* synthetic */ AtomicInteger val$getCounter;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$map = map;
                    this.val$getCounter = atomicInteger2;
                    this.val$latch = countDownLatch;
                }

                public void run() {
                    int i;
                    while ((i = putCounter.getAndDecrement()) > 0) {
                        this.val$map.put("key_" + i, String.valueOf(i));
                    }
                    while ((i = this.val$getCounter.getAndDecrement()) > 0) {
                        this.val$map.get("key_" + i);
                    }
                    this.val$latch.countDown();
                }
            });
        }
        latch.await();
        System.out.println(threads + " Threads made in total " + count + " puts and gets in " + (System.currentTimeMillis() - beginTime) + " ms");
    }

    @Test
    public void putFromMultipleThreads() throws InterruptedException {
        final HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        final AtomicInteger counter = new AtomicInteger(0);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Putter
        implements Runnable {
            volatile Boolean run = true;

            Putter() {
            }

            @Override
            public void run() {
                HazelcastClient hClient = TestUtility.newHazelcastClient(h);
                while (this.run.booleanValue()) {
                    IMap clientMap = hClient.getMap("putFromMultipleThreads");
                    clientMap.put(String.valueOf(counter.incrementAndGet()), String.valueOf(counter.get()));
                }
            }
        }
        ArrayList<Putter> list = new ArrayList<Putter>();
        for (int i = 0; i < 10; ++i) {
            Putter p = new Putter();
            list.add(p);
            new Thread(p).start();
        }
        Thread.sleep(5000L);
        for (Putter p : list) {
            p.run = false;
        }
        Thread.sleep(100L);
        Assert.assertEquals((long)counter.get(), (long)h.getMap("putFromMultipleThreads").size());
    }

    @Test
    public void putBigObject() {
        HazelcastClient hClient = this.getHazelcastClient();
        IMap clientMap = hClient.getMap("putABigObject");
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int size = 10000000;
        byte[] b = new byte[size];
        b[size - 1] = -112;
        list.add(b);
        clientMap.put("obj", b);
        byte[] bigB = (byte[])clientMap.get("obj");
        Assert.assertTrue((boolean)Arrays.equals(b, bigB));
        Assert.assertEquals((long)size, (long)bigB.length);
    }

    @Test
    @Ignore
    public void testOutThreadPerformance() throws IOException, InterruptedException {
        new Thread(new Runnable(){

            public void run() {
                ServerSocket serverSocket = null;
                try {
                    serverSocket = new ServerSocket(5799);
                }
                catch (IOException e) {
                    System.out.println("Could not listen on port: 4444");
                    System.exit(-1);
                }
                Socket clientSocket = null;
                try {
                    clientSocket = serverSocket.accept();
                    byte[] bytes = new byte[1000000];
                    while (true) {
                        clientSocket.getInputStream().read(bytes);
                    }
                }
                catch (IOException e) {
                    System.out.println("Accept failed: 4444");
                    System.exit(-1);
                    return;
                }
            }
        }).start();
        HazelcastClient client = (HazelcastClient)Mockito.mock(HazelcastClient.class);
        ConnectionManager connectionManager = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        Mockito.when((Object)client.getConnectionManager()).thenReturn((Object)connectionManager);
        Connection connection = new Connection("localhost", 5799, 1);
        Mockito.when((Object)connectionManager.getConnection()).thenReturn((Object)connection);
        PacketWriter packetWriter = new PacketWriter();
        packetWriter.setConnection(connection);
        final OutRunnable outRunnable = new OutRunnable(client, new HashMap(), packetWriter);
        new Thread((Runnable)outRunnable).start();
        final AtomicLong callCounter = new AtomicLong();
        final long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        final Object object = new Object();
        for (int i = 0; i < 16; ++i) {
            executorService.execute(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            queue.take();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Packet packet = new Packet();
                        packet.set("c:default", ClusterOperation.CONCURRENT_MAP_GET, new byte[30], null);
                        Call call = new Call(Long.valueOf(callCounter.incrementAndGet()), packet);
                        outRunnable.enQueue(call);
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            public void run() {
                int numberOfTasks = 10000;
                while (true) {
                    try {
                        while (true) {
                            for (int i = 0; i < numberOfTasks; ++i) {
                                queue.offer(object);
                            }
                            Thread.sleep(1000L);
                            System.out.println("Operations per millisecond : " + callCounter.get() / (System.currentTimeMillis() - start));
                            System.out.println("out runnable Queue size: " + outRunnable.getQueueSize());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        Thread.sleep(1000000L);
    }

    @AfterClass
    @BeforeClass
    public static void shutdown() {
    }
}

