/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.longrunning;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleMapTestFromClient {
    public static int THREAD_COUNT = 40;
    public static int ENTRY_COUNT = 10000;
    public static int VALUE_SIZE = 1000;
    public static final int STATS_SECONDS = 10;
    public static int GET_PERCENTAGE = 40;
    public static int PUT_PERCENTAGE = 40;

    public static void main(String[] args) {
        HazelcastInstance h = Hazelcast.newHazelcastInstance(null);
        HazelcastClient hazelcast = HazelcastClient.newHazelcastClient((String)h.getConfig().getGroupConfig().getName(), (String)h.getConfig().getGroupConfig().getPassword(), (boolean)false, (InetSocketAddress[])new InetSocketAddress[]{h.getCluster().getLocalMember().getInetSocketAddress()});
        Stats stats = new Stats();
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if ((arg = arg.trim()).startsWith("t")) {
                    THREAD_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("c")) {
                    ENTRY_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("v")) {
                    VALUE_SIZE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("g")) {
                    GET_PERCENTAGE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (!arg.startsWith("p")) continue;
                PUT_PERCENTAGE = Integer.parseInt(arg.substring(1));
            }
        } else {
            System.out.println("Help: sh test.sh t200 v130 p10 g85 ");
            System.out.println("    // means 200 threads, value-size 130 bytes, 10% put, 85% get");
            System.out.println("");
        }
        System.out.println("Starting Test with ");
        System.out.println("      Thread Count: " + THREAD_COUNT);
        System.out.println("       Entry Count: " + ENTRY_COUNT);
        System.out.println("        Value Size: " + VALUE_SIZE);
        System.out.println("    Get Percentage: " + GET_PERCENTAGE);
        System.out.println("    Put Percentage: " + PUT_PERCENTAGE);
        System.out.println(" Remove Percentage: " + (100 - (PUT_PERCENTAGE + GET_PERCENTAGE)));
        ExecutorService es = Executors.newFixedThreadPool(THREAD_COUNT);
        for (int i = 0; i < THREAD_COUNT; ++i) {
            es.submit(new Runnable((HazelcastInstance)hazelcast, stats){
                final /* synthetic */ HazelcastInstance val$hazelcast;
                final /* synthetic */ Stats val$stats;
                {
                    this.val$hazelcast = hazelcastInstance;
                    this.val$stats = stats;
                }

                public void run() {
                    IMap map = this.val$hazelcast.getMap("default");
                    while (true) {
                        int key = (int)(Math.random() * (double)ENTRY_COUNT);
                        int operation = (int)(Math.random() * 100.0);
                        if (operation < GET_PERCENTAGE) {
                            map.get((Object)String.valueOf(key));
                            this.val$stats.gets.incrementAndGet();
                            continue;
                        }
                        if (operation < GET_PERCENTAGE + PUT_PERCENTAGE) {
                            map.put((Object)String.valueOf(key), (Object)new byte[VALUE_SIZE]);
                            this.val$stats.puts.incrementAndGet();
                            continue;
                        }
                        map.remove((Object)String.valueOf(key));
                        this.val$stats.removes.incrementAndGet();
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().submit(new Runnable((HazelcastInstance)hazelcast, stats){
            final /* synthetic */ HazelcastInstance val$hazelcast;
            final /* synthetic */ Stats val$stats;
            {
                this.val$hazelcast = hazelcastInstance;
                this.val$stats = stats;
            }

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                            System.out.println("cluster size:" + this.val$hazelcast.getCluster().getMembers().size());
                            Stats currentStats = this.val$stats.getAndReset();
                            System.out.println(currentStats);
                            System.out.println("Operations per Second : " + currentStats.total() / 10L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public static class Stats {
        public AtomicLong puts = new AtomicLong();
        public AtomicLong gets = new AtomicLong();
        public AtomicLong removes = new AtomicLong();

        public Stats getAndReset() {
            long putsNow = this.puts.getAndSet(0L);
            long getsNow = this.gets.getAndSet(0L);
            long removesNow = this.removes.getAndSet(0L);
            Stats newOne = new Stats();
            newOne.puts.set(putsNow);
            newOne.gets.set(getsNow);
            newOne.removes.set(removesNow);
            return newOne;
        }

        public long total() {
            return this.puts.get() + this.gets.get() + this.removes.get();
        }

        public String toString() {
            return "total= " + this.total() + ", gets:" + this.gets.get() + ", puts: " + this.puts.get() + ", removes:" + this.removes.get();
        }
    }
}

