/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.utility;

import com.hazelcast.aws.utility.AwsURLEncoder;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CloudyUtility {
    static final ILogger logger = Logger.getLogger((String)CloudyUtility.class.getName());

    public static String getQueryString(Map<String, String> attributes) {
        StringBuilder query = new StringBuilder();
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            query.append(AwsURLEncoder.urlEncode(key)).append("=").append(AwsURLEncoder.urlEncode(value)).append("&");
        }
        String result = query.toString();
        if (result != null && !result.equals("")) {
            result = "?" + result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Object unmarshalTheResponse(InputStream stream, AwsConfig awsConfig) throws IOException {
        Object o = CloudyUtility.parse(stream, awsConfig);
        return o;
    }

    private static Object parse(InputStream in, AwsConfig awsConfig) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            Element element = doc.getDocumentElement();
            NodeHolder elementNodeHolder = new NodeHolder(element);
            ArrayList<String> names = new ArrayList<String>();
            List<NodeHolder> reservationset = elementNodeHolder.getSubNodes("reservationset");
            for (NodeHolder reservation : reservationset) {
                List<NodeHolder> items = reservation.getSubNodes("item");
                for (NodeHolder item : items) {
                    NodeHolder instancesset = item.getSub("instancesset");
                    names.addAll(instancesset.getList("privateipaddress", awsConfig));
                }
            }
            return names;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), (Throwable)e);
            return new ArrayList();
        }
    }

    static class NodeHolder {
        Node node;

        public NodeHolder(Node node) {
            this.node = node;
        }

        public NodeHolder getSub(String name) {
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName((String)node.getNodeName());
                    if (!name.equals(nodeName)) continue;
                    return new NodeHolder(node);
                }
            }
            return new NodeHolder(null);
        }

        public List<NodeHolder> getSubNodes(String name) {
            ArrayList<NodeHolder> list = new ArrayList<NodeHolder>();
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName((String)node.getNodeName());
                    if (!name.equals(nodeName)) continue;
                    list.add(new NodeHolder(node));
                }
            }
            return list;
        }

        public List<String> getList(String name, AwsConfig awsConfig) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName((String)node.getNodeName());
                    if (!"item".equals(nodeName) || !new NodeHolder(node).getSub("instancestate").getSub("name").getNode().getFirstChild().getNodeValue().equals("running")) continue;
                    String ip = new NodeHolder(node).getSub(name).getNode().getFirstChild().getNodeValue();
                    boolean passed = this.applyFilter(awsConfig, node);
                    if (ip == null || !passed) continue;
                    list.add(ip);
                }
            }
            return list;
        }

        private boolean applyFilter(AwsConfig awsConfig, Node node) {
            boolean inGroup = this.applyFilter(node, awsConfig.getSecurityGroupName(), "groupset", "groupname");
            return inGroup && this.applyTagFilter(node, awsConfig.getTagKey(), awsConfig.getTagValue());
        }

        private boolean applyFilter(Node node, String filter, String set, String filterField) {
            boolean passed = this.nullOrEmpty(filter);
            if (!passed) {
                for (NodeHolder group : new NodeHolder(node).getSub(set).getSubNodes("item")) {
                    NodeHolder nh = group.getSub(filterField);
                    if (nh == null || nh.getNode().getFirstChild() == null || !filter.equals(nh.getNode().getFirstChild().getNodeValue())) continue;
                    passed = true;
                }
            }
            return passed;
        }

        private boolean applyTagFilter(Node node, String keyExpected, String valueExpected) {
            if (this.nullOrEmpty(keyExpected)) {
                return true;
            }
            for (NodeHolder group : new NodeHolder(node).getSub("tagset").getSubNodes("item")) {
                if (!this.keyEquals(keyExpected, group) || !this.nullOrEmpty(valueExpected) && !this.valueEquals(valueExpected, group)) continue;
                return true;
            }
            return false;
        }

        private boolean valueEquals(String valueExpected, NodeHolder group) {
            NodeHolder nhValue = group.getSub("value");
            return nhValue != null && nhValue.getNode().getFirstChild() != null && valueExpected.equals(nhValue.getNode().getFirstChild().getNodeValue());
        }

        private boolean nullOrEmpty(String keyExpected) {
            return keyExpected == null || keyExpected.equals("");
        }

        private boolean keyEquals(String keyExpected, NodeHolder group) {
            NodeHolder nhKey = group.getSub("key");
            return nhKey != null && nhKey.getNode().getFirstChild() != null && keyExpected.equals(nhKey.getNode().getFirstChild().getNodeValue());
        }

        public Node getNode() {
            return this.node;
        }
    }
}

