/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.config;

import com.hazelcast.test.annotation.QuickTest;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.springframework.util.ResourceUtils;

@RunWith(value=JUnit4.class)
@Category(value={QuickTest.class})
public class SpringSchemasValidityTest {
    private Properties prop;

    @Before
    public void loadSpringSchemas() throws Exception {
        this.prop = new Properties();
        this.prop.load(new FileInputStream(ResourceUtils.getFile((String)"classpath:META-INF/spring.schemas")));
    }

    @Test
    public void testAllXSDsAvailable() throws Exception {
        Collection<Object> values = this.prop.values();
        HashSet<String> allXSDs = new HashSet<String>();
        for (Object o : values) {
            allXSDs.add(o.toString());
        }
        for (String xsd : allXSDs) {
            Assert.assertTrue((boolean)ResourceUtils.getFile((String)("classpath:" + xsd)).exists());
        }
    }

    @Test
    public void testUrlMatchesXSD() {
        Set<String> names = this.prop.stringPropertyNames();
        for (String name : names) {
            if (name.endsWith("spring.xsd")) continue;
            Assert.assertTrue((boolean)name.endsWith(this.prop.getProperty(name)));
        }
    }

    @Test
    public void testPermaLinkIsLatestVersion() {
        Pattern pattern = Pattern.compile("hazelcast-spring-([0-9\\.]+)\\.xsd");
        ComparableVersion latestVersion = null;
        String latestVersionXsdFile = null;
        for (Object o : this.prop.values()) {
            String xsd = o.toString();
            Matcher matcher = pattern.matcher(xsd);
            Assert.assertTrue((boolean)matcher.matches());
            String versionCode = matcher.group(1);
            if (latestVersion == null) {
                latestVersion = new ComparableVersion(versionCode);
                latestVersionXsdFile = xsd;
                continue;
            }
            ComparableVersion current = new ComparableVersion(versionCode);
            if (current.compareTo(latestVersion) <= 0) continue;
            latestVersion = current;
            latestVersionXsdFile = xsd;
        }
        String latestBySpringSchemas = this.prop.getProperty("https://www.hazelcast.com/schema/spring/hazelcast-spring.xsd");
        Assert.assertEquals(latestVersionXsdFile, (Object)latestBySpringSchemas);
    }

    @Test
    public void testBothHttpAndHttpsAvailable() {
        Set<String> allURLs = this.prop.stringPropertyNames();
        HashSet<String> http = new HashSet<String>();
        HashSet<String> https = new HashSet<String>();
        for (String url : allURLs) {
            if (url.startsWith("https")) {
                https.add(url);
                continue;
            }
            if (url.startsWith("http")) {
                http.add(url);
                continue;
            }
            Assert.fail((String)(url + " does not start with http or https"));
        }
        Assert.assertEquals((long)http.size(), (long)https.size());
        for (String s : https) {
            Assert.assertTrue((boolean)http.contains("http" + s.substring(5)));
        }
        for (String s : http) {
            Assert.assertTrue((boolean)https.contains("https" + s.substring(4)));
        }
    }
}

