/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.config;

import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.CompactSerializationConfigAccessor;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import com.hazelcast.spring.config.ConfigFactory;
import java.io.Serializable;
import java.util.HashMap;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;

public class ConfigFactoryTest {
    private static final EvictionPolicyComparator dummyComparator = (EvictionPolicyComparator & Serializable)(o1, o2) -> 0;
    private static final String SOME_COMPARATOR_CLASS_NAME = dummyComparator.getClass().getName();

    @Test
    public void should_create_eviction_config() {
        EvictionConfig evictionConfig = ConfigFactory.newEvictionConfig((Integer)42, (MaxSizePolicy)MaxSizePolicy.PER_NODE, (EvictionPolicy)EvictionPolicy.LRU, (boolean)false, (boolean)false, null, (EvictionPolicyComparator)dummyComparator);
        AssertionsForClassTypes.assertThat((int)evictionConfig.getSize()).isEqualTo(42);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getMaxSizePolicy()).isEqualTo((Object)MaxSizePolicy.PER_NODE);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getEvictionPolicy()).isEqualTo((Object)EvictionPolicy.LRU);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getComparator()).isSameAs((Object)dummyComparator);
    }

    @Test
    public void should_create_eviction_config_with_comparator_class_name() {
        EvictionConfig evictionConfig = ConfigFactory.newEvictionConfig((Integer)42, (MaxSizePolicy)MaxSizePolicy.PER_NODE, (EvictionPolicy)EvictionPolicy.LRU, (boolean)false, (boolean)false, (String)SOME_COMPARATOR_CLASS_NAME, null);
        AssertionsForClassTypes.assertThat((String)evictionConfig.getComparatorClassName()).isEqualTo(SOME_COMPARATOR_CLASS_NAME);
    }

    @Test
    public void should_use_default_map_max_size_for_null_size() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfig(null, true);
        AssertionsForClassTypes.assertThat((int)evictionConfig.getSize()).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    public void should_use_default_map_max_size_for_0_size() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfig(0, true);
        AssertionsForClassTypes.assertThat((int)evictionConfig.getSize()).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    public void should_use_default_cache_max_size_for_null_size() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfig(null, false);
        AssertionsForClassTypes.assertThat((int)evictionConfig.getSize()).isEqualTo(10000);
    }

    @Test
    public void should_use_provided_eviction_policy() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfigWithEvictionPolicy(EvictionPolicy.LRU, false);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getEvictionPolicy()).isEqualTo((Object)EvictionPolicy.LRU);
    }

    @Test
    public void should_use_default_map_eviction_policy() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfigWithEvictionPolicy(null, true);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getEvictionPolicy()).isEqualTo((Object)MapConfig.DEFAULT_EVICTION_POLICY);
    }

    @Test
    public void should_use_default_cache_eviction_policy() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfigWithEvictionPolicy(null, false);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getEvictionPolicy()).isEqualTo((Object)EvictionConfig.DEFAULT_EVICTION_POLICY);
    }

    @Test
    public void should_use_provided_max_size_policy() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfigWithMaxSizePolicy(MaxSizePolicy.PER_NODE, false);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getMaxSizePolicy()).isEqualTo((Object)MaxSizePolicy.PER_NODE);
    }

    @Test
    public void should_use_default_cache_max_size_policy() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfigWithMaxSizePolicy(null, false);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getMaxSizePolicy()).isEqualTo((Object)EvictionConfig.DEFAULT_MAX_SIZE_POLICY);
    }

    @Test
    public void should_use_default_map_max_size_policy() {
        EvictionConfig evictionConfig = ConfigFactoryTest.newEvictionConfigWithMaxSizePolicy(null, true);
        AssertionsForClassTypes.assertThat((Object)evictionConfig.getMaxSizePolicy()).isEqualTo((Object)MapConfig.DEFAULT_MAX_SIZE_POLICY);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void should_perform_checks_for_common_eviction_config() {
        ConfigFactoryTest.invalidEvictionConfig(false, false);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void should_perform_checks_for_cache_eviction_config() {
        ConfigFactoryTest.invalidEvictionConfig(true, true);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void should_perform_checks_for_map_eviction_config() {
        ConfigFactoryTest.invalidEvictionConfig(false, true);
    }

    @Test
    public void should_create_compact_serialization_config() {
        HashMap<String, TriTuple> registrations = new HashMap<String, TriTuple>();
        TriTuple registration = TriTuple.of((Object)"a", (Object)"b", (Object)"c");
        registrations.put("b", registration);
        CompactSerializationConfig config = ConfigFactory.newCompactSerializationConfig((boolean)true, registrations);
        AssertionsForClassTypes.assertThat((boolean)config.isEnabled()).isTrue();
        AssertionsForClassTypes.assertThat((Object)CompactSerializationConfigAccessor.getNamedRegistrations((CompactSerializationConfig)config)).isEqualTo(registrations);
    }

    @Test
    public void should_create_compact_serialization_config_with_reflective_serializer() {
        HashMap<String, TriTuple> registrations = new HashMap<String, TriTuple>();
        TriTuple registration = TriTuple.of((Object)"a", (Object)"a", null);
        registrations.put("a", registration);
        CompactSerializationConfig config = ConfigFactory.newCompactSerializationConfig((boolean)true, registrations);
        AssertionsForClassTypes.assertThat((boolean)config.isEnabled()).isTrue();
        AssertionsForClassTypes.assertThat((Object)CompactSerializationConfigAccessor.getNamedRegistrations((CompactSerializationConfig)config)).isEqualTo(registrations);
    }

    private static void invalidEvictionConfig(boolean isNearCache, boolean isIMap) {
        ConfigFactory.newEvictionConfig(null, null, null, (boolean)isNearCache, (boolean)isIMap, (String)SOME_COMPARATOR_CLASS_NAME, (EvictionPolicyComparator)dummyComparator);
    }

    private static EvictionConfig newEvictionConfigWithMaxSizePolicy(MaxSizePolicy maxSizePolicy, boolean isIMap) {
        return ConfigFactory.newEvictionConfig(null, (MaxSizePolicy)maxSizePolicy, null, (boolean)false, (boolean)isIMap, null, null);
    }

    private static EvictionConfig newEvictionConfigWithEvictionPolicy(EvictionPolicy evictionPolicy, boolean isIMap) {
        return ConfigFactory.newEvictionConfig(null, (MaxSizePolicy)MaxSizePolicy.PER_NODE, (EvictionPolicy)evictionPolicy, (boolean)false, (boolean)isIMap, null, null);
    }

    private static EvictionConfig newEvictionConfig(Integer maxSize, boolean isIMap) {
        return ConfigFactory.newEvictionConfig((Integer)maxSize, (MaxSizePolicy)MaxSizePolicy.PER_NODE, (EvictionPolicy)EvictionPolicy.LRU, (boolean)false, (boolean)isIMap, null, null);
    }
}

