/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.as2client;

import com.helger.as2lib.client.AS2Client;
import com.helger.as2lib.client.AS2ClientRequest;
import com.helger.as2lib.client.AS2ClientResponse;
import com.helger.as2lib.client.AS2ClientSettings;
import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.disposition.DispositionOptions;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CCharset;
import com.helger.commons.email.EmailAddressHelper;
import com.helger.commons.factory.FactoryNewInstance;
import com.helger.commons.factory.IFactory;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.commons.xml.serialize.read.DOMReader;
import com.helger.peppol.as2client.AS2ClientBuilderException;
import com.helger.peppol.as2client.AS2ClientHelper;
import com.helger.peppol.as2client.DefaultAS2ClientBuilderMessageHandler;
import com.helger.peppol.as2client.IAS2ClientBuilderMessageHandler;
import com.helger.peppol.identifier.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.IIdentifier;
import com.helger.peppol.identifier.IParticipantIdentifier;
import com.helger.peppol.identifier.IProcessIdentifier;
import com.helger.peppol.identifier.IdentifierHelper;
import com.helger.peppol.sbdh.PeppolSBDHDocument;
import com.helger.peppol.sbdh.write.PeppolSBDHDocumentWriter;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.EndpointType;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppol.smpclient.SMPClientReadOnly;
import com.helger.peppol.smpclient.exception.SMPClientException;
import com.helger.sbdh.SBDMarshaller;
import java.io.File;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@NotThreadSafe
public class AS2ClientBuilder {
    public static final String DEFAULT_AS2_SUBJECT = "OpenPEPPOL AS2 message";
    public static final ECryptoAlgorithmSign DEFAULT_SIGNING_ALGORITHM = ECryptoAlgorithmSign.DIGEST_SHA1;
    public static final String DEFAULT_AS2_MESSAGE_ID_FORMAT = "OpenPEPPOL-$date.ddMMyyyyHHmmssZ$-$rand.1234$@$msg.sender.as2_id$_$msg.receiver.as2_id$";
    private static final Logger s_aLogger = LoggerFactory.getLogger(AS2ClientBuilder.class);
    private IAS2ClientBuilderMessageHandler m_aMessageHandler = new DefaultAS2ClientBuilderMessageHandler();
    private File m_aKeyStoreFile;
    private String m_sKeyStorePassword;
    private String m_sAS2Subject = "OpenPEPPOL AS2 message";
    private String m_sSenderAS2ID;
    private String m_sSenderAS2Email;
    private String m_sSenderAS2KeyAlias;
    private String m_sReceiverAS2ID;
    private String m_sReceiverAS2KeyAlias;
    private String m_sReceiverAS2Url;
    private X509Certificate m_aReceiverCert;
    private ECryptoAlgorithmSign m_eSigningAlgo = DEFAULT_SIGNING_ALGORITHM;
    private String m_sMessageIDFormat = "OpenPEPPOL-$date.ddMMyyyyHHmmssZ$-$rand.1234$@$msg.sender.as2_id$_$msg.receiver.as2_id$";
    private IReadableResource m_aBusinessDocumentRes;
    private Element m_aBusinessDocumentElement;
    private IParticipantIdentifier m_aPeppolSenderID;
    private IParticipantIdentifier m_aPeppolReceiverID;
    private IDocumentTypeIdentifier m_aPeppolDocumentTypeID;
    private IProcessIdentifier m_aPeppolProcessID;
    private SMPClientReadOnly m_aSMPClient;
    private IFactory<AS2Client> m_aAS2ClientFactory = FactoryNewInstance.create(AS2Client.class, (boolean)true);

    @Nonnull
    protected final IAS2ClientBuilderMessageHandler getMessageHandler() {
        return this.m_aMessageHandler;
    }

    @Nonnull
    public AS2ClientBuilder setMessageHandler(@Nonnull IAS2ClientBuilderMessageHandler iAS2ClientBuilderMessageHandler) {
        this.m_aMessageHandler = (IAS2ClientBuilderMessageHandler)ValueEnforcer.notNull((Object)iAS2ClientBuilderMessageHandler, (String)"MessageHandler");
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setPKCS12KeyStore(@Nullable File file, @Nullable String string) {
        this.m_aKeyStoreFile = file;
        this.m_sKeyStorePassword = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setAS2Subject(@Nullable String string) {
        this.m_sAS2Subject = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setSenderAS2ID(@Nullable String string) {
        this.m_sSenderAS2ID = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setSenderAS2Email(@Nullable String string) {
        this.m_sSenderAS2Email = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setSenderAS2KeyAlias(@Nullable String string) {
        this.m_sSenderAS2KeyAlias = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setReceiverAS2ID(@Nullable String string) {
        this.m_sReceiverAS2ID = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setReceiverAS2KeyAlias(@Nullable String string) {
        this.m_sReceiverAS2KeyAlias = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setReceiverAS2Url(@Nullable String string) {
        this.m_sReceiverAS2Url = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setReceiverCertificate(@Nullable X509Certificate x509Certificate) {
        this.m_aReceiverCert = x509Certificate;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setAS2SigningAlgorithm(@Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        this.m_eSigningAlgo = eCryptoAlgorithmSign;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setAS2MessageIDFormat(@Nullable String string) {
        this.m_sMessageIDFormat = string;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setBusinessDocument(@Nonnull File file) {
        return this.setBusinessDocument((IReadableResource)new FileSystemResource(file));
    }

    @Nonnull
    public AS2ClientBuilder setBusinessDocument(@Nonnull byte[] byArray) {
        return this.setBusinessDocument((IReadableResource)new ReadableResourceByteArray(byArray));
    }

    @Nonnull
    public AS2ClientBuilder setBusinessDocument(@Nullable IReadableResource iReadableResource) {
        this.m_aBusinessDocumentRes = iReadableResource;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setBusinessDocument(@Nullable Element element) {
        this.m_aBusinessDocumentElement = element;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setPeppolSenderID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        this.m_aPeppolSenderID = iParticipantIdentifier;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setPeppolReceiverID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        this.m_aPeppolReceiverID = iParticipantIdentifier;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setPeppolDocumentTypeID(@Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        this.m_aPeppolDocumentTypeID = iDocumentTypeIdentifier;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setPeppolProcessID(@Nullable IProcessIdentifier iProcessIdentifier) {
        this.m_aPeppolProcessID = iProcessIdentifier;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setSMPClient(@Nullable SMPClientReadOnly sMPClientReadOnly) {
        this.m_aSMPClient = sMPClientReadOnly;
        return this;
    }

    @Nonnull
    public AS2ClientBuilder setAS2ClientFactory(@Nonnull IFactory<AS2Client> iFactory) {
        this.m_aAS2ClientFactory = (IFactory)ValueEnforcer.notNull(iFactory, (String)"AS2ClientFactory");
        return this;
    }

    protected void performSMPClientLookup() throws AS2ClientBuilderException {
        if (this.m_aSMPClient != null) {
            if (this.m_aPeppolReceiverID == null) {
                this.getMessageHandler().warn("Cannot perform SMP lookup because the PEPPOL receiver ID is missing");
            } else if (this.m_aPeppolDocumentTypeID == null) {
                this.getMessageHandler().warn("Cannot perform SMP lookup because the PEPPOL document type ID is missing");
            } else if (this.m_aPeppolProcessID == null) {
                this.getMessageHandler().warn("Cannot perform SMP lookup because the PEPPOL process ID is missing");
            } else if (this.m_sReceiverAS2Url == null || this.m_aReceiverCert == null || this.m_sReceiverAS2ID == null) {
                EndpointType endpointType;
                block22: {
                    endpointType = null;
                    try {
                        if (s_aLogger.isDebugEnabled()) {
                            s_aLogger.debug("Performing SMP lookup for receiver '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolReceiverID) + "' on document type '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolDocumentTypeID) + "' and process ID '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolProcessID) + "' using transport profile for AS2");
                        }
                        endpointType = this.m_aSMPClient.getEndpoint(this.m_aPeppolReceiverID, this.m_aPeppolDocumentTypeID, this.m_aPeppolProcessID, (ISMPTransportProfile)ESMPTransportProfile.TRANSPORT_PROFILE_AS2);
                    }
                    catch (SMPClientException sMPClientException) {
                        if (!s_aLogger.isDebugEnabled()) break block22;
                        s_aLogger.debug("Error querying SMP", (Throwable)sMPClientException);
                    }
                }
                if (endpointType == null) {
                    this.getMessageHandler().warn("Failed to perform SMP lookup for receiver '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolReceiverID) + "' on document type '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolDocumentTypeID) + "' and process ID '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolProcessID) + "' using transport profile for AS2");
                } else {
                    if (this.m_sReceiverAS2Url == null) {
                        this.m_sReceiverAS2Url = SMPClientReadOnly.getEndpointAddress(endpointType);
                    }
                    if (this.m_aReceiverCert == null) {
                        try {
                            this.m_aReceiverCert = SMPClientReadOnly.getEndpointCertificate((EndpointType)endpointType);
                        }
                        catch (CertificateException certificateException) {
                            this.getMessageHandler().error("Failed to build X.509 certificate from SMP client response", certificateException);
                        }
                    }
                    if (this.m_sReceiverAS2ID == null) {
                        try {
                            this.m_sReceiverAS2ID = AS2ClientHelper.getSubjectCommonName(this.m_aReceiverCert);
                        }
                        catch (CertificateException certificateException) {
                            this.getMessageHandler().error("Failed to get the Receiver AS ID from the provided certificate", certificateException);
                        }
                    }
                }
            } else if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Not performing SMP lookup because all target fields are already set!");
            }
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void setDefaultDerivedValues() {
        if (this.m_sReceiverAS2KeyAlias == null) {
            this.m_sReceiverAS2KeyAlias = this.m_sReceiverAS2ID;
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("The receiver AS2 key alias was defaulted to the AS2 receiver ID");
            }
        }
    }

    public void verifyContent() throws AS2ClientBuilderException {
        if (this.m_aKeyStoreFile == null) {
            this.m_aMessageHandler.error("No AS2 key store is defined");
        } else if (!this.m_aKeyStoreFile.exists()) {
            this.m_aMessageHandler.error("The provided AS2 key store '" + this.m_aKeyStoreFile.getAbsolutePath() + "' does not exist.");
        } else if (!this.m_aKeyStoreFile.isFile()) {
            this.m_aMessageHandler.error("The provided AS2 key store '" + this.m_aKeyStoreFile.getAbsolutePath() + "' is not a file but potentially a directory.");
        }
        if (this.m_sKeyStorePassword == null) {
            this.m_aMessageHandler.error("No key store password provided. If you need an empty password, please provide an empty String!");
        }
        if (StringHelper.hasNoText((String)this.m_sAS2Subject)) {
            this.m_aMessageHandler.error("The AS2 message subject is missing");
        }
        if (StringHelper.hasNoText((String)this.m_sSenderAS2ID)) {
            this.m_aMessageHandler.error("The AS2 sender ID is missing");
        } else if (!this.m_sSenderAS2ID.startsWith("APP_")) {
            this.m_aMessageHandler.warn("The AS2 sender ID '" + this.m_sSenderAS2ID + "' should start with 'APP_' as required by the PEPPOL specification");
        }
        if (StringHelper.hasNoText((String)this.m_sSenderAS2Email)) {
            this.m_aMessageHandler.error("The AS2 sender email address is missing");
        } else if (!EmailAddressHelper.isValid((String)this.m_sSenderAS2Email)) {
            this.m_aMessageHandler.warn("The AS2 sender email address '" + this.m_sSenderAS2Email + "' seems to be an invalid email address.");
        }
        if (StringHelper.hasNoText((String)this.m_sSenderAS2KeyAlias)) {
            this.m_aMessageHandler.error("The AS2 sender key alias is missing");
        } else if (!this.m_sSenderAS2KeyAlias.startsWith("APP_")) {
            this.m_aMessageHandler.warn("The AS2 sender key alias '" + this.m_sSenderAS2KeyAlias + "' should start with 'APP_' for the use with the dynamic AS2 partnerships");
        } else if (this.m_sSenderAS2ID != null && !this.m_sSenderAS2ID.equals(this.m_sSenderAS2KeyAlias)) {
            this.m_aMessageHandler.warn("The AS2 sender key alias ('" + this.m_sSenderAS2KeyAlias + "') should match the AS2 sender ID ('" + this.m_sSenderAS2ID + "')");
        }
        if (StringHelper.hasNoText((String)this.m_sReceiverAS2ID)) {
            this.m_aMessageHandler.error("The AS2 receiver ID is missing");
        } else if (!this.m_sReceiverAS2ID.startsWith("APP_")) {
            this.m_aMessageHandler.warn("The AS2 receiver ID '" + this.m_sReceiverAS2ID + "' should start with 'APP_' as required by the PEPPOL specification");
        }
        if (StringHelper.hasNoText((String)this.m_sReceiverAS2KeyAlias)) {
            this.m_aMessageHandler.error("The AS2 receiver key alias is missing");
        } else if (!this.m_sReceiverAS2KeyAlias.startsWith("APP_")) {
            this.m_aMessageHandler.warn("The AS2 receiver key alias '" + this.m_sReceiverAS2KeyAlias + "' should start with 'APP_' for the use with the dynamic AS2 partnerships");
        } else if (this.m_sReceiverAS2ID != null && !this.m_sReceiverAS2ID.equals(this.m_sReceiverAS2KeyAlias)) {
            this.m_aMessageHandler.warn("The AS2 receiver key alias ('" + this.m_sReceiverAS2KeyAlias + "') should match the AS2 receiver ID ('" + this.m_sReceiverAS2ID + "')");
        }
        if (StringHelper.hasNoText((String)this.m_sReceiverAS2Url)) {
            this.m_aMessageHandler.error("The AS2 receiver URL (AS2 endpoint URL) is missing");
        } else if (URLHelper.getAsURL((String)this.m_sReceiverAS2Url) == null) {
            this.m_aMessageHandler.warn("The provided AS2 receiver URL '" + this.m_sReceiverAS2Url + "' seems to be an invalid URL");
        }
        if (this.m_aReceiverCert == null) {
            this.m_aMessageHandler.error("The receiver X.509 certificate is missing. Usually this is extracted from the SMP response");
        }
        if (this.m_eSigningAlgo == null) {
            this.m_aMessageHandler.error("The signing algorithm for the AS2 message is missing");
        }
        if (StringHelper.hasNoText((String)this.m_sMessageIDFormat)) {
            this.m_aMessageHandler.error("The AS2 message ID format is missing.");
        }
        if (this.m_aBusinessDocumentRes == null && this.m_aBusinessDocumentElement == null) {
            this.m_aMessageHandler.error("The XML business document to be send is missing.");
        } else if (this.m_aBusinessDocumentRes != null && !this.m_aBusinessDocumentRes.exists()) {
            this.m_aMessageHandler.error("The XML business document to be send '" + this.m_aBusinessDocumentRes.getPath() + "' does not exist.");
        }
        if (this.m_aPeppolSenderID == null) {
            this.m_aMessageHandler.error("The PEPPOL sender participant ID is missing");
        } else if (!IdentifierHelper.hasDefaultParticipantIdentifierScheme((IParticipantIdentifier)this.m_aPeppolSenderID)) {
            this.m_aMessageHandler.warn("The PEPPOL sender participant ID '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolSenderID) + "' is using a non-standard scheme!");
        }
        if (this.m_aPeppolReceiverID == null) {
            this.m_aMessageHandler.error("The PEPPOL receiver participant ID is missing");
        } else if (!IdentifierHelper.hasDefaultParticipantIdentifierScheme((IParticipantIdentifier)this.m_aPeppolReceiverID)) {
            this.m_aMessageHandler.warn("The PEPPOL receiver participant ID '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolReceiverID) + "' is using a non-standard scheme!");
        }
        if (this.m_aPeppolDocumentTypeID == null) {
            this.m_aMessageHandler.error("The PEPPOL document type ID is missing");
        } else if (!IdentifierHelper.hasDefaultDocumentTypeIdentifierScheme((IDocumentTypeIdentifier)this.m_aPeppolDocumentTypeID)) {
            this.m_aMessageHandler.warn("The PEPPOL document type ID '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolDocumentTypeID) + "' is using a non-standard scheme!");
        }
        if (this.m_aPeppolProcessID == null) {
            this.m_aMessageHandler.error("The PEPPOL process ID is missing");
        } else if (!IdentifierHelper.hasDefaultProcessIdentifierScheme((IProcessIdentifier)this.m_aPeppolProcessID)) {
            this.m_aMessageHandler.warn("The PEPPOL process ID '" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)this.m_aPeppolProcessID) + "' is using a non-standard scheme!");
        }
    }

    @Nonnull
    public AS2ClientResponse sendSynchronous() throws AS2ClientBuilderException {
        Document document;
        this.performSMPClientLookup();
        this.setDefaultDerivedValues();
        this.verifyContent();
        Element element = null;
        if (this.m_aBusinessDocumentRes != null) {
            try {
                document = DOMReader.readXMLDOM((IReadableResource)this.m_aBusinessDocumentRes);
                if (document == null) {
                    throw new AS2ClientBuilderException("Failed to read business document '" + this.m_aBusinessDocumentRes.getPath() + "' as XML");
                }
                element = document.getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new AS2ClientBuilderException("Failed to read business document '" + this.m_aBusinessDocumentRes.getPath() + "' as XML", sAXException);
            }
        } else {
            element = this.m_aBusinessDocumentElement;
        }
        if (element == null) {
            throw new AS2ClientBuilderException("No XML business content present!");
        }
        document = PeppolSBDHDocument.create((Element)element);
        document.setSenderWithDefaultScheme(this.m_aPeppolSenderID.getValue());
        document.setReceiver(this.m_aPeppolReceiverID.getScheme(), this.m_aPeppolReceiverID.getValue());
        document.setDocumentType(this.m_aPeppolDocumentTypeID.getScheme(), this.m_aPeppolDocumentTypeID.getValue());
        document.setProcess(this.m_aPeppolProcessID.getScheme(), this.m_aPeppolProcessID.getValue());
        StandardBusinessDocument standardBusinessDocument = new PeppolSBDHDocumentWriter().createStandardBusinessDocument((PeppolSBDHDocument)document);
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        if (new SBDMarshaller().write((Object)standardBusinessDocument, (Result)new StreamResult((OutputStream)nonBlockingByteArrayOutputStream)).isFailure()) {
            throw new AS2ClientBuilderException("Failed to serialize SBD!");
        }
        nonBlockingByteArrayOutputStream.close();
        AS2ClientSettings aS2ClientSettings = new AS2ClientSettings();
        aS2ClientSettings.setKeyStore(this.m_aKeyStoreFile, this.m_sKeyStorePassword);
        aS2ClientSettings.setSenderData(this.m_sSenderAS2ID, this.m_sSenderAS2Email, this.m_sSenderAS2KeyAlias);
        aS2ClientSettings.setReceiverData(this.m_sReceiverAS2ID, this.m_sReceiverAS2KeyAlias, this.m_sReceiverAS2Url);
        aS2ClientSettings.setReceiverCertificate(this.m_aReceiverCert);
        aS2ClientSettings.setPartnershipName(aS2ClientSettings.getSenderAS2ID() + "-" + aS2ClientSettings.getReceiverAS2ID());
        aS2ClientSettings.setMDNOptions(new DispositionOptions().setMICAlg(new ECryptoAlgorithmSign[]{this.m_eSigningAlgo}).setMICAlgImportance("required").setProtocol("pkcs7-signature").setProtocolImportance("required"));
        aS2ClientSettings.setEncryptAndSign(null, this.m_eSigningAlgo);
        aS2ClientSettings.setMessageIDFormat(this.m_sMessageIDFormat);
        AS2ClientRequest aS2ClientRequest = new AS2ClientRequest(this.m_sAS2Subject);
        aS2ClientRequest.setData(nonBlockingByteArrayOutputStream.getAsString(CCharset.CHARSET_UTF_8_OBJ), CCharset.CHARSET_UTF_8_OBJ);
        AS2Client aS2Client = (AS2Client)this.m_aAS2ClientFactory.create();
        AS2ClientResponse aS2ClientResponse = aS2Client.sendSynchronous(aS2ClientSettings, aS2ClientRequest);
        return aS2ClientResponse;
    }
}

