/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.as2client;

import com.helger.commons.ValueEnforcer;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

@Immutable
public final class AS2ClientHelper {
    private AS2ClientHelper() {
    }

    @Nonnull
    public static String getSubjectCommonName(@Nonnull X509Certificate x509Certificate) throws CertificateEncodingException {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Certificate");
        X500Name x500Name = new JcaX509CertificateHolder(x509Certificate).getSubject();
        RDN rDN = x500Name.getRDNs(BCStyle.CN)[0];
        return IETFUtils.valueToString((ASN1Encodable)rDN.getFirst().getValue());
    }
}

